/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.util.Map;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.external.feed.api.IFeed;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.api.IMetadataEntity;

public class Feed
implements IMetadataEntity<Feed>,
IFeed {
    private static final long serialVersionUID = 1L;
    public static final String EXTENSION_NAME = "Feed";
    private EntityId feedId;
    private String displayName;
    private String adapterName;
    private Map<String, String> adapterConfiguration;

    public Feed(String dataverseName, String feedName, String adapterName, Map<String, String> configuration) {
        this.feedId = new EntityId(EXTENSION_NAME, dataverseName, feedName);
        this.displayName = "(" + this.feedId + ")";
        this.adapterName = adapterName;
        this.adapterConfiguration = configuration;
    }

    public EntityId getFeedId() {
        return this.feedId;
    }

    public String getDataverseName() {
        return this.feedId.getDataverse();
    }

    public String getFeedName() {
        return this.feedId.getEntityName();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Feed)) {
            return false;
        }
        Feed otherFeed = (Feed)other;
        return otherFeed.getFeedId().equals((Object)this.feedId);
    }

    public int hashCode() {
        return this.displayName.hashCode();
    }

    public String toString() {
        return this.feedId.toString();
    }

    @Override
    public Feed addToCache(MetadataCache cache) {
        return cache.addFeedIfNotExists(this);
    }

    @Override
    public Feed dropFromCache(MetadataCache cache) {
        return cache.dropFeed(this);
    }

    public String getAdapterName() {
        return this.adapterName;
    }

    public Map<String, String> getAdapterConfiguration() {
        return this.adapterConfiguration;
    }
}

