/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.context.AsterixVirtualBufferCacheProvider;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.external.indexing.IndexingConstants;
import org.apache.asterix.metadata.api.IIndexDataflowHelperFactoryProvider;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.lock.ExternalDatasetsRegistry;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.ExternalIndexingOperations;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCacheProvider;
import org.apache.hyracks.storage.am.lsm.rtree.dataflow.ExternalRTreeDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.rtree.dataflow.LSMRTreeWithAntiMatterTuplesDataflowHelperFactory;
import org.apache.hyracks.storage.am.rtree.frames.RTreePolicyType;

public class RTreeDataflowHelperFactoryProvider
implements IIndexDataflowHelperFactoryProvider {
    public static final RTreeDataflowHelperFactoryProvider INSTANCE = new RTreeDataflowHelperFactoryProvider();

    private RTreeDataflowHelperFactoryProvider() {
    }

    protected RTreePolicyType rTreePolicyType() {
        return RTreePolicyType.RTREE;
    }

    @Override
    public IIndexDataflowHelperFactory getIndexDataflowHelperFactory(MetadataProvider mdProvider, Dataset dataset, Index index, ARecordType recordType, ARecordType metaType, ILSMMergePolicyFactory mergePolicyFactory, Map<String, String> mergePolicyProperties, ITypeTraits[] filterTypeTraits, IBinaryComparatorFactory[] filterCmpFactories) throws AlgebricksException {
        int i;
        if (index.getKeyFieldNames().size() != 1) {
            throw new CompilationException(1013, new Serializable[]{Integer.valueOf(index.getKeyFieldNames().size()), index.getIndexType(), Integer.valueOf(1)});
        }
        IAType spatialType = (IAType)Index.getNonNullableOpenFieldType((IAType)index.getKeyFieldTypes().get((int)0), index.getKeyFieldNames().get((int)0), (ARecordType)recordType).first;
        if (spatialType == null) {
            throw new CompilationException(1014, new Serializable[]{StringUtils.join((Collection)index.getKeyFieldNames().get(0), (char)'.')});
        }
        List<List<String>> primaryKeyFields = DatasetUtil.getPartitioningKeys(dataset);
        int numPrimaryKeys = primaryKeyFields.size();
        ITypeTraits[] primaryTypeTraits = null;
        IBinaryComparatorFactory[] primaryComparatorFactories = null;
        IStorageComponentProvider storageComponentProvider = mdProvider.getStorageComponentProvider();
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            primaryTypeTraits = new ITypeTraits[numPrimaryKeys + 1 + (dataset.hasMetaPart() ? 1 : 0)];
            primaryComparatorFactories = new IBinaryComparatorFactory[numPrimaryKeys];
            List<Integer> indicators = null;
            if (dataset.hasMetaPart()) {
                indicators = ((InternalDatasetDetails)dataset.getDatasetDetails()).getKeySourceIndicator();
            }
            for (int i2 = 0; i2 < numPrimaryKeys; ++i2) {
                IAType keyType = indicators == null || indicators.get(i2) == 0 ? recordType.getSubFieldType(primaryKeyFields.get(i2)) : metaType.getSubFieldType(primaryKeyFields.get(i2));
                primaryComparatorFactories[i2] = storageComponentProvider.getComparatorFactoryProvider().getBinaryComparatorFactory((Object)keyType, true);
                primaryTypeTraits[i2] = storageComponentProvider.getTypeTraitProvider().getTypeTrait((Object)keyType);
            }
            primaryTypeTraits[numPrimaryKeys] = storageComponentProvider.getTypeTraitProvider().getTypeTrait((Object)recordType);
            if (dataset.hasMetaPart()) {
                primaryTypeTraits[numPrimaryKeys + 1] = storageComponentProvider.getTypeTraitProvider().getTypeTrait((Object)recordType);
            }
        }
        boolean isPointMBR = spatialType.getTypeTag() == ATypeTag.POINT || spatialType.getTypeTag() == ATypeTag.POINT3D;
        int numDimensions = NonTaggedFormatUtil.getNumDimensions((ATypeTag)spatialType.getTypeTag());
        int numNestedSecondaryKeyFields = numDimensions * 2;
        IBinaryComparatorFactory[] secondaryComparatorFactories = new IBinaryComparatorFactory[numNestedSecondaryKeyFields];
        IPrimitiveValueProviderFactory[] valueProviderFactories = new IPrimitiveValueProviderFactory[numNestedSecondaryKeyFields];
        ITypeTraits[] secondaryTypeTraits = new ITypeTraits[numNestedSecondaryKeyFields + numPrimaryKeys];
        IAType nestedKeyType = NonTaggedFormatUtil.getNestedSpatialType((ATypeTag)spatialType.getTypeTag());
        ATypeTag keyType = nestedKeyType.getTypeTag();
        for (i = 0; i < numNestedSecondaryKeyFields; ++i) {
            secondaryComparatorFactories[i] = storageComponentProvider.getComparatorFactoryProvider().getBinaryComparatorFactory((Object)nestedKeyType, true);
            secondaryTypeTraits[i] = storageComponentProvider.getTypeTraitProvider().getTypeTrait((Object)nestedKeyType);
            valueProviderFactories[i] = storageComponentProvider.getPrimitiveValueProviderFactory();
        }
        for (i = 0; i < numPrimaryKeys; ++i) {
            secondaryTypeTraits[numNestedSecondaryKeyFields + i] = dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL ? primaryTypeTraits[i] : IndexingConstants.getTypeTraits((int)i);
        }
        int[] rtreeFields = null;
        if (filterTypeTraits != null && filterTypeTraits.length > 0) {
            rtreeFields = new int[numNestedSecondaryKeyFields + numPrimaryKeys];
            for (int i3 = 0; i3 < rtreeFields.length; ++i3) {
                rtreeFields[i3] = i3;
            }
        }
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            int[] nArray;
            if (filterTypeTraits != null && filterTypeTraits.length > 0) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = numNestedSecondaryKeyFields + numPrimaryKeys;
            } else {
                nArray = null;
            }
            int[] secondaryFilterFields = nArray;
            IBinaryComparatorFactory[] btreeCompFactories = RTreeDataflowHelperFactoryProvider.getComparatorFactoriesForDeletedKeyBTree(secondaryTypeTraits, primaryComparatorFactories, secondaryComparatorFactories);
            return new LSMRTreeWithAntiMatterTuplesDataflowHelperFactory(valueProviderFactories, this.rTreePolicyType(), btreeCompFactories, (IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(dataset.getDatasetId()), mergePolicyFactory, mergePolicyProperties, dataset.getIndexOperationTrackerFactory(index), storageComponentProvider.getIoOperationSchedulerProvider(), dataset.getIoOperationCallbackFactory(index), MetadataProvider.proposeLinearizer(keyType, secondaryComparatorFactories.length), rtreeFields, filterTypeTraits, filterCmpFactories, secondaryFilterFields, !dataset.getDatasetDetails().isTemp(), isPointMBR);
        }
        return new ExternalRTreeDataflowHelperFactory(valueProviderFactories, this.rTreePolicyType(), ExternalIndexingOperations.getBuddyBtreeComparatorFactories(), mergePolicyFactory, mergePolicyProperties, dataset.getIndexOperationTrackerFactory(index), storageComponentProvider.getIoOperationSchedulerProvider(), dataset.getIoOperationCallbackFactory(index), MetadataProvider.proposeLinearizer(keyType, secondaryComparatorFactories.length), mdProvider.getStorageProperties().getBloomFilterFalsePositiveRate(), new int[]{numNestedSecondaryKeyFields}, ExternalDatasetsRegistry.INSTANCE.getDatasetVersion(dataset), true, isPointMBR);
    }

    private static IBinaryComparatorFactory[] getComparatorFactoriesForDeletedKeyBTree(ITypeTraits[] secondaryTypeTraits, IBinaryComparatorFactory[] primaryComparatorFactories, IBinaryComparatorFactory[] secondaryComparatorFactories) {
        int i;
        IBinaryComparatorFactory[] btreeCompFactories = new IBinaryComparatorFactory[secondaryTypeTraits.length];
        for (i = 0; i < secondaryComparatorFactories.length; ++i) {
            btreeCompFactories[i] = secondaryComparatorFactories[i];
        }
        int j = 0;
        while (i < secondaryTypeTraits.length) {
            btreeCompFactories[i] = primaryComparatorFactories[j];
            ++i;
            ++j;
        }
        return btreeCompFactories;
    }
}

