/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.lock;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.lock.DatasetLock;
import org.apache.asterix.metadata.lock.IMetadataLock;
import org.apache.asterix.metadata.lock.LockList;
import org.apache.asterix.metadata.lock.MetadataLock;
import org.apache.asterix.metadata.utils.DatasetUtil;

public class MetadataLockManager {
    public static final MetadataLockManager INSTANCE = new MetadataLockManager();
    private static final Function<String, MetadataLock> LOCK_FUNCTION = key -> new MetadataLock();
    private static final Function<String, DatasetLock> DATASET_LOCK_FUNCTION = key -> new DatasetLock();
    private final ConcurrentHashMap<String, MetadataLock> dataversesLocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, DatasetLock> datasetsLocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, MetadataLock> functionsLocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, MetadataLock> nodeGroupsLocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, MetadataLock> feedsLocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, MetadataLock> feedPolicyLocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, MetadataLock> compactionPolicyLocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, MetadataLock> dataTypeLocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, MetadataLock> extensionLocks = new ConcurrentHashMap();

    private MetadataLockManager() {
    }

    public void acquireDataverseReadLock(LockList locks, String dataverseName) {
        MetadataLock lock = this.dataversesLocks.computeIfAbsent(dataverseName, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireDataverseWriteLock(LockList locks, String dataverseName) {
        MetadataLock lock = this.dataversesLocks.computeIfAbsent(dataverseName, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireDatasetReadLock(LockList locks, String datasetName) {
        DatasetLock lock = this.datasetsLocks.computeIfAbsent(datasetName, DATASET_LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireDatasetWriteLock(LockList locks, String datasetName) {
        DatasetLock lock = this.datasetsLocks.computeIfAbsent(datasetName, DATASET_LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireDatasetModifyLock(LockList locks, String datasetName) {
        DatasetLock lock = this.datasetsLocks.computeIfAbsent(datasetName, DATASET_LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.MODIFY, lock);
    }

    public void acquireDatasetCreateIndexLock(LockList locks, String datasetName) {
        DatasetLock lock = this.datasetsLocks.computeIfAbsent(datasetName, DATASET_LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.INDEX_BUILD, lock);
    }

    public void acquireExternalDatasetRefreshLock(LockList locks, String datasetName) {
        DatasetLock lock = this.datasetsLocks.computeIfAbsent(datasetName, DATASET_LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.INDEX_BUILD, lock);
    }

    public void acquireFunctionReadLock(LockList locks, String dataverseName) {
        MetadataLock lock = this.functionsLocks.computeIfAbsent(dataverseName, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireFunctionWriteLock(LockList locks, String dataverseName) {
        MetadataLock lock = this.functionsLocks.computeIfAbsent(dataverseName, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireNodeGroupReadLock(LockList locks, String dataverseName) {
        MetadataLock lock = this.nodeGroupsLocks.computeIfAbsent(dataverseName, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireNodeGroupWriteLock(LockList locks, String dataverseName) {
        MetadataLock lock = this.nodeGroupsLocks.computeIfAbsent(dataverseName, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireFeedReadLock(LockList locks, String dataverseName) {
        MetadataLock lock = this.feedsLocks.computeIfAbsent(dataverseName, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireFeedWriteLock(LockList locks, String dataverseName) {
        MetadataLock lock = this.feedsLocks.computeIfAbsent(dataverseName, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireFeedPolicyReadLock(LockList locks, String dataverseName) {
        MetadataLock lock = this.feedPolicyLocks.computeIfAbsent(dataverseName, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireFeedPolicyWriteLock(LockList locks, String dataverseName) {
        MetadataLock lock = this.feedPolicyLocks.computeIfAbsent(dataverseName, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireCompactionPolicyReadLock(LockList locks, String dataverseName) {
        MetadataLock lock = this.compactionPolicyLocks.computeIfAbsent(dataverseName, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireCompactionPolicyWriteLock(LockList locks, String dataverseName) {
        MetadataLock lock = this.compactionPolicyLocks.computeIfAbsent(dataverseName, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireDataTypeReadLock(LockList locks, String dataverseName) {
        MetadataLock lock = this.dataTypeLocks.computeIfAbsent(dataverseName, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireDataTypeWriteLock(LockList locks, String dataverseName) {
        MetadataLock lock = this.dataTypeLocks.computeIfAbsent(dataverseName, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireExtensionReadLock(LockList locks, String dataverseName) {
        MetadataLock lock = this.extensionLocks.computeIfAbsent(dataverseName, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireExtensionWriteLock(LockList locks, String dataverseName) {
        MetadataLock lock = this.extensionLocks.computeIfAbsent(dataverseName, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void createDatasetBegin(LockList locks, String dataverseName, String itemTypeDataverseName, String itemTypeFullyQualifiedName, String metaItemTypeDataverseName, String metaItemTypeFullyQualifiedName, String nodeGroupName, String compactionPolicyName, String datasetFullyQualifiedName, boolean isDefaultCompactionPolicy) {
        this.acquireDataverseReadLock(locks, dataverseName);
        if (!dataverseName.equals(itemTypeDataverseName)) {
            this.acquireDataverseReadLock(locks, itemTypeDataverseName);
        }
        if (metaItemTypeDataverseName != null && !metaItemTypeDataverseName.equals(dataverseName) && !metaItemTypeDataverseName.equals(itemTypeDataverseName)) {
            this.acquireDataverseReadLock(locks, metaItemTypeDataverseName);
        }
        this.acquireDataTypeReadLock(locks, itemTypeFullyQualifiedName);
        if (metaItemTypeFullyQualifiedName != null && !metaItemTypeFullyQualifiedName.equals(itemTypeFullyQualifiedName)) {
            this.acquireDataTypeReadLock(locks, metaItemTypeFullyQualifiedName);
        }
        this.acquireNodeGroupReadLock(locks, nodeGroupName);
        if (!isDefaultCompactionPolicy) {
            this.acquireCompactionPolicyReadLock(locks, compactionPolicyName);
        }
        this.acquireDatasetWriteLock(locks, datasetFullyQualifiedName);
    }

    public void createIndexBegin(LockList locks, String dataverseName, String datasetFullyQualifiedName) {
        this.acquireDataverseReadLock(locks, dataverseName);
        this.acquireDatasetCreateIndexLock(locks, datasetFullyQualifiedName);
    }

    public void createTypeBegin(LockList locks, String dataverseName, String itemTypeFullyQualifiedName) {
        this.acquireDataverseReadLock(locks, dataverseName);
        this.acquireDataTypeWriteLock(locks, itemTypeFullyQualifiedName);
    }

    public void dropDatasetBegin(LockList locks, String dataverseName, String datasetFullyQualifiedName) {
        this.acquireDataverseReadLock(locks, dataverseName);
        this.acquireDatasetWriteLock(locks, datasetFullyQualifiedName);
    }

    public void dropIndexBegin(LockList locks, String dataverseName, String datasetFullyQualifiedName) {
        this.acquireDataverseReadLock(locks, dataverseName);
        this.acquireDatasetWriteLock(locks, datasetFullyQualifiedName);
    }

    public void dropTypeBegin(LockList locks, String dataverseName, String dataTypeFullyQualifiedName) {
        this.acquireDataverseReadLock(locks, dataverseName);
        this.acquireDataTypeWriteLock(locks, dataTypeFullyQualifiedName);
    }

    public void functionStatementBegin(LockList locks, String dataverseName, String functionFullyQualifiedName) {
        this.acquireDataverseReadLock(locks, dataverseName);
        this.acquireFunctionWriteLock(locks, functionFullyQualifiedName);
    }

    public void modifyDatasetBegin(LockList locks, String dataverseName, String datasetFullyQualifiedName) {
        this.acquireDataverseReadLock(locks, dataverseName);
        this.acquireDatasetModifyLock(locks, datasetFullyQualifiedName);
    }

    public void insertDeleteUpsertBegin(LockList locks, String datasetFullyQualifiedName) {
        this.acquireDataverseReadLock(locks, DatasetUtil.getDataverseFromFullyQualifiedName(datasetFullyQualifiedName));
        this.acquireDatasetModifyLock(locks, datasetFullyQualifiedName);
    }

    public void dropFeedBegin(LockList locks, String dataverseName, String feedFullyQualifiedName) {
        this.acquireDataverseReadLock(locks, dataverseName);
        this.acquireFeedWriteLock(locks, feedFullyQualifiedName);
    }

    public void dropFeedPolicyBegin(LockList locks, String dataverseName, String policyName) {
        this.acquireFeedWriteLock(locks, policyName);
        this.acquireDataverseReadLock(locks, dataverseName);
    }

    public void startFeedBegin(LockList locks, String dataverseName, String feedName, List<FeedConnection> feedConnections) {
        this.acquireDataverseReadLock(locks, dataverseName);
        this.acquireFeedReadLock(locks, feedName);
        for (FeedConnection feedConnection : feedConnections) {
            String fqName = dataverseName + "." + feedConnection.getDatasetName();
            this.acquireDatasetReadLock(locks, fqName);
        }
    }

    public void stopFeedBegin(LockList locks, String dataverseName, String feedName) {
        this.acquireDataverseReadLock(locks, dataverseName);
        this.acquireFeedReadLock(locks, feedName);
    }

    public void createFeedBegin(LockList locks, String dataverseName, String feedFullyQualifiedName) {
        this.acquireDataverseReadLock(locks, dataverseName);
        this.acquireFeedWriteLock(locks, feedFullyQualifiedName);
    }

    public void connectFeedBegin(LockList locks, String dataverseName, String datasetFullyQualifiedName, String feedFullyQualifiedName) {
        this.acquireDataverseReadLock(locks, dataverseName);
        this.acquireDatasetReadLock(locks, datasetFullyQualifiedName);
        this.acquireFeedReadLock(locks, feedFullyQualifiedName);
    }

    public void createFeedPolicyBegin(LockList locks, String dataverseName, String policyName) {
        this.acquireDataverseReadLock(locks, dataverseName);
        this.acquireFeedPolicyWriteLock(locks, policyName);
    }

    public void disconnectFeedBegin(LockList locks, String dataverseName, String datasetFullyQualifiedName, String feedFullyQualifiedName) {
        this.acquireDataverseReadLock(locks, dataverseName);
        this.acquireDatasetReadLock(locks, datasetFullyQualifiedName);
        this.acquireFeedReadLock(locks, feedFullyQualifiedName);
    }

    public void compactBegin(LockList locks, String dataverseName, String datasetFullyQualifiedName) {
        this.acquireDataverseReadLock(locks, dataverseName);
        this.acquireDatasetReadLock(locks, datasetFullyQualifiedName);
    }

    public void refreshDatasetBegin(LockList locks, String dataverseName, String datasetFullyQualifiedName) {
        this.acquireDataverseReadLock(locks, dataverseName);
        this.acquireExternalDatasetRefreshLock(locks, datasetFullyQualifiedName);
    }
}

