/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.lock;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.asterix.metadata.lock.IMetadataLock;
import org.apache.asterix.om.base.AMutableInt32;

public class DatasetLock
implements IMetadataLock {
    private ReentrantReadWriteLock dsLock = new ReentrantReadWriteLock(true);
    private ReentrantReadWriteLock dsModifyLock = new ReentrantReadWriteLock(true);
    private AMutableInt32 indexBuildCounter = new AMutableInt32(0);

    private void acquireReadLock() {
        this.dsLock.readLock().lock();
    }

    private void releaseReadLock() {
        this.dsLock.readLock().unlock();
    }

    private void acquireWriteLock() {
        this.dsLock.writeLock().lock();
    }

    private void releaseWriteLock() {
        this.dsLock.writeLock().unlock();
    }

    private void acquireReadModifyLock() {
        this.dsModifyLock.readLock().lock();
    }

    private void releaseReadModifyLock() {
        this.dsModifyLock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireWriteModifyLock() {
        AMutableInt32 aMutableInt32 = this.indexBuildCounter;
        synchronized (aMutableInt32) {
            if (this.indexBuildCounter.getIntegerValue() > 0) {
                this.indexBuildCounter.setValue(this.indexBuildCounter.getIntegerValue() + 1);
            } else {
                this.dsModifyLock.writeLock().lock();
                this.indexBuildCounter.setValue(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWriteModifyLock() {
        AMutableInt32 aMutableInt32 = this.indexBuildCounter;
        synchronized (aMutableInt32) {
            if (this.indexBuildCounter.getIntegerValue() == 1) {
                this.dsModifyLock.writeLock().unlock();
            }
            this.indexBuildCounter.setValue(this.indexBuildCounter.getIntegerValue() - 1);
        }
    }

    private void acquireRefreshLock() {
        this.dsModifyLock.writeLock().lock();
    }

    private void releaseRefreshLock() {
        this.dsModifyLock.writeLock().unlock();
    }

    @Override
    public void acquire(IMetadataLock.Mode mode) {
        switch (mode) {
            case INDEX_BUILD: {
                this.acquireReadLock();
                this.acquireWriteModifyLock();
                break;
            }
            case MODIFY: {
                this.acquireReadLock();
                this.acquireReadModifyLock();
                break;
            }
            case REFRESH: {
                this.acquireReadLock();
                this.acquireRefreshLock();
                break;
            }
            case INDEX_DROP: 
            case WRITE: {
                this.acquireWriteLock();
                break;
            }
            default: {
                this.acquireReadLock();
            }
        }
    }

    @Override
    public void release(IMetadataLock.Mode mode) {
        switch (mode) {
            case INDEX_BUILD: {
                this.releaseWriteModifyLock();
                this.releaseReadLock();
                break;
            }
            case MODIFY: {
                this.releaseReadModifyLock();
                this.releaseReadLock();
                break;
            }
            case REFRESH: {
                this.releaseRefreshLock();
                this.releaseReadLock();
                break;
            }
            case INDEX_DROP: 
            case WRITE: {
                this.releaseWriteLock();
                break;
            }
            default: {
                this.releaseReadLock();
            }
        }
    }
}

