/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.active.ActiveJobNotificationHandler;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.NoOpFrameOperationCallbackFactory;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.ioopcallbacks.LSMBTreeIOOperationCallbackFactory;
import org.apache.asterix.common.ioopcallbacks.LSMBTreeWithBuddyIOOperationCallbackFactory;
import org.apache.asterix.common.ioopcallbacks.LSMInvertedIndexIOOperationCallbackFactory;
import org.apache.asterix.common.ioopcallbacks.LSMRTreeIOOperationCallbackFactory;
import org.apache.asterix.common.metadata.IDataset;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.common.utils.JobUtils;
import org.apache.asterix.metadata.IDatasetDetails;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.api.IMetadataEntity;
import org.apache.asterix.metadata.declared.BTreeDataflowHelperFactoryProvider;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.lock.ExternalDatasetsRegistry;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.ExternalIndexingOperations;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.metadata.utils.InvertedIndexDataflowHelperFactoryProvider;
import org.apache.asterix.metadata.utils.MetadataUtil;
import org.apache.asterix.metadata.utils.RTreeDataflowHelperFactoryProvider;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.asterix.transaction.management.opcallbacks.AbstractIndexModificationOperationCallback;
import org.apache.asterix.transaction.management.opcallbacks.LockThenSearchOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexInstantSearchOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexModificationOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexOperationTrackerFactory;
import org.apache.asterix.transaction.management.opcallbacks.SecondaryIndexModificationOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.SecondaryIndexOperationTrackerFactory;
import org.apache.asterix.transaction.management.opcallbacks.SecondaryIndexSearchOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.TempDatasetPrimaryIndexModificationOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.TempDatasetSecondaryIndexModificationOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.UpsertOperationCallbackFactory;
import org.apache.asterix.transaction.management.runtime.CommitRuntimeFactory;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.IFrameOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTrackerFactory;

public class Dataset
implements IMetadataEntity<Dataset>,
IDataset {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(Dataset.class.getName());
    private static final BTreeDataflowHelperFactoryProvider bTreeDataflowHelperFactoryProvider = BTreeDataflowHelperFactoryProvider.INSTANCE;
    private static final RTreeDataflowHelperFactoryProvider rTreeDataflowHelperFactoryProvider = RTreeDataflowHelperFactoryProvider.INSTANCE;
    private static final InvertedIndexDataflowHelperFactoryProvider invertedIndexDataflowHelperFactoryProvider = InvertedIndexDataflowHelperFactoryProvider.INSTANCE;
    private final int datasetId;
    private final String dataverseName;
    private final String datasetName;
    private final String recordTypeDataverseName;
    private final String recordTypeName;
    private final String nodeGroupName;
    private final String compactionPolicyFactory;
    private final Map<String, String> hints;
    private final Map<String, String> compactionPolicyProperties;
    private final DatasetConfig.DatasetType datasetType;
    private final IDatasetDetails datasetDetails;
    private final String metaTypeDataverseName;
    private final String metaTypeName;
    private int pendingOp;

    public Dataset(String dataverseName, String datasetName, String recordTypeDataverseName, String recordTypeName, String nodeGroupName, String compactionPolicy, Map<String, String> compactionPolicyProperties, IDatasetDetails datasetDetails, Map<String, String> hints, DatasetConfig.DatasetType datasetType, int datasetId, int pendingOp) {
        this(dataverseName, datasetName, recordTypeDataverseName, recordTypeName, null, null, nodeGroupName, compactionPolicy, compactionPolicyProperties, datasetDetails, hints, datasetType, datasetId, pendingOp);
    }

    public Dataset(String dataverseName, String datasetName, String itemTypeDataverseName, String itemTypeName, String metaItemTypeDataverseName, String metaItemTypeName, String nodeGroupName, String compactionPolicy, Map<String, String> compactionPolicyProperties, IDatasetDetails datasetDetails, Map<String, String> hints, DatasetConfig.DatasetType datasetType, int datasetId, int pendingOp) {
        this.dataverseName = dataverseName;
        this.datasetName = datasetName;
        this.recordTypeName = itemTypeName;
        this.recordTypeDataverseName = itemTypeDataverseName;
        this.metaTypeDataverseName = metaItemTypeDataverseName;
        this.metaTypeName = metaItemTypeName;
        this.nodeGroupName = nodeGroupName;
        this.compactionPolicyFactory = compactionPolicy;
        this.compactionPolicyProperties = compactionPolicyProperties;
        this.datasetType = datasetType;
        this.datasetDetails = datasetDetails;
        this.datasetId = datasetId;
        this.pendingOp = pendingOp;
        this.hints = hints;
    }

    public Dataset(Dataset dataset) {
        this(dataset.dataverseName, dataset.datasetName, dataset.recordTypeDataverseName, dataset.recordTypeName, dataset.metaTypeDataverseName, dataset.metaTypeName, dataset.nodeGroupName, dataset.compactionPolicyFactory, dataset.compactionPolicyProperties, dataset.datasetDetails, dataset.hints, dataset.datasetType, dataset.datasetId, dataset.pendingOp);
    }

    public String getDataverseName() {
        return this.dataverseName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public String getItemTypeName() {
        return this.recordTypeName;
    }

    public String getItemTypeDataverseName() {
        return this.recordTypeDataverseName;
    }

    public String getNodeGroupName() {
        return this.nodeGroupName;
    }

    public String getCompactionPolicy() {
        return this.compactionPolicyFactory;
    }

    public Map<String, String> getCompactionPolicyProperties() {
        return this.compactionPolicyProperties;
    }

    public DatasetConfig.DatasetType getDatasetType() {
        return this.datasetType;
    }

    public IDatasetDetails getDatasetDetails() {
        return this.datasetDetails;
    }

    public Map<String, String> getHints() {
        return this.hints;
    }

    public int getDatasetId() {
        return this.datasetId;
    }

    public int getPendingOp() {
        return this.pendingOp;
    }

    public String getMetaItemTypeDataverseName() {
        return this.metaTypeDataverseName;
    }

    public String getMetaItemTypeName() {
        return this.metaTypeName;
    }

    public boolean hasMetaPart() {
        return this.metaTypeDataverseName != null && this.metaTypeName != null;
    }

    public void setPendingOp(int pendingOp) {
        this.pendingOp = pendingOp;
    }

    @Override
    public Dataset addToCache(MetadataCache cache) {
        return cache.addDatasetIfNotExists(this);
    }

    @Override
    public Dataset dropFromCache(MetadataCache cache) {
        return cache.dropDataset(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Dataset)) {
            return false;
        }
        Dataset otherDataset = (Dataset)other;
        return Objects.equals(this.dataverseName, otherDataset.dataverseName) && Objects.equals(this.datasetName, otherDataset.datasetName);
    }

    public boolean allow(ILogicalOperator topOp, byte operation) {
        return !this.hasMetaPart();
    }

    public void drop(MetadataProvider metadataProvider, MutableObject<MetadataTransactionContext> mdTxnCtx, List<JobSpecification> jobsToExecute, MutableBoolean bActiveTxn, MutableObject<JobUtils.ProgressState> progress, IHyracksClientConnection hcc) throws Exception {
        HashMap disconnectJobList = new HashMap();
        if (this.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            IActiveEntityEventsListener[] activeListeners;
            for (IActiveEntityEventsListener listener : activeListeners = ActiveJobNotificationHandler.INSTANCE.getEventListeners()) {
                if (!listener.isEntityUsingDataset((IDataset)this)) continue;
                throw new CompilationException(1023, new Serializable[]{RecordUtil.toFullyQualifiedName((String[])new String[]{this.dataverseName, this.datasetName}), listener.getEntityId().toString()});
            }
            List<Index> indexes = MetadataManager.INSTANCE.getDatasetIndexes((MetadataTransactionContext)mdTxnCtx.getValue(), this.dataverseName, this.datasetName);
            for (int j = 0; j < indexes.size(); ++j) {
                if (!indexes.get(j).isSecondaryIndex()) continue;
                jobsToExecute.add(IndexUtil.buildDropIndexJobSpec(indexes.get(j), metadataProvider, this));
            }
            Index primaryIndex = MetadataManager.INSTANCE.getIndex((MetadataTransactionContext)mdTxnCtx.getValue(), this.dataverseName, this.datasetName, this.datasetName);
            jobsToExecute.add(DatasetUtil.createDropDatasetJobSpec(this, primaryIndex, metadataProvider));
            MetadataManager.INSTANCE.dropDataset((MetadataTransactionContext)mdTxnCtx.getValue(), this.dataverseName, this.datasetName);
            MetadataManager.INSTANCE.addDataset((MetadataTransactionContext)mdTxnCtx.getValue(), new Dataset(this.dataverseName, this.datasetName, this.getItemTypeDataverseName(), this.getItemTypeName(), this.getMetaItemTypeDataverseName(), this.getMetaItemTypeName(), this.getNodeGroupName(), this.getCompactionPolicy(), this.getCompactionPolicyProperties(), this.getDatasetDetails(), this.getHints(), this.getDatasetType(), this.getDatasetId(), 2));
            MetadataManager.INSTANCE.commitTransaction((MetadataTransactionContext)mdTxnCtx.getValue());
            bActiveTxn.setValue(false);
            progress.setValue((Object)JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA);
            for (Pair p : disconnectJobList.values()) {
                JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)((JobSpecification)p.first), (boolean)true);
            }
            for (JobSpecification jobSpec : jobsToExecute) {
                JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
            }
            mdTxnCtx.setValue((Object)MetadataManager.INSTANCE.beginTransaction());
            bActiveTxn.setValue(true);
            metadataProvider.setMetadataTxnContext((MetadataTransactionContext)mdTxnCtx.getValue());
        } else {
            ExternalDatasetsRegistry.INSTANCE.removeDatasetInfo(this);
            List<Index> indexes = MetadataManager.INSTANCE.getDatasetIndexes((MetadataTransactionContext)mdTxnCtx.getValue(), this.dataverseName, this.datasetName);
            for (int j = 0; j < indexes.size(); ++j) {
                if (ExternalIndexingOperations.isFileIndex(indexes.get(j))) {
                    jobsToExecute.add(IndexUtil.buildDropIndexJobSpec(indexes.get(j), metadataProvider, this));
                    continue;
                }
                jobsToExecute.add(DatasetUtil.buildDropFilesIndexJobSpec(metadataProvider, this));
            }
            MetadataManager.INSTANCE.dropDataset((MetadataTransactionContext)mdTxnCtx.getValue(), this.dataverseName, this.datasetName);
            MetadataManager.INSTANCE.addDataset((MetadataTransactionContext)mdTxnCtx.getValue(), new Dataset(this.dataverseName, this.datasetName, this.getItemTypeDataverseName(), this.getItemTypeName(), this.getNodeGroupName(), this.getCompactionPolicy(), this.getCompactionPolicyProperties(), this.getDatasetDetails(), this.getHints(), this.getDatasetType(), this.getDatasetId(), 2));
            MetadataManager.INSTANCE.commitTransaction((MetadataTransactionContext)mdTxnCtx.getValue());
            bActiveTxn.setValue(false);
            progress.setValue((Object)JobUtils.ProgressState.ADDED_PENDINGOP_RECORD_TO_METADATA);
            for (JobSpecification jobSpec : jobsToExecute) {
                JobUtils.runJob((IHyracksClientConnection)hcc, (JobSpecification)jobSpec, (boolean)true);
            }
            if (!indexes.isEmpty()) {
                ExternalDatasetsRegistry.INSTANCE.removeDatasetInfo(this);
            }
            mdTxnCtx.setValue((Object)MetadataManager.INSTANCE.beginTransaction());
            bActiveTxn.setValue(true);
            metadataProvider.setMetadataTxnContext((MetadataTransactionContext)mdTxnCtx.getValue());
        }
        MetadataManager.INSTANCE.dropDataset((MetadataTransactionContext)mdTxnCtx.getValue(), this.dataverseName, this.datasetName);
        String nodegroup = this.getNodeGroupName();
        if (!nodegroup.equalsIgnoreCase("DEFAULT_NG_ALL_NODES")) {
            MetadataManager.INSTANCE.dropNodegroup((MetadataTransactionContext)mdTxnCtx.getValue(), this.dataverseName + ":" + this.datasetName);
        }
    }

    public IIndexDataflowHelperFactory getIndexDataflowHelperFactory(MetadataProvider mdProvider, Index index, ARecordType recordType, ARecordType metaType, ILSMMergePolicyFactory mergePolicyFactory, Map<String, String> mergePolicyProperties) throws AlgebricksException {
        ITypeTraits[] filterTypeTraits = DatasetUtil.computeFilterTypeTraits(this, recordType);
        IBinaryComparatorFactory[] filterCmpFactories = DatasetUtil.computeFilterBinaryComparatorFactories(this, recordType, mdProvider.getStorageComponentProvider().getComparatorFactoryProvider());
        switch (index.getIndexType()) {
            case BTREE: {
                return bTreeDataflowHelperFactoryProvider.getIndexDataflowHelperFactory(mdProvider, this, index, recordType, metaType, mergePolicyFactory, mergePolicyProperties, filterTypeTraits, filterCmpFactories);
            }
            case RTREE: {
                return rTreeDataflowHelperFactoryProvider.getIndexDataflowHelperFactory(mdProvider, this, index, recordType, metaType, mergePolicyFactory, mergePolicyProperties, filterTypeTraits, filterCmpFactories);
            }
            case LENGTH_PARTITIONED_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: 
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case SINGLE_PARTITION_WORD_INVIX: {
                return invertedIndexDataflowHelperFactoryProvider.getIndexDataflowHelperFactory(mdProvider, this, index, recordType, metaType, mergePolicyFactory, mergePolicyProperties, filterTypeTraits, filterCmpFactories);
            }
        }
        throw new CompilationException(1012, new Serializable[]{index.getIndexType().toString()});
    }

    public ILSMIOOperationCallbackFactory getIoOperationCallbackFactory(Index index) throws AlgebricksException {
        switch (index.getIndexType()) {
            case BTREE: {
                return this.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL && !index.getIndexName().equals(BTreeDataflowHelperFactoryProvider.externalFileIndexName(this)) ? LSMBTreeWithBuddyIOOperationCallbackFactory.INSTANCE : LSMBTreeIOOperationCallbackFactory.INSTANCE;
            }
            case RTREE: {
                return LSMRTreeIOOperationCallbackFactory.INSTANCE;
            }
            case LENGTH_PARTITIONED_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: 
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case SINGLE_PARTITION_WORD_INVIX: {
                return LSMInvertedIndexIOOperationCallbackFactory.INSTANCE;
            }
        }
        throw new CompilationException(1012, new Serializable[]{index.getIndexType().toString()});
    }

    public ILSMOperationTrackerFactory getIndexOperationTrackerFactory(Index index) {
        return index.isPrimaryIndex() ? new PrimaryIndexOperationTrackerFactory(this.getDatasetId()) : new SecondaryIndexOperationTrackerFactory(this.getDatasetId());
    }

    public ISearchOperationCallbackFactory getSearchCallbackFactory(IStorageComponentProvider storageComponentProvider, Index index, JobId jobId, IndexOperation op, int[] primaryKeyFields) throws AlgebricksException {
        if (this.getDatasetDetails().isTemp()) {
            return NoOpOperationCallbackFactory.INSTANCE;
        }
        if (index.isPrimaryIndex()) {
            return op == IndexOperation.UPSERT ? new LockThenSearchOperationCallbackFactory(jobId, this.getDatasetId(), primaryKeyFields, storageComponentProvider.getTransactionSubsystemProvider(), 0) : new PrimaryIndexInstantSearchOperationCallbackFactory(jobId, this.getDatasetId(), primaryKeyFields, storageComponentProvider.getTransactionSubsystemProvider(), 0);
        }
        return new SecondaryIndexSearchOperationCallbackFactory();
    }

    public IModificationOperationCallbackFactory getModificationCallbackFactory(IStorageComponentProvider componentProvider, Index index, JobId jobId, IndexOperation op, int[] primaryKeyFields) throws AlgebricksException {
        if (this.getDatasetDetails().isTemp()) {
            return op == IndexOperation.DELETE || op == IndexOperation.INSERT || op == IndexOperation.UPSERT ? (index.isPrimaryIndex() ? new TempDatasetPrimaryIndexModificationOperationCallbackFactory(jobId, this.datasetId, primaryKeyFields, componentProvider.getTransactionSubsystemProvider(), AbstractIndexModificationOperationCallback.Operation.get((IndexOperation)op), index.resourceType()) : new TempDatasetSecondaryIndexModificationOperationCallbackFactory(jobId, this.getDatasetId(), primaryKeyFields, componentProvider.getTransactionSubsystemProvider(), AbstractIndexModificationOperationCallback.Operation.get((IndexOperation)op), index.resourceType())) : NoOpOperationCallbackFactory.INSTANCE;
        }
        if (index.isPrimaryIndex()) {
            return op == IndexOperation.UPSERT ? new UpsertOperationCallbackFactory(jobId, this.getDatasetId(), primaryKeyFields, componentProvider.getTransactionSubsystemProvider(), AbstractIndexModificationOperationCallback.Operation.get((IndexOperation)op), index.resourceType()) : (op == IndexOperation.DELETE || op == IndexOperation.INSERT ? new PrimaryIndexModificationOperationCallbackFactory(jobId, this.getDatasetId(), primaryKeyFields, componentProvider.getTransactionSubsystemProvider(), AbstractIndexModificationOperationCallback.Operation.get((IndexOperation)op), index.resourceType()) : NoOpOperationCallbackFactory.INSTANCE);
        }
        return op == IndexOperation.DELETE || op == IndexOperation.INSERT || op == IndexOperation.UPSERT ? new SecondaryIndexModificationOperationCallbackFactory(jobId, this.getDatasetId(), primaryKeyFields, componentProvider.getTransactionSubsystemProvider(), AbstractIndexModificationOperationCallback.Operation.get((IndexOperation)op), index.resourceType()) : NoOpOperationCallbackFactory.INSTANCE;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(this.toMap());
        }
        catch (JsonProcessingException e) {
            LOGGER.log(Level.WARNING, "Unable to convert map to json String", e);
            return this.dataverseName + "." + this.datasetName;
        }
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> tree = new HashMap<String, Object>();
        tree.put("datasetId", Integer.toString(this.datasetId));
        tree.put("dataverseName", this.dataverseName);
        tree.put("datasetName", this.datasetName);
        tree.put("recordTypeDataverseName", this.recordTypeDataverseName);
        tree.put("recordTypeName", this.recordTypeName);
        tree.put("nodeGroupName", this.nodeGroupName);
        tree.put("compactionPolicyFactory", this.compactionPolicyFactory);
        tree.put("hints", this.hints);
        tree.put("compactionPolicyProperties", this.compactionPolicyProperties);
        tree.put("datasetType", this.datasetType.name());
        tree.put("datasetDetails", this.datasetDetails.toString());
        tree.put("metaTypeDataverseName", this.metaTypeDataverseName);
        tree.put("metaTypeName", this.metaTypeName);
        tree.put("pendingOp", MetadataUtil.pendingOpToString(this.pendingOp));
        return tree;
    }

    public int hashCode() {
        return Objects.hash(this.dataverseName, this.datasetName);
    }

    public IPushRuntimeFactory getCommitRuntimeFactory(JobId jobId, int[] primaryKeyFields, MetadataProvider metadataProvider, int[] datasetPartitions, boolean isSink) {
        return new CommitRuntimeFactory(jobId, this.datasetId, primaryKeyFields, metadataProvider.isTemporaryDatasetWriteJob(), metadataProvider.isWriteTransaction(), datasetPartitions, isSink);
    }

    public IIndexDataflowHelperFactory getIndexDataflowHelperFactory(MetadataProvider mdProvider) throws AlgebricksException {
        if (this.getDatasetType() != DatasetConfig.DatasetType.INTERNAL) {
            throw new AlgebricksException("ASX", 1027, new Serializable[]{this.getDatasetType()});
        }
        Index index = mdProvider.getIndex(this.getDataverseName(), this.getDatasetName(), this.getDatasetName());
        ARecordType recordType = (ARecordType)mdProvider.findType(this.getItemTypeDataverseName(), this.getItemTypeName());
        ARecordType metaType = (ARecordType)mdProvider.findType(this.getMetaItemTypeDataverseName(), this.getMetaItemTypeName());
        Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtil.getMergePolicyFactory(this, mdProvider.getMetadataTxnContext());
        return this.getIndexDataflowHelperFactory(mdProvider, index, recordType, metaType, (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second);
    }

    public IFrameOperationCallbackFactory getFrameOpCallbackFactory() {
        return NoOpFrameOperationCallbackFactory.INSTANCE;
    }

    public boolean isTemp() {
        return this.getDatasetDetails().isTemp();
    }
}

