/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.cluster;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.asterix.common.api.IClusterEventsSubscriber;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.common.config.ClusterProperties;
import org.apache.asterix.common.config.ExternalProperties;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.event.management.AsterixEventServiceClient;
import org.apache.asterix.event.model.AsterixInstance;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.cluster.Node;
import org.apache.asterix.event.schema.pattern.Pattern;
import org.apache.asterix.event.schema.pattern.Patterns;
import org.apache.asterix.event.service.AsterixEventService;
import org.apache.asterix.event.service.AsterixEventServiceUtil;
import org.apache.asterix.event.service.ILookupService;
import org.apache.asterix.event.service.ServiceProvider;
import org.apache.asterix.event.util.PatternCreator;
import org.apache.asterix.installer.schema.conf.Configuration;
import org.apache.asterix.metadata.api.IClusterManager;
import org.apache.asterix.metadata.cluster.ClusterManagerProvider;
import org.apache.asterix.runtime.utils.AppContextInfo;

public class ClusterManager
implements IClusterManager {
    private static final Logger LOGGER = Logger.getLogger(ClusterManager.class.getName());
    public static final IClusterManager INSTANCE = ClusterManagerProvider.getClusterManager();
    private final AsterixEventServiceClient client;
    private final ILookupService lookupService;
    private final Set<IClusterEventsSubscriber> eventSubscribers = new HashSet<IClusterEventsSubscriber>();

    ClusterManager(String eventHome) {
        String asterixDir = System.getProperty("user.dir") + File.separator + "asterix";
        File configFile = new File(System.getProperty("user.dir") + File.separator + "configuration.xml");
        Configuration configuration = null;
        try {
            JAXBContext configCtx = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
            Unmarshaller unmarshaller = configCtx.createUnmarshaller();
            configuration = (Configuration)unmarshaller.unmarshal(configFile);
            AsterixEventService.initialize((Configuration)configuration, (String)asterixDir, (String)eventHome);
            this.client = AsterixEventService.getAsterixEventServiceClient((Cluster)ClusterProperties.INSTANCE.getCluster());
            this.lookupService = ServiceProvider.INSTANCE.getLookupService();
            if (!this.lookupService.isRunning(configuration)) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Lookup service not running. Starting lookup service ...");
                }
                this.lookupService.startService(configuration);
            } else if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Lookup service running");
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to initialize cluster manager" + e);
        }
    }

    @Override
    public void addNode(Node node) throws AsterixException {
        try {
            Cluster cluster = ClusterProperties.INSTANCE.getCluster();
            ArrayList<Pattern> pattern = new ArrayList<Pattern>();
            String asterixInstanceName = AppContextInfo.INSTANCE.getMetadataProperties().getInstanceName();
            Patterns prepareNode = PatternCreator.INSTANCE.createPrepareNodePattern(asterixInstanceName, ClusterProperties.INSTANCE.getCluster(), node);
            cluster.getNode().add(node);
            this.client.submit(prepareNode);
            ExternalProperties externalProps = AppContextInfo.INSTANCE.getExternalProperties();
            AsterixEventServiceUtil.poulateClusterEnvironmentProperties((Cluster)cluster, (String)externalProps.getCCJavaParams(), (String)externalProps.getNCJavaParams());
            pattern.clear();
            String ccHost = cluster.getMasterNode().getClusterIp();
            String hostId = node.getId();
            String nodeControllerId = asterixInstanceName + "_" + node.getId();
            String iodevices = node.getIodevices() == null ? cluster.getIodevices() : node.getIodevices();
            Pattern startNC = PatternCreator.INSTANCE.createNCStartPattern(ccHost, hostId, nodeControllerId, iodevices, false);
            pattern.add(startNC);
            Patterns startNCPattern = new Patterns(pattern);
            this.client.submit(startNCPattern);
            this.removeNode(cluster.getSubstituteNodes().getNode(), node);
            AsterixInstance instance = this.lookupService.getAsterixInstance(cluster.getInstanceName());
            instance.getCluster().getNode().add(node);
            this.removeNode(instance.getCluster().getSubstituteNodes().getNode(), node);
            this.lookupService.updateAsterixInstance(instance);
        }
        catch (Exception e) {
            throw new AsterixException((Throwable)e);
        }
    }

    private void removeNode(List<Node> list, Node node) {
        Node nodeToRemove = null;
        for (Node n : list) {
            if (!n.getId().equals(node.getId())) continue;
            nodeToRemove = n;
            break;
        }
        if (nodeToRemove != null) {
            boolean removed = list.remove(nodeToRemove);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("attempt to remove node :" + nodeToRemove + " successful " + removed);
            }
        }
    }

    @Override
    public void removeNode(Node node) throws AsterixException {
    }

    @Override
    public void registerSubscriber(IClusterEventsSubscriber subscriber) {
        this.eventSubscribers.add(subscriber);
    }

    @Override
    public boolean deregisterSubscriber(IClusterEventsSubscriber subscriber) {
        return this.eventSubscribers.remove(subscriber);
    }

    @Override
    public Set<IClusterEventsSubscriber> getRegisteredClusterEventSubscribers() {
        return this.eventSubscribers;
    }

    @Override
    public void notifyStartupCompleted() throws Exception {
        this.lookupService.reportClusterState(ClusterProperties.INSTANCE.getCluster().getInstanceName(), IClusterManagementWork.ClusterState.ACTIVE);
    }
}

