/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata;

import java.util.ArrayList;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.external.dataset.adapter.AdapterIdentifier;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.Library;
import org.apache.asterix.metadata.entities.NodeGroup;

public class MetadataTransactionContext
extends MetadataCache {
    protected MetadataCache droppedCache = new MetadataCache();
    protected ArrayList<MetadataCache.MetadataLogicalOperation> opLog = new ArrayList();
    private final JobId jobId;

    public MetadataTransactionContext(JobId jobId) {
        this.jobId = jobId;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public void addDataverse(Dataverse dataverse) {
        this.droppedCache.dropDataverse(dataverse);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(dataverse, true));
    }

    public void addDataset(Dataset dataset) {
        this.droppedCache.dropDataset(dataset);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(dataset, true));
    }

    public void addIndex(Index index) {
        this.droppedCache.dropIndex(index);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(index, true));
    }

    public void addDatatype(Datatype datatype) {
        this.droppedCache.dropDatatype(datatype);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(datatype, true));
    }

    public void addNodeGroup(NodeGroup nodeGroup) {
        this.droppedCache.dropNodeGroup(nodeGroup);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(nodeGroup, true));
    }

    public void addFunction(Function function) {
        this.droppedCache.dropFunction(function);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(function, true));
    }

    public void addAdapter(DatasourceAdapter adapter) {
        this.droppedCache.dropAdapter(adapter);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(adapter, true));
    }

    public void addCompactionPolicy(CompactionPolicy compactionPolicy) {
        this.droppedCache.dropCompactionPolicy(compactionPolicy);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(compactionPolicy, true));
    }

    public void dropDataset(String dataverseName, String datasetName) {
        Dataset dataset = new Dataset(dataverseName, datasetName, null, null, null, null, null, null, null, null, -1, 0);
        this.droppedCache.addDatasetIfNotExists(dataset);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(dataset, false));
    }

    public void dropIndex(String dataverseName, String datasetName, String indexName) {
        Index index = new Index(dataverseName, datasetName, indexName, null, null, null, null, false, false, 0);
        this.droppedCache.addIndexIfNotExists(index);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(index, false));
    }

    public void dropDataverse(String dataverseName) {
        Dataverse dataverse = new Dataverse(dataverseName, null, 0);
        this.droppedCache.addDataverseIfNotExists(dataverse);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(dataverse, false));
    }

    public void addLibrary(Library library) {
        this.droppedCache.dropLibrary(library);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(library, true));
    }

    public void dropDataDatatype(String dataverseName, String datatypeName) {
        Datatype datatype = new Datatype(dataverseName, datatypeName, null, false);
        this.droppedCache.addDatatypeIfNotExists(datatype);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(datatype, false));
    }

    public void dropNodeGroup(String nodeGroupName) {
        NodeGroup nodeGroup = new NodeGroup(nodeGroupName, null);
        this.droppedCache.addNodeGroupIfNotExists(nodeGroup);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(nodeGroup, false));
    }

    public void dropFunction(FunctionSignature signature) {
        Function function = new Function(signature.getNamespace(), signature.getName(), signature.getArity(), null, null, null, null, null);
        this.droppedCache.addFunctionIfNotExists(function);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(function, false));
    }

    public void dropAdapter(String dataverseName, String adapterName) {
        AdapterIdentifier adapterIdentifier = new AdapterIdentifier(dataverseName, adapterName);
        DatasourceAdapter adapter = new DatasourceAdapter(adapterIdentifier, null, null);
        this.droppedCache.addAdapterIfNotExists(adapter);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(adapter, false));
    }

    public void dropLibrary(String dataverseName, String libraryName) {
        Library library = new Library(dataverseName, libraryName);
        this.droppedCache.addLibraryIfNotExists(library);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(library, false));
    }

    public void logAndApply(MetadataCache.MetadataLogicalOperation op) {
        this.opLog.add(op);
        this.doOperation(op);
    }

    public boolean dataverseIsDropped(String dataverseName) {
        return this.droppedCache.getDataverse(dataverseName) != null;
    }

    public boolean datasetIsDropped(String dataverseName, String datasetName) {
        if (this.droppedCache.getDataverse(dataverseName) != null) {
            return true;
        }
        return this.droppedCache.getDataset(dataverseName, datasetName) != null;
    }

    public boolean indexIsDropped(String dataverseName, String datasetName, String indexName) {
        if (this.droppedCache.getDataverse(dataverseName) != null) {
            return true;
        }
        if (this.droppedCache.getDataset(dataverseName, datasetName) != null) {
            return true;
        }
        return this.droppedCache.getIndex(dataverseName, datasetName, indexName) != null;
    }

    public boolean datatypeIsDropped(String dataverseName, String datatypeName) {
        if (this.droppedCache.getDataverse(dataverseName) != null) {
            return true;
        }
        return this.droppedCache.getDatatype(dataverseName, datatypeName) != null;
    }

    public boolean nodeGroupIsDropped(String nodeGroup) {
        return this.droppedCache.getNodeGroup(nodeGroup) != null;
    }

    public boolean functionIsDropped(FunctionSignature functionSignature) {
        return this.droppedCache.getFunction(functionSignature) != null;
    }

    public ArrayList<MetadataCache.MetadataLogicalOperation> getOpLog() {
        return this.opLog;
    }

    public void addFeedPolicy(FeedPolicyEntity feedPolicy) {
        this.droppedCache.dropFeedPolicy(feedPolicy);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(feedPolicy, true));
    }

    public void addFeed(Feed feed) {
        this.droppedCache.dropFeed(feed);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(feed, true));
    }

    public void dropFeed(String dataverseName, String feedName) {
        Feed feed = null;
        feed = new Feed(dataverseName, feedName, null, null);
        this.droppedCache.addFeedIfNotExists(feed);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(feed, false));
    }

    public void addFeedConnection(FeedConnection feedConnection) {
        this.droppedCache.dropFeedConnection(feedConnection);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(feedConnection, true));
    }

    public void dropFeedConnection(String dataverseName, String feedName, String datasetName) {
        FeedConnection feedConnection = new FeedConnection(dataverseName, feedName, datasetName, null, null, null);
        this.droppedCache.addFeedConnectionIfNotExists(feedConnection);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(feedConnection, false));
    }

    @Override
    public void clear() {
        super.clear();
        this.droppedCache.clear();
        this.opLog.clear();
    }
}

