/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.api.IAppRuntimeContext;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.dataflow.LSMIndexUtil;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.transactions.AbstractOperationCallback;
import org.apache.asterix.common.transactions.DatasetId;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.common.transactions.ImmutableDatasetId;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.api.ExtensionMetadataDataset;
import org.apache.asterix.metadata.api.ExtensionMetadataDatasetId;
import org.apache.asterix.metadata.api.IExtensionMetadataEntity;
import org.apache.asterix.metadata.api.IExtensionMetadataSearchKey;
import org.apache.asterix.metadata.api.IMetadataEntityTupleTranslator;
import org.apache.asterix.metadata.api.IMetadataExtension;
import org.apache.asterix.metadata.api.IMetadataIndex;
import org.apache.asterix.metadata.api.IMetadataNode;
import org.apache.asterix.metadata.api.IValueExtractor;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.entities.Library;
import org.apache.asterix.metadata.entities.Node;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.metadata.entitytupletranslators.CompactionPolicyTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.DatasetTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.DatasourceAdapterTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.DatatypeTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.DataverseTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.ExternalFileTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.FeedConnectionTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.FeedPolicyTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.FeedTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.FunctionTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.IndexTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.LibraryTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.MetadataTupleTranslatorProvider;
import org.apache.asterix.metadata.entitytupletranslators.NodeGroupTupleTranslator;
import org.apache.asterix.metadata.entitytupletranslators.NodeTupleTranslator;
import org.apache.asterix.metadata.valueextractors.MetadataEntityValueExtractor;
import org.apache.asterix.metadata.valueextractors.TupleCopyValueExtractor;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractComplexType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.transaction.management.opcallbacks.AbstractIndexModificationOperationCallback;
import org.apache.asterix.transaction.management.opcallbacks.SecondaryIndexModificationOperationCallback;
import org.apache.asterix.transaction.management.service.transaction.DatasetIdFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IIndex;
import org.apache.hyracks.storage.am.common.api.IIndexAccessor;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.api.TreeIndexException;
import org.apache.hyracks.storage.am.common.exceptions.TreeIndexDuplicateKeyException;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;

public class MetadataNode
implements IMetadataNode {
    private static final long serialVersionUID = 1L;
    private static final DatasetId METADATA_DATASET_ID = new ImmutableDatasetId(MetadataPrimaryIndexes.PROPERTIES_METADATA.getDatasetId());
    private IDatasetLifecycleManager datasetLifecycleManager;
    private ITransactionSubsystem transactionSubsystem;
    private int metadataStoragePartition;
    private transient MetadataTupleTranslatorProvider tupleTranslatorProvider;
    private Map<ExtensionMetadataDatasetId, ExtensionMetadataDataset<?>> extensionDatasets;
    public static final MetadataNode INSTANCE = new MetadataNode();

    private MetadataNode() {
    }

    public void initialize(IAppRuntimeContext runtimeContext, MetadataTupleTranslatorProvider tupleTranslatorProvider, List<IMetadataExtension> metadataExtensions) {
        this.tupleTranslatorProvider = tupleTranslatorProvider;
        this.transactionSubsystem = runtimeContext.getTransactionSubsystem();
        this.datasetLifecycleManager = runtimeContext.getDatasetLifecycleManager();
        this.metadataStoragePartition = runtimeContext.getMetadataProperties().getMetadataPartition().getPartitionId();
        if (metadataExtensions != null) {
            this.extensionDatasets = new HashMap();
            for (IMetadataExtension metadataExtension : metadataExtensions) {
                for (ExtensionMetadataDataset extensionIndex : metadataExtension.getExtensionIndexes()) {
                    this.extensionDatasets.put(extensionIndex.getId(), extensionIndex);
                }
            }
        }
    }

    @Override
    public void beginTransaction(JobId transactionId) throws ACIDException, RemoteException {
        ITransactionContext txnCtx = this.transactionSubsystem.getTransactionManager().beginTransaction(transactionId);
        txnCtx.setMetadataTransaction(true);
    }

    @Override
    public void commitTransaction(JobId jobId) throws RemoteException, ACIDException {
        ITransactionContext txnCtx = this.transactionSubsystem.getTransactionManager().getTransactionContext(jobId, false);
        this.transactionSubsystem.getTransactionManager().commitTransaction(txnCtx, DatasetId.NULL, -1);
    }

    @Override
    public void abortTransaction(JobId jobId) throws RemoteException, ACIDException {
        try {
            ITransactionContext txnCtx = this.transactionSubsystem.getTransactionManager().getTransactionContext(jobId, false);
            this.transactionSubsystem.getTransactionManager().abortTransaction(txnCtx, DatasetId.NULL, -1);
        }
        catch (ACIDException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void lock(JobId jobId, byte lockMode) throws ACIDException, RemoteException {
        ITransactionContext txnCtx = this.transactionSubsystem.getTransactionManager().getTransactionContext(jobId, false);
        this.transactionSubsystem.getLockManager().lock(METADATA_DATASET_ID, -1, lockMode, txnCtx);
    }

    @Override
    public void unlock(JobId jobId, byte lockMode) throws ACIDException, RemoteException {
        ITransactionContext txnCtx = this.transactionSubsystem.getTransactionManager().getTransactionContext(jobId, false);
        this.transactionSubsystem.getLockManager().unlock(METADATA_DATASET_ID, -1, lockMode, txnCtx);
    }

    private <T> void addEntity(JobId jobId, T entity, IMetadataEntityTupleTranslator<T> tupleTranslator, IMetadataIndex index) throws MetadataException {
        try {
            ITupleReference tuple = tupleTranslator.getTupleFromMetadataEntity(entity);
            this.insertTupleIntoIndex(jobId, index, tuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException(entity.toString() + " already exists.", e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    private <T> void deleteEntity(JobId jobId, T entity, IMetadataEntityTupleTranslator<T> tupleTranslator, IMetadataIndex index) throws MetadataException {
        try {
            ITupleReference tuple = tupleTranslator.getTupleFromMetadataEntity(entity);
            this.deleteTupleFromIndex(jobId, index, tuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException(entity.toString() + " already exists.", e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    private <T> List<T> getEntities(JobId jobId, ITupleReference searchKey, IMetadataEntityTupleTranslator<T> tupleTranslator, IMetadataIndex index) throws MetadataException {
        try {
            MetadataEntityValueExtractor<T> valueExtractor = new MetadataEntityValueExtractor<T>(tupleTranslator);
            ArrayList results = new ArrayList();
            this.searchIndex(jobId, index, searchKey, valueExtractor, results);
            return results;
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public <T extends IExtensionMetadataEntity> void addEntity(JobId jobId, T entity) throws MetadataException, RemoteException {
        ExtensionMetadataDataset<?> index = this.extensionDatasets.get(entity.getDatasetId());
        if (index == null) {
            throw new MetadataException("Metadata Extension Index: " + entity.getDatasetId() + " was not found");
        }
        IMetadataEntityTupleTranslator<?> tupleTranslator = index.getTupleTranslator();
        this.addEntity(jobId, entity, tupleTranslator, index);
    }

    @Override
    public <T extends IExtensionMetadataEntity> void deleteEntity(JobId jobId, T entity) throws MetadataException, RemoteException {
        ExtensionMetadataDataset<?> index = this.extensionDatasets.get(entity.getDatasetId());
        if (index == null) {
            throw new MetadataException("Metadata Extension Index: " + entity.getDatasetId() + " was not found");
        }
        IMetadataEntityTupleTranslator<?> tupleTranslator = index.getTupleTranslator();
        this.deleteEntity(jobId, entity, tupleTranslator, index);
    }

    @Override
    public <T extends IExtensionMetadataEntity> List<T> getEntities(JobId jobId, IExtensionMetadataSearchKey searchKey) throws MetadataException, RemoteException {
        ExtensionMetadataDataset<?> index = this.extensionDatasets.get(searchKey.getDatasetId());
        if (index == null) {
            throw new MetadataException("Metadata Extension Index: " + searchKey.getDatasetId() + " was not found");
        }
        IMetadataEntityTupleTranslator<?> tupleTranslator = index.getTupleTranslator();
        return this.getEntities(jobId, searchKey.getSearchKey(), tupleTranslator, index);
    }

    @Override
    public void addDataverse(JobId jobId, Dataverse dataverse) throws MetadataException, RemoteException {
        try {
            DataverseTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataverseTupleTranslator(true);
            ITupleReference tuple = tupleReaderWriter.getTupleFromMetadataEntity(dataverse);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.DATAVERSE_DATASET, tuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException("A dataverse with this name " + dataverse.getDataverseName() + " already exists.", e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addDataset(JobId jobId, Dataset dataset) throws MetadataException, RemoteException {
        try {
            DatasetTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDatasetTupleTranslator(true);
            ITupleReference datasetTuple = tupleReaderWriter.getTupleFromMetadataEntity(dataset);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.DATASET_DATASET, datasetTuple);
            if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                InternalDatasetDetails id = (InternalDatasetDetails)dataset.getDatasetDetails();
                Index primaryIndex = new Index(dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName(), DatasetConfig.IndexType.BTREE, id.getPrimaryKey(), id.getKeySourceIndicator(), id.getPrimaryKeyType(), false, true, dataset.getPendingOp());
                this.addIndex(jobId, primaryIndex);
            }
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException("A dataset with this name " + dataset.getDatasetName() + " already exists in dataverse '" + dataset.getDataverseName() + "'.", e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addIndex(JobId jobId, Index index) throws MetadataException, RemoteException {
        try {
            IndexTupleTranslator tupleWriter = this.tupleTranslatorProvider.getIndexTupleTranslator(jobId, this, true);
            ITupleReference tuple = tupleWriter.getTupleFromMetadataEntity(index);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.INDEX_DATASET, tuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException("An index with name '" + index.getIndexName() + "' already exists.", e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addNode(JobId jobId, Node node) throws MetadataException, RemoteException {
        try {
            NodeTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getNodeTupleTranslator(true);
            ITupleReference tuple = tupleReaderWriter.getTupleFromMetadataEntity(node);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.NODE_DATASET, tuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException("A node with name '" + node.getNodeName() + "' already exists.", e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addNodeGroup(JobId jobId, NodeGroup nodeGroup) throws MetadataException, RemoteException {
        try {
            NodeGroupTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getNodeGroupTupleTranslator(true);
            ITupleReference tuple = tupleReaderWriter.getTupleFromMetadataEntity(nodeGroup);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.NODEGROUP_DATASET, tuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException("A nodegroup with name '" + nodeGroup.getNodeGroupName() + "' already exists.", e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addDatatype(JobId jobId, Datatype datatype) throws MetadataException, RemoteException {
        try {
            DatatypeTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataTypeTupleTranslator(jobId, this, true);
            ITupleReference tuple = tupleReaderWriter.getTupleFromMetadataEntity(datatype);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.DATATYPE_DATASET, tuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException("A datatype with name '" + datatype.getDatatypeName() + "' already exists.", e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addFunction(JobId jobId, Function function) throws MetadataException, RemoteException {
        try {
            FunctionTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFunctionTupleTranslator(true);
            ITupleReference functionTuple = tupleReaderWriter.getTupleFromMetadataEntity(function);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.FUNCTION_DATASET, functionTuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException("A function with this name " + function.getName() + " and arity " + function.getArity() + " already exists in dataverse '" + function.getDataverseName() + "'.", e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertTupleIntoIndex(JobId jobId, IMetadataIndex metadataIndex, ITupleReference tuple) throws ACIDException, HyracksDataException, IndexException {
        long resourceID = metadataIndex.getResourceId();
        String resourceName = metadataIndex.getFile().getRelativePath();
        ILSMIndex lsmIndex = (ILSMIndex)this.datasetLifecycleManager.get(resourceName);
        try {
            this.datasetLifecycleManager.open(resourceName);
            IModificationOperationCallback modCallback = this.createIndexModificationCallback(jobId, resourceID, metadataIndex, lsmIndex, AbstractIndexModificationOperationCallback.Operation.INSERT);
            ILSMIndexAccessor indexAccessor = lsmIndex.createAccessor(modCallback, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            ITransactionContext txnCtx = this.transactionSubsystem.getTransactionManager().getTransactionContext(jobId, false);
            txnCtx.setWriteTxn(true);
            txnCtx.registerIndexAndCallback(resourceID, lsmIndex, (AbstractOperationCallback)modCallback, metadataIndex.isPrimaryIndex());
            LSMIndexUtil.checkAndSetFirstLSN((AbstractLSMIndex)((AbstractLSMIndex)lsmIndex), (ILogManager)this.transactionSubsystem.getLogManager());
            indexAccessor.forceInsert(tuple);
        }
        finally {
            this.datasetLifecycleManager.close(resourceName);
        }
    }

    private IModificationOperationCallback createIndexModificationCallback(JobId jobId, long resourceId, IMetadataIndex metadataIndex, ILSMIndex lsmIndex, AbstractIndexModificationOperationCallback.Operation indexOp) throws ACIDException {
        ITransactionContext txnCtx = this.transactionSubsystem.getTransactionManager().getTransactionContext(jobId, false);
        return new SecondaryIndexModificationOperationCallback(metadataIndex.getDatasetId(), metadataIndex.getPrimaryKeyIndexes(), txnCtx, this.transactionSubsystem.getLockManager(), this.transactionSubsystem, resourceId, this.metadataStoragePartition, 0, indexOp);
    }

    @Override
    public void dropDataverse(JobId jobId, String dataverseName) throws MetadataException, RemoteException {
        try {
            this.confirmDataverseCanBeDeleted(jobId, dataverseName);
            List<Dataset> dataverseDatasets = this.getDataverseDatasets(jobId, dataverseName);
            for (int i = 0; i < dataverseDatasets.size(); ++i) {
                Dataset ds = dataverseDatasets.get(i);
                this.dropDataset(jobId, dataverseName, ds.getDatasetName());
            }
            List<Datatype> dataverseDatatypes = this.getDataverseDatatypes(jobId, dataverseName);
            for (int i = 0; i < dataverseDatatypes.size(); ++i) {
                this.forceDropDatatype(jobId, dataverseName, dataverseDatatypes.get(i).getDatatypeName());
            }
            List<Function> dataverseFunctions = this.getDataverseFunctions(jobId, dataverseName);
            for (Function function : dataverseFunctions) {
                this.dropFunction(jobId, new FunctionSignature(dataverseName, function.getName(), function.getArity()));
            }
            List<DatasourceAdapter> dataverseAdapters = this.getDataverseAdapters(jobId, dataverseName);
            for (DatasourceAdapter adapter : dataverseAdapters) {
                this.dropAdapter(jobId, dataverseName, adapter.getAdapterIdentifier().getName());
            }
            List<Feed> list = this.getDataverseFeeds(jobId, dataverseName);
            for (int i = 0; i < list.size(); ++i) {
                Feed feed = list.get(i);
                List<FeedConnection> feedConnections = this.getFeedConnections(jobId, dataverseName, feed.getFeedName());
                for (FeedConnection feedConnection : feedConnections) {
                    this.dropFeedConnection(jobId, dataverseName, feed.getFeedName(), feedConnection.getDatasetName());
                }
                this.dropFeed(jobId, dataverseName, feed.getFeedName());
            }
            List<FeedPolicyEntity> feedPolicies = this.getDataversePolicies(jobId, dataverseName);
            if (feedPolicies != null && feedPolicies.size() > 0) {
                for (FeedPolicyEntity feedPolicy : feedPolicies) {
                    this.dropFeedPolicy(jobId, dataverseName, feedPolicy.getPolicyName());
                }
            }
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName);
            ITupleReference tuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.DATAVERSE_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.DATAVERSE_DATASET, tuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("Cannot drop dataverse '" + dataverseName + "' because it doesn't exist.", e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropDataset(JobId jobId, String dataverseName, String datasetName) throws MetadataException, RemoteException {
        Dataset dataset;
        try {
            dataset = this.getDataset(jobId, dataverseName, datasetName);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
        if (dataset == null) {
            throw new MetadataException("Cannot drop dataset '" + datasetName + "' because it doesn't exist.");
        }
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datasetName);
            ITupleReference datasetTuple = null;
            try {
                List<ExternalFile> datasetFiles;
                datasetTuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.DATASET_DATASET, searchKey);
                List<Index> datasetIndexes = this.getDatasetIndexes(jobId, dataverseName, datasetName);
                if (datasetIndexes != null) {
                    for (Index index : datasetIndexes) {
                        this.dropIndex(jobId, dataverseName, datasetName, index.getIndexName());
                    }
                }
                if (dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL && (datasetFiles = this.getExternalFiles(jobId, dataset)) != null && datasetFiles.size() > 0) {
                    for (ExternalFile file : datasetFiles) {
                        this.dropExternalFile(jobId, dataverseName, file.getDatasetName(), file.getFileNumber());
                    }
                }
            }
            catch (TreeIndexException treeIndexException) {
            }
            finally {
                this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.DATASET_DATASET, datasetTuple);
            }
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropIndex(JobId jobId, String dataverseName, String datasetName, String indexName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datasetName, indexName);
            ITupleReference tuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.INDEX_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.INDEX_DATASET, tuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("Cannot drop index '" + datasetName + "." + indexName + "' because it doesn't exist.", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropNodegroup(JobId jobId, String nodeGroupName) throws MetadataException, RemoteException {
        List<String> datasetNames;
        try {
            datasetNames = this.getDatasetNamesPartitionedOnThisNodeGroup(jobId, nodeGroupName);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
        if (!datasetNames.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Nodegroup '" + nodeGroupName + "' cannot be dropped; it was used for partitioning these datasets:");
            for (int i = 0; i < datasetNames.size(); ++i) {
                sb.append("\n" + (i + 1) + "- " + datasetNames.get(i) + ".");
            }
            throw new MetadataException(sb.toString());
        }
        try {
            ITupleReference searchKey = MetadataNode.createTuple(nodeGroupName);
            ITupleReference tuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.NODEGROUP_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.NODEGROUP_DATASET, tuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("Cannot drop nodegroup '" + nodeGroupName + "' because it doesn't exist", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropDatatype(JobId jobId, String dataverseName, String datatypeName) throws MetadataException, RemoteException {
        this.confirmDatatypeIsUnused(jobId, dataverseName, datatypeName);
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datatypeName);
            ITupleReference tuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.DATATYPE_DATASET, searchKey);
            List<String> nestedTypes = this.getNestedComplexDatatypeNamesForThisDatatype(jobId, dataverseName, datatypeName);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.DATATYPE_DATASET, tuple);
            for (String nestedType : nestedTypes) {
                Datatype dt = this.getDatatype(jobId, dataverseName, nestedType);
                if (dt == null || !dt.getIsAnonymous()) continue;
                this.dropDatatype(jobId, dataverseName, dt.getDatatypeName());
            }
        }
        catch (TreeIndexException e) {
            throw new MetadataException("Cannot drop type '" + datatypeName + "' because it doesn't exist", e);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    private void forceDropDatatype(JobId jobId, String dataverseName, String datatypeName) throws MetadataException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datatypeName);
            ITupleReference tuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.DATATYPE_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.DATATYPE_DATASET, tuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("Cannot drop type '" + datatypeName + "' because it doesn't exist", e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTupleFromIndex(JobId jobId, IMetadataIndex metadataIndex, ITupleReference tuple) throws ACIDException, HyracksDataException, IndexException {
        long resourceID = metadataIndex.getResourceId();
        String resourceName = metadataIndex.getFile().getRelativePath();
        ILSMIndex lsmIndex = (ILSMIndex)this.datasetLifecycleManager.get(resourceName);
        try {
            this.datasetLifecycleManager.open(resourceName);
            IModificationOperationCallback modCallback = this.createIndexModificationCallback(jobId, resourceID, metadataIndex, lsmIndex, AbstractIndexModificationOperationCallback.Operation.DELETE);
            ILSMIndexAccessor indexAccessor = lsmIndex.createAccessor(modCallback, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            ITransactionContext txnCtx = this.transactionSubsystem.getTransactionManager().getTransactionContext(jobId, false);
            txnCtx.setWriteTxn(true);
            txnCtx.registerIndexAndCallback(resourceID, lsmIndex, (AbstractOperationCallback)modCallback, metadataIndex.isPrimaryIndex());
            LSMIndexUtil.checkAndSetFirstLSN((AbstractLSMIndex)((AbstractLSMIndex)lsmIndex), (ILogManager)this.transactionSubsystem.getLogManager());
            indexAccessor.forceDelete(tuple);
        }
        finally {
            this.datasetLifecycleManager.close(resourceName);
        }
    }

    @Override
    public List<Dataverse> getDataverses(JobId jobId) throws MetadataException, RemoteException {
        try {
            DataverseTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataverseTupleTranslator(false);
            MetadataEntityValueExtractor<Dataverse> valueExtractor = new MetadataEntityValueExtractor<Dataverse>(tupleReaderWriter);
            ArrayList<Dataverse> results = new ArrayList<Dataverse>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.DATAVERSE_DATASET, null, valueExtractor, results);
            return results;
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public Dataverse getDataverse(JobId jobId, String dataverseName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName);
            DataverseTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataverseTupleTranslator(false);
            MetadataEntityValueExtractor<Dataverse> valueExtractor = new MetadataEntityValueExtractor<Dataverse>(tupleReaderWriter);
            ArrayList results = new ArrayList();
            this.searchIndex(jobId, MetadataPrimaryIndexes.DATAVERSE_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Dataverse)results.get(0);
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public List<Dataset> getDataverseDatasets(JobId jobId, String dataverseName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName);
            DatasetTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDatasetTupleTranslator(false);
            MetadataEntityValueExtractor<Dataset> valueExtractor = new MetadataEntityValueExtractor<Dataset>(tupleReaderWriter);
            ArrayList<Dataset> results = new ArrayList<Dataset>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.DATASET_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public List<Feed> getDataverseFeeds(JobId jobId, String dataverseName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName);
            FeedTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedTupleTranslator(false);
            MetadataEntityValueExtractor<Feed> valueExtractor = new MetadataEntityValueExtractor<Feed>(tupleReaderWriter);
            ArrayList<Feed> results = new ArrayList<Feed>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.FEED_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public List<Library> getDataverseLibraries(JobId jobId, String dataverseName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName);
            LibraryTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getLibraryTupleTranslator(false);
            MetadataEntityValueExtractor<Library> valueExtractor = new MetadataEntityValueExtractor<Library>(tupleReaderWriter);
            ArrayList<Library> results = new ArrayList<Library>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.LIBRARY_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    private List<Datatype> getDataverseDatatypes(JobId jobId, String dataverseName) throws MetadataException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName);
            DatatypeTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataTypeTupleTranslator(jobId, this, false);
            MetadataEntityValueExtractor<Datatype> valueExtractor = new MetadataEntityValueExtractor<Datatype>(tupleReaderWriter);
            ArrayList<Datatype> results = new ArrayList<Datatype>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.DATATYPE_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public Dataset getDataset(JobId jobId, String dataverseName, String datasetName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datasetName);
            DatasetTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDatasetTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<Dataset> valueExtractor = new MetadataEntityValueExtractor<Dataset>(tupleReaderWriter);
            this.searchIndex(jobId, MetadataPrimaryIndexes.DATASET_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Dataset)results.get(0);
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    public List<Dataset> getAllDatasets(JobId jobId) throws MetadataException {
        try {
            ITupleReference searchKey = null;
            DatasetTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDatasetTupleTranslator(false);
            MetadataEntityValueExtractor<Dataset> valueExtractor = new MetadataEntityValueExtractor<Dataset>(tupleReaderWriter);
            ArrayList<Dataset> results = new ArrayList<Dataset>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.DATASET_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    public List<Datatype> getAllDatatypes(JobId jobId) throws MetadataException {
        try {
            ITupleReference searchKey = null;
            DatatypeTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataTypeTupleTranslator(jobId, this, false);
            MetadataEntityValueExtractor<Datatype> valueExtractor = new MetadataEntityValueExtractor<Datatype>(tupleReaderWriter);
            ArrayList<Datatype> results = new ArrayList<Datatype>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.DATATYPE_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    private void confirmDataverseCanBeDeleted(JobId jobId, String dataverseName) throws MetadataException {
        List<Dataset> datasets = this.getAllDatasets(jobId);
        for (Dataset set : datasets) {
            if (set.getDataverseName().equals(dataverseName) || !set.getItemTypeDataverseName().equals(dataverseName)) continue;
            throw new MetadataException("Cannot drop dataverse. Type " + dataverseName + "." + set.getItemTypeName() + " used by dataset " + set.getDataverseName() + "." + set.getDatasetName());
        }
    }

    private void confirmDatatypeIsUnused(JobId jobId, String dataverseName, String datatypeName) throws MetadataException, RemoteException {
        this.confirmDatatypeIsUnusedByDatatypes(jobId, dataverseName, datatypeName);
        this.confirmDatatypeIsUnusedByDatasets(jobId, dataverseName, datatypeName);
    }

    private void confirmDatatypeIsUnusedByDatasets(JobId jobId, String dataverseName, String datatypeName) throws MetadataException {
        List<Dataset> datasets = this.getAllDatasets(jobId);
        for (Dataset set : datasets) {
            if (!set.getItemTypeName().equals(datatypeName) || !set.getItemTypeDataverseName().equals(dataverseName)) continue;
            throw new MetadataException("Cannot drop type " + dataverseName + "." + datatypeName + " being used by dataset " + set.getDataverseName() + "." + set.getDatasetName());
        }
    }

    private void confirmDatatypeIsUnusedByDatatypes(JobId jobId, String dataverseName, String datatypeName) throws MetadataException, RemoteException {
        Datatype dataTypeToBeDropped = this.getDatatype(jobId, dataverseName, datatypeName);
        assert (dataTypeToBeDropped != null);
        IAType typeToBeDropped = dataTypeToBeDropped.getDatatype();
        List<Datatype> datatypes = this.getAllDatatypes(jobId);
        for (Datatype dataType : datatypes) {
            AbstractComplexType recType;
            if (!dataType.getDataverseName().equals(dataverseName) || dataType.getDatatype().getTypeName().equals(datatypeName) || !(recType = (AbstractComplexType)dataType.getDatatype()).containsType(typeToBeDropped)) continue;
            throw new MetadataException("Cannot drop type " + dataverseName + "." + datatypeName + " being used by type " + dataverseName + "." + recType.getTypeName());
        }
    }

    private List<String> getNestedComplexDatatypeNamesForThisDatatype(JobId jobId, String dataverseName, String datatypeName) throws MetadataException, RemoteException {
        ARecordType recType;
        Datatype parentType = this.getDatatype(jobId, dataverseName, datatypeName);
        List subTypes = null;
        if (parentType.getDatatype().getTypeTag() == ATypeTag.RECORD) {
            recType = (ARecordType)parentType.getDatatype();
            subTypes = Arrays.asList(recType.getFieldTypes());
        } else if (parentType.getDatatype().getTypeTag() == ATypeTag.UNION) {
            recType = (AUnionType)parentType.getDatatype();
            subTypes = recType.getUnionList();
        }
        ArrayList<String> nestedTypes = new ArrayList<String>();
        if (subTypes != null) {
            for (IAType subType : subTypes) {
                if (subType instanceof BuiltinType) continue;
                nestedTypes.add(subType.getTypeName());
            }
        }
        return nestedTypes;
    }

    public List<String> getDatasetNamesPartitionedOnThisNodeGroup(JobId jobId, String nodegroup) throws MetadataException {
        ArrayList<String> nodeGroupDatasets = new ArrayList<String>();
        List<Dataset> datasets = this.getAllDatasets(jobId);
        for (Dataset set : datasets) {
            if (!set.getNodeGroupName().equals(nodegroup)) continue;
            nodeGroupDatasets.add(set.getDatasetName());
        }
        return nodeGroupDatasets;
    }

    @Override
    public Index getIndex(JobId jobId, String dataverseName, String datasetName, String indexName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datasetName, indexName);
            IndexTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getIndexTupleTranslator(jobId, this, false);
            MetadataEntityValueExtractor<Index> valueExtractor = new MetadataEntityValueExtractor<Index>(tupleReaderWriter);
            ArrayList results = new ArrayList();
            this.searchIndex(jobId, MetadataPrimaryIndexes.INDEX_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Index)results.get(0);
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public List<Index> getDatasetIndexes(JobId jobId, String dataverseName, String datasetName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datasetName);
            IndexTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getIndexTupleTranslator(jobId, this, false);
            MetadataEntityValueExtractor<Index> valueExtractor = new MetadataEntityValueExtractor<Index>(tupleReaderWriter);
            ArrayList<Index> results = new ArrayList<Index>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.INDEX_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public Datatype getDatatype(JobId jobId, String dataverseName, String datatypeName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, datatypeName);
            DatatypeTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDataTypeTupleTranslator(jobId, this, false);
            MetadataEntityValueExtractor<Datatype> valueExtractor = new MetadataEntityValueExtractor<Datatype>(tupleReaderWriter);
            ArrayList results = new ArrayList();
            this.searchIndex(jobId, MetadataPrimaryIndexes.DATATYPE_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Datatype)results.get(0);
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public NodeGroup getNodeGroup(JobId jobId, String nodeGroupName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(nodeGroupName);
            NodeGroupTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getNodeGroupTupleTranslator(false);
            MetadataEntityValueExtractor<NodeGroup> valueExtractor = new MetadataEntityValueExtractor<NodeGroup>(tupleReaderWriter);
            ArrayList results = new ArrayList();
            this.searchIndex(jobId, MetadataPrimaryIndexes.NODEGROUP_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (NodeGroup)results.get(0);
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public Function getFunction(JobId jobId, FunctionSignature functionSignature) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(functionSignature.getNamespace(), functionSignature.getName(), "" + functionSignature.getArity());
            FunctionTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFunctionTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<Function> valueExtractor = new MetadataEntityValueExtractor<Function>(tupleReaderWriter);
            this.searchIndex(jobId, MetadataPrimaryIndexes.FUNCTION_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Function)results.get(0);
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropFunction(JobId jobId, FunctionSignature functionSignature) throws MetadataException, RemoteException {
        Function function = this.getFunction(jobId, functionSignature);
        if (function == null) {
            throw new MetadataException("Cannot drop function '" + functionSignature.toString() + "' because it doesn't exist.");
        }
        try {
            ITupleReference searchKey = MetadataNode.createTuple(functionSignature.getNamespace(), functionSignature.getName(), "" + functionSignature.getArity());
            ITupleReference functionTuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.FUNCTION_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.FUNCTION_DATASET, functionTuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("There is no function with the name " + functionSignature.getName() + " and arity " + functionSignature.getArity(), e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    private ITupleReference getTupleToBeDeleted(JobId jobId, IMetadataIndex metadataIndex, ITupleReference searchKey) throws MetadataException, IndexException, IOException {
        TupleCopyValueExtractor valueExtractor = new TupleCopyValueExtractor(metadataIndex.getTypeTraits());
        ArrayList results = new ArrayList();
        this.searchIndex(jobId, metadataIndex, searchKey, valueExtractor, results);
        if (results.isEmpty()) {
            throw new TreeIndexException("Could not find entry to be deleted.");
        }
        return (ITupleReference)results.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printMetadata() {
        StringBuilder sb = new StringBuilder();
        try {
            IMetadataIndex index = MetadataPrimaryIndexes.DATAVERSE_DATASET;
            String resourceName = index.getFile().toString();
            IIndex indexInstance = (IIndex)this.datasetLifecycleManager.get(resourceName);
            this.datasetLifecycleManager.open(resourceName);
            IIndexAccessor indexAccessor = indexInstance.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            ITreeIndexCursor rangeCursor = (ITreeIndexCursor)indexAccessor.createSearchCursor(false);
            RangePredicate rangePred = null;
            rangePred = new RangePredicate(null, null, true, true, null, null);
            indexAccessor.search((IIndexCursor)rangeCursor, (ISearchPredicate)rangePred);
            try {
                while (rangeCursor.hasNext()) {
                    rangeCursor.next();
                    sb.append(TupleUtils.printTuple((ITupleReference)rangeCursor.getTuple(), (ISerializerDeserializer[])new ISerializerDeserializer[]{SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING)}));
                }
            }
            finally {
                rangeCursor.close();
            }
            this.datasetLifecycleManager.close(resourceName);
            index = MetadataPrimaryIndexes.DATASET_DATASET;
            indexInstance = (IIndex)this.datasetLifecycleManager.get(resourceName);
            this.datasetLifecycleManager.open(resourceName);
            indexAccessor = indexInstance.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            rangeCursor = (ITreeIndexCursor)indexAccessor.createSearchCursor(false);
            rangePred = null;
            rangePred = new RangePredicate(null, null, true, true, null, null);
            indexAccessor.search((IIndexCursor)rangeCursor, (ISearchPredicate)rangePred);
            try {
                while (rangeCursor.hasNext()) {
                    rangeCursor.next();
                    sb.append(TupleUtils.printTuple((ITupleReference)rangeCursor.getTuple(), (ISerializerDeserializer[])new ISerializerDeserializer[]{SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING), SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING)}));
                }
            }
            finally {
                rangeCursor.close();
            }
            this.datasetLifecycleManager.close(resourceName);
            index = MetadataPrimaryIndexes.INDEX_DATASET;
            indexInstance = (IIndex)this.datasetLifecycleManager.get(resourceName);
            this.datasetLifecycleManager.open(resourceName);
            indexAccessor = indexInstance.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            rangeCursor = (ITreeIndexCursor)indexAccessor.createSearchCursor(false);
            rangePred = null;
            rangePred = new RangePredicate(null, null, true, true, null, null);
            indexAccessor.search((IIndexCursor)rangeCursor, (ISearchPredicate)rangePred);
            try {
                while (rangeCursor.hasNext()) {
                    rangeCursor.next();
                    sb.append(TupleUtils.printTuple((ITupleReference)rangeCursor.getTuple(), (ISerializerDeserializer[])new ISerializerDeserializer[]{SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING), SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING), SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING)}));
                }
            }
            finally {
                rangeCursor.close();
            }
            this.datasetLifecycleManager.close(resourceName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <ResultType> void searchIndex(JobId jobId, IMetadataIndex index, ITupleReference searchKey, IValueExtractor<ResultType> valueExtractor, List<ResultType> results) throws MetadataException, IndexException, IOException {
        IBinaryComparatorFactory[] comparatorFactories = index.getKeyBinaryComparatorFactory();
        if (index.getFile() == null) {
            throw new MetadataException("No file for Index " + index.getDataverseName() + "." + index.getIndexName());
        }
        String resourceName = index.getFile().getRelativePath();
        IIndex indexInstance = (IIndex)this.datasetLifecycleManager.get(resourceName);
        this.datasetLifecycleManager.open(resourceName);
        IIndexAccessor indexAccessor = indexInstance.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        ITreeIndexCursor rangeCursor = (ITreeIndexCursor)indexAccessor.createSearchCursor(false);
        IBinaryComparator[] searchCmps = null;
        MultiComparator searchCmp = null;
        RangePredicate rangePred = null;
        if (searchKey != null) {
            searchCmps = new IBinaryComparator[searchKey.getFieldCount()];
            for (int i = 0; i < searchKey.getFieldCount(); ++i) {
                searchCmps[i] = comparatorFactories[i].createBinaryComparator();
            }
            searchCmp = new MultiComparator(searchCmps);
        }
        rangePred = new RangePredicate(searchKey, searchKey, true, true, searchCmp, searchCmp);
        indexAccessor.search((IIndexCursor)rangeCursor, (ISearchPredicate)rangePred);
        try {
            while (rangeCursor.hasNext()) {
                rangeCursor.next();
                ResultType result = valueExtractor.getValue(jobId, rangeCursor.getTuple());
                if (result == null) continue;
                results.add(result);
            }
        }
        finally {
            rangeCursor.close();
        }
        this.datasetLifecycleManager.close(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeDatasetIdFactory(JobId jobId) throws MetadataException, RemoteException {
        int mostRecentDatasetId = 100;
        try {
            String resourceName = MetadataPrimaryIndexes.DATASET_DATASET.getFile().getRelativePath();
            IIndex indexInstance = (IIndex)this.datasetLifecycleManager.get(resourceName);
            this.datasetLifecycleManager.open(resourceName);
            try {
                IIndexAccessor indexAccessor = indexInstance.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
                IIndexCursor rangeCursor = indexAccessor.createSearchCursor(false);
                DatasetTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDatasetTupleTranslator(false);
                MetadataEntityValueExtractor<Dataset> valueExtractor = new MetadataEntityValueExtractor<Dataset>(tupleReaderWriter);
                RangePredicate rangePred = new RangePredicate(null, null, true, true, null, null);
                indexAccessor.search(rangeCursor, (ISearchPredicate)rangePred);
                try {
                    while (rangeCursor.hasNext()) {
                        rangeCursor.next();
                        ITupleReference ref = rangeCursor.getTuple();
                        Dataset ds = (Dataset)valueExtractor.getValue(jobId, ref);
                        int datasetId = ds.getDatasetId();
                        if (mostRecentDatasetId >= datasetId) continue;
                        mostRecentDatasetId = datasetId;
                    }
                }
                finally {
                    rangeCursor.close();
                }
            }
            finally {
                this.datasetLifecycleManager.close(resourceName);
            }
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
        DatasetIdFactory.initialize((int)mostRecentDatasetId);
    }

    public static ITupleReference createTuple(String ... fields) {
        ISerializerDeserializer stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
        AMutableString aString = new AMutableString("");
        ArrayTupleBuilder tupleBuilder = new ArrayTupleBuilder(fields.length);
        for (String s : fields) {
            aString.setValue(s);
            try {
                stringSerde.serialize((Object)aString, tupleBuilder.getDataOutput());
            }
            catch (HyracksDataException e) {
                throw new IllegalStateException("Failed to create search tuple!!!! This should never happen", e);
            }
            tupleBuilder.addFieldEndOffset();
        }
        ArrayTupleReference tuple = new ArrayTupleReference();
        tuple.reset(tupleBuilder.getFieldEndOffsets(), tupleBuilder.getByteArray());
        return tuple;
    }

    @Override
    public List<Function> getDataverseFunctions(JobId jobId, String dataverseName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName);
            FunctionTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFunctionTupleTranslator(false);
            MetadataEntityValueExtractor<Function> valueExtractor = new MetadataEntityValueExtractor<Function>(tupleReaderWriter);
            ArrayList<Function> results = new ArrayList<Function>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.FUNCTION_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addAdapter(JobId jobId, DatasourceAdapter adapter) throws MetadataException, RemoteException {
        try {
            DatasourceAdapterTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getAdapterTupleTranslator(true);
            ITupleReference adapterTuple = tupleReaderWriter.getTupleFromMetadataEntity(adapter);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, adapterTuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException("A adapter with this name " + adapter.getAdapterIdentifier().getName() + " already exists in dataverse '" + adapter.getAdapterIdentifier().getNamespace() + "'.", e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropAdapter(JobId jobId, String dataverseName, String adapterName) throws MetadataException, RemoteException {
        DatasourceAdapter adapter = this.getAdapter(jobId, dataverseName, adapterName);
        if (adapter == null) {
            throw new MetadataException("Cannot drop adapter '" + adapter + "' because it doesn't exist.");
        }
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, adapterName);
            ITupleReference datasetTuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, datasetTuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("Cannot drop adapter '" + adapterName, e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public DatasourceAdapter getAdapter(JobId jobId, String dataverseName, String adapterName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, adapterName);
            DatasourceAdapterTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getAdapterTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<DatasourceAdapter> valueExtractor = new MetadataEntityValueExtractor<DatasourceAdapter>(tupleReaderWriter);
            this.searchIndex(jobId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (DatasourceAdapter)results.get(0);
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addCompactionPolicy(JobId jobId, CompactionPolicy compactionPolicy) throws MetadataException, RemoteException {
        try {
            CompactionPolicyTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getCompactionPolicyTupleTranslator(true);
            ITupleReference compactionPolicyTuple = tupleReaderWriter.getTupleFromMetadataEntity(compactionPolicy);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.COMPACTION_POLICY_DATASET, compactionPolicyTuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException("A compcation policy with this name " + compactionPolicy.getPolicyName() + " already exists in dataverse '" + compactionPolicy.getPolicyName() + "'.", e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public CompactionPolicy getCompactionPolicy(JobId jobId, String dataverse, String policyName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverse, policyName);
            CompactionPolicyTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getCompactionPolicyTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<CompactionPolicy> valueExtractor = new MetadataEntityValueExtractor<CompactionPolicy>(tupleReaderWriter);
            this.searchIndex(jobId, MetadataPrimaryIndexes.COMPACTION_POLICY_DATASET, searchKey, valueExtractor, results);
            if (!results.isEmpty()) {
                return (CompactionPolicy)results.get(0);
            }
            return null;
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public List<DatasourceAdapter> getDataverseAdapters(JobId jobId, String dataverseName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName);
            DatasourceAdapterTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getAdapterTupleTranslator(false);
            MetadataEntityValueExtractor<DatasourceAdapter> valueExtractor = new MetadataEntityValueExtractor<DatasourceAdapter>(tupleReaderWriter);
            ArrayList<DatasourceAdapter> results = new ArrayList<DatasourceAdapter>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addLibrary(JobId jobId, Library library) throws MetadataException, RemoteException {
        try {
            LibraryTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getLibraryTupleTranslator(true);
            ITupleReference libraryTuple = tupleReaderWriter.getTupleFromMetadataEntity(library);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.LIBRARY_DATASET, libraryTuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("A library with this name " + library.getDataverseName() + " already exists in dataverse '" + library.getDataverseName() + "'.", e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropLibrary(JobId jobId, String dataverseName, String libraryName) throws MetadataException, RemoteException {
        Library library = this.getLibrary(jobId, dataverseName, libraryName);
        if (library == null) {
            throw new MetadataException("Cannot drop library '" + library + "' because it doesn't exist.");
        }
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, libraryName);
            ITupleReference datasetTuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.LIBRARY_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.LIBRARY_DATASET, datasetTuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("Cannot drop library '" + libraryName, e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public Library getLibrary(JobId jobId, String dataverseName, String libraryName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, libraryName);
            LibraryTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getLibraryTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<Library> valueExtractor = new MetadataEntityValueExtractor<Library>(tupleReaderWriter);
            this.searchIndex(jobId, MetadataPrimaryIndexes.LIBRARY_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (Library)results.get(0);
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public int getMostRecentDatasetId() throws MetadataException, RemoteException {
        return DatasetIdFactory.getMostRecentDatasetId();
    }

    @Override
    public void addFeedPolicy(JobId jobId, FeedPolicyEntity feedPolicy) throws MetadataException, RemoteException {
        try {
            FeedPolicyTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedPolicyTupleTranslator(true);
            ITupleReference feedPolicyTuple = tupleReaderWriter.getTupleFromMetadataEntity(feedPolicy);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.FEED_POLICY_DATASET, feedPolicyTuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("A feed policy with this name " + feedPolicy.getPolicyName() + " already exists in dataverse '" + feedPolicy.getPolicyName() + "'.", e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public FeedPolicyEntity getFeedPolicy(JobId jobId, String dataverse, String policyName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverse, policyName);
            FeedPolicyTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedPolicyTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<FeedPolicyEntity> valueExtractor = new MetadataEntityValueExtractor<FeedPolicyEntity>(tupleReaderWriter);
            this.searchIndex(jobId, MetadataPrimaryIndexes.FEED_POLICY_DATASET, searchKey, valueExtractor, results);
            if (!results.isEmpty()) {
                return (FeedPolicyEntity)results.get(0);
            }
            return null;
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addFeedConnection(JobId jobId, FeedConnection feedConnection) throws MetadataException {
        try {
            FeedConnectionTupleTranslator tupleReaderWriter = new FeedConnectionTupleTranslator(true);
            ITupleReference feedConnTuple = tupleReaderWriter.getTupleFromMetadataEntity(feedConnection);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.FEED_CONNECTION_DATASET, feedConnTuple);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public List<FeedConnection> getFeedConnections(JobId jobId, String dataverseName, String feedName) throws MetadataException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, feedName);
            FeedConnectionTupleTranslator tupleReaderWriter = new FeedConnectionTupleTranslator(false);
            ArrayList<FeedConnection> results = new ArrayList<FeedConnection>();
            MetadataEntityValueExtractor<FeedConnection> valueExtractor = new MetadataEntityValueExtractor<FeedConnection>(tupleReaderWriter);
            this.searchIndex(jobId, MetadataPrimaryIndexes.FEED_CONNECTION_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public FeedConnection getFeedConnection(JobId jobId, String dataverseName, String feedName, String datasetName) throws MetadataException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, feedName, datasetName);
            FeedConnectionTupleTranslator tupleReaderWriter = new FeedConnectionTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<FeedConnection> valueExtractor = new MetadataEntityValueExtractor<FeedConnection>(tupleReaderWriter);
            this.searchIndex(jobId, MetadataPrimaryIndexes.FEED_CONNECTION_DATASET, searchKey, valueExtractor, results);
            if (!results.isEmpty()) {
                return (FeedConnection)results.get(0);
            }
            return null;
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropFeedConnection(JobId jobId, String dataverseName, String feedName, String datasetName) throws MetadataException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, feedName, datasetName);
            ITupleReference tuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.FEED_CONNECTION_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.FEED_CONNECTION_DATASET, tuple);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addFeed(JobId jobId, Feed feed) throws MetadataException, RemoteException {
        try {
            FeedTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedTupleTranslator(true);
            ITupleReference feedTuple = tupleReaderWriter.getTupleFromMetadataEntity(feed);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.FEED_DATASET, feedTuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("A feed with this name " + feed.getFeedName() + " already exists in dataverse '" + feed.getDataverseName() + "'.", e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public Feed getFeed(JobId jobId, String dataverse, String feedName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverse, feedName);
            FeedTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedTupleTranslator(false);
            ArrayList results = new ArrayList();
            MetadataEntityValueExtractor<Feed> valueExtractor = new MetadataEntityValueExtractor<Feed>(tupleReaderWriter);
            this.searchIndex(jobId, MetadataPrimaryIndexes.FEED_DATASET, searchKey, valueExtractor, results);
            if (!results.isEmpty()) {
                return (Feed)results.get(0);
            }
            return null;
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropFeed(JobId jobId, String dataverse, String feedName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverse, feedName);
            ITupleReference tuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.FEED_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.FEED_DATASET, tuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("Cannot drop feed '" + feedName + "' because it doesn't exist", e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropFeedPolicy(JobId jobId, String dataverseName, String policyName) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverseName, policyName);
            ITupleReference tuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.FEED_POLICY_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.FEED_POLICY_DATASET, tuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("Unknown feed policy " + policyName, e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public List<FeedPolicyEntity> getDataversePolicies(JobId jobId, String dataverse) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataverse);
            FeedPolicyTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getFeedPolicyTupleTranslator(false);
            MetadataEntityValueExtractor<FeedPolicyEntity> valueExtractor = new MetadataEntityValueExtractor<FeedPolicyEntity>(tupleReaderWriter);
            ArrayList<FeedPolicyEntity> results = new ArrayList<FeedPolicyEntity>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.FEED_POLICY_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void addExternalFile(JobId jobId, ExternalFile externalFile) throws MetadataException, RemoteException {
        try {
            ExternalFileTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getExternalFileTupleTranslator(true);
            ITupleReference externalFileTuple = tupleReaderWriter.getTupleFromMetadataEntity(externalFile);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, externalFileTuple);
        }
        catch (TreeIndexDuplicateKeyException e) {
            throw new MetadataException("An externalFile with this number " + externalFile.getFileNumber() + " already exists in dataset '" + externalFile.getDatasetName() + "' in dataverse '" + externalFile.getDataverseName() + "'.", e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public List<ExternalFile> getExternalFiles(JobId jobId, Dataset dataset) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataset.getDataverseName(), dataset.getDatasetName());
            ExternalFileTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getExternalFileTupleTranslator(false);
            MetadataEntityValueExtractor<ExternalFile> valueExtractor = new MetadataEntityValueExtractor<ExternalFile>(tupleReaderWriter);
            ArrayList<ExternalFile> results = new ArrayList<ExternalFile>();
            this.searchIndex(jobId, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, searchKey, valueExtractor, results);
            return results;
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropExternalFile(JobId jobId, String dataverseName, String datasetName, int fileNumber) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createExternalFileSearchTuple(dataverseName, datasetName, fileNumber);
            ITupleReference datasetTuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, datasetTuple);
        }
        catch (TreeIndexException e) {
            throw new MetadataException("Couldn't drop externalFile.", e);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void dropExternalFiles(JobId jobId, Dataset dataset) throws MetadataException, RemoteException {
        List<ExternalFile> files = this.getExternalFiles(jobId, dataset);
        for (int i = 0; i < files.size(); ++i) {
            this.dropExternalFile(jobId, files.get(i).getDataverseName(), files.get(i).getDatasetName(), files.get(i).getFileNumber());
        }
    }

    public ITupleReference createExternalFileSearchTuple(String dataverseName, String datasetName, int fileNumber) throws HyracksDataException {
        ISerializerDeserializer stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
        ISerializerDeserializer intSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
        AMutableString aString = new AMutableString("");
        ArrayTupleBuilder tupleBuilder = new ArrayTupleBuilder(3);
        aString.setValue(dataverseName);
        stringSerde.serialize((Object)aString, tupleBuilder.getDataOutput());
        tupleBuilder.addFieldEndOffset();
        aString.setValue(datasetName);
        stringSerde.serialize((Object)aString, tupleBuilder.getDataOutput());
        tupleBuilder.addFieldEndOffset();
        intSerde.serialize((Object)new AInt32(fileNumber), tupleBuilder.getDataOutput());
        tupleBuilder.addFieldEndOffset();
        ArrayTupleReference tuple = new ArrayTupleReference();
        tuple.reset(tupleBuilder.getFieldEndOffsets(), tupleBuilder.getByteArray());
        return tuple;
    }

    @Override
    public ExternalFile getExternalFile(JobId jobId, String dataverseName, String datasetName, Integer fileNumber) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = this.createExternalFileSearchTuple(dataverseName, datasetName, fileNumber);
            ExternalFileTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getExternalFileTupleTranslator(false);
            MetadataEntityValueExtractor<ExternalFile> valueExtractor = new MetadataEntityValueExtractor<ExternalFile>(tupleReaderWriter);
            ArrayList results = new ArrayList();
            this.searchIndex(jobId, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET, searchKey, valueExtractor, results);
            if (results.isEmpty()) {
                return null;
            }
            return (ExternalFile)results.get(0);
        }
        catch (IOException | IndexException e) {
            throw new MetadataException(e);
        }
    }

    @Override
    public void updateDataset(JobId jobId, Dataset dataset) throws MetadataException, RemoteException {
        try {
            ITupleReference searchKey = MetadataNode.createTuple(dataset.getDataverseName(), dataset.getDatasetName());
            ITupleReference datasetTuple = this.getTupleToBeDeleted(jobId, MetadataPrimaryIndexes.DATASET_DATASET, searchKey);
            this.deleteTupleFromIndex(jobId, MetadataPrimaryIndexes.DATASET_DATASET, datasetTuple);
            DatasetTupleTranslator tupleReaderWriter = this.tupleTranslatorProvider.getDatasetTupleTranslator(true);
            datasetTuple = tupleReaderWriter.getTupleFromMetadataEntity(dataset);
            this.insertTupleIntoIndex(jobId, MetadataPrimaryIndexes.DATASET_DATASET, datasetTuple);
        }
        catch (IOException | ACIDException | IndexException e) {
            throw new MetadataException(e);
        }
    }
}

