/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.utils.ExternalDatasetAccessManager;

public class ExternalDatasetsRegistry {
    public static ExternalDatasetsRegistry INSTANCE = new ExternalDatasetsRegistry();
    private ConcurrentHashMap<String, ExternalDatasetAccessManager> globalRegister = new ConcurrentHashMap();

    private ExternalDatasetsRegistry() {
    }

    public int getDatasetVersion(Dataset dataset) {
        String key = dataset.getDataverseName() + "." + dataset.getDatasetName();
        ExternalDatasetAccessManager datasetAccessMgr = this.globalRegister.get(key);
        if (datasetAccessMgr == null) {
            this.globalRegister.putIfAbsent(key, new ExternalDatasetAccessManager());
            datasetAccessMgr = this.globalRegister.get(key);
        }
        return datasetAccessMgr.getVersion();
    }

    public int getAndLockDatasetVersion(Dataset dataset, MetadataProvider metadataProvider) {
        Map<String, Integer> locks = null;
        String lockKey = dataset.getDataverseName() + "." + dataset.getDatasetName();
        locks = metadataProvider.getLocks();
        if (locks == null) {
            locks = new HashMap<String, Integer>();
            metadataProvider.setLocks(locks);
        } else {
            Integer version = locks.get(lockKey);
            if (version != null) {
                return version;
            }
        }
        ExternalDatasetAccessManager datasetAccessMgr = this.globalRegister.get(lockKey);
        if (datasetAccessMgr == null) {
            this.globalRegister.putIfAbsent(lockKey, new ExternalDatasetAccessManager());
            datasetAccessMgr = this.globalRegister.get(lockKey);
        }
        int version = datasetAccessMgr.queryBegin();
        locks.put(lockKey, version);
        return version;
    }

    public void refreshBegin(Dataset dataset) {
        String key = dataset.getDataverseName() + "." + dataset.getDatasetName();
        ExternalDatasetAccessManager datasetAccessMgr = this.globalRegister.get(key);
        if (datasetAccessMgr == null) {
            datasetAccessMgr = this.globalRegister.put(key, new ExternalDatasetAccessManager());
        }
        datasetAccessMgr.refreshBegin();
    }

    public void removeDatasetInfo(Dataset dataset) {
        String key = dataset.getDataverseName() + "." + dataset.getDatasetName();
        this.globalRegister.remove(key);
    }

    public void refreshEnd(Dataset dataset, boolean success) {
        String key = dataset.getDataverseName() + "." + dataset.getDatasetName();
        this.globalRegister.get(key).refreshEnd(success);
    }

    public void buildIndexBegin(Dataset dataset, boolean firstIndex) {
        String key = dataset.getDataverseName() + "." + dataset.getDatasetName();
        ExternalDatasetAccessManager datasetAccessMgr = this.globalRegister.get(key);
        if (datasetAccessMgr == null) {
            this.globalRegister.putIfAbsent(key, new ExternalDatasetAccessManager());
            datasetAccessMgr = this.globalRegister.get(key);
        }
        datasetAccessMgr.buildIndexBegin(firstIndex);
    }

    public void buildIndexEnd(Dataset dataset, boolean firstIndex) {
        String key = dataset.getDataverseName() + "." + dataset.getDatasetName();
        this.globalRegister.get(key).buildIndexEnd(firstIndex);
    }

    public void releaseAcquiredLocks(MetadataProvider metadataProvider) {
        Map<String, Integer> locks = metadataProvider.getLocks();
        if (locks == null) {
            return;
        }
        Set<Map.Entry<String, Integer>> aquiredLocks = locks.entrySet();
        for (Map.Entry<String, Integer> entry : aquiredLocks) {
            this.globalRegister.get(entry.getKey()).queryEnd(entry.getValue());
        }
        locks.clear();
    }
}

