/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.IDatasetDetails;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.metadata.utils.DatasetUtils;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ADateTime;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.AUnorderedList;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class DatasetTupleTranslator
extends AbstractTupleTranslator<Dataset> {
    private static final long serialVersionUID = 1L;
    public static final int DATASET_DATAVERSENAME_TUPLE_FIELD_INDEX = 0;
    public static final int DATASET_DATASETNAME_TUPLE_FIELD_INDEX = 1;
    public static final int DATASET_PAYLOAD_TUPLE_FIELD_INDEX = 2;
    protected final ISerializerDeserializer<ARecord> recordSerDes = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)MetadataRecordTypes.DATASET_RECORDTYPE);
    protected final transient AMutableInt32 aInt32;
    protected final transient ISerializerDeserializer<AInt32> aInt32Serde;
    protected final transient ArrayBackedValueStorage fieldName = new ArrayBackedValueStorage();

    protected DatasetTupleTranslator(boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.DATASET_DATASET.getFieldCount());
        this.aInt32 = new AMutableInt32(-1);
        this.aInt32Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
    }

    @Override
    public Dataset getMetadataEntityFromTuple(ITupleReference frameTuple) throws IOException {
        byte[] serRecord = frameTuple.getFieldData(2);
        int recordStartOffset = frameTuple.getFieldStart(2);
        int recordLength = frameTuple.getFieldLength(2);
        ByteArrayInputStream stream = new ByteArrayInputStream(serRecord, recordStartOffset, recordLength);
        DataInputStream in = new DataInputStream(stream);
        ARecord datasetRecord = (ARecord)this.recordSerDes.deserialize((DataInput)in);
        return this.createDatasetFromARecord(datasetRecord);
    }

    protected Dataset createDatasetFromARecord(ARecord datasetRecord) throws IOException {
        String value;
        String key;
        String dataverseName = ((AString)datasetRecord.getValueByPos(0)).getStringValue();
        String datasetName = ((AString)datasetRecord.getValueByPos(1)).getStringValue();
        String typeName = ((AString)datasetRecord.getValueByPos(3)).getStringValue();
        String typeDataverseName = ((AString)datasetRecord.getValueByPos(2)).getStringValue();
        DatasetConfig.DatasetType datasetType = DatasetConfig.DatasetType.valueOf((String)((AString)datasetRecord.getValueByPos(4)).getStringValue());
        IDatasetDetails datasetDetails = null;
        int datasetId = ((AInt32)datasetRecord.getValueByPos(12)).getIntegerValue();
        int pendingOp = ((AInt32)datasetRecord.getValueByPos(13)).getIntegerValue();
        String nodeGroupName = ((AString)datasetRecord.getValueByPos(5)).getStringValue();
        String compactionPolicy = ((AString)datasetRecord.getValueByPos(6)).getStringValue();
        IACursor cursor = ((AOrderedList)datasetRecord.getValueByPos(7)).getCursor();
        LinkedHashMap<String, String> compactionPolicyProperties = new LinkedHashMap<String, String>();
        while (cursor.next()) {
            ARecord field = (ARecord)cursor.get();
            key = ((AString)field.getValueByPos(0)).getStringValue();
            value = ((AString)field.getValueByPos(1)).getStringValue();
            compactionPolicyProperties.put(key, value);
        }
        switch (datasetType) {
            case INTERNAL: {
                ARecord datasetDetailsRecord = (ARecord)datasetRecord.getValueByPos(8);
                InternalDatasetDetails.FileStructure fileStructure = InternalDatasetDetails.FileStructure.valueOf(((AString)datasetDetailsRecord.getValueByPos(0)).getStringValue());
                InternalDatasetDetails.PartitioningStrategy partitioningStrategy = InternalDatasetDetails.PartitioningStrategy.valueOf(((AString)datasetDetailsRecord.getValueByPos(1)).getStringValue());
                cursor = ((AOrderedList)datasetDetailsRecord.getValueByPos(2)).getCursor();
                ArrayList<List<String>> partitioningKey = new ArrayList<List<String>>();
                ArrayList<IAType> partitioningKeyType = new ArrayList<IAType>();
                while (cursor.next()) {
                    AOrderedList fieldNameList = (AOrderedList)cursor.get();
                    IACursor nestedFieldNameCursor = fieldNameList.getCursor();
                    ArrayList<String> nestedFieldName = new ArrayList<String>();
                    while (nestedFieldNameCursor.next()) {
                        nestedFieldName.add(((AString)nestedFieldNameCursor.get()).getStringValue());
                    }
                    partitioningKey.add(nestedFieldName);
                    partitioningKeyType.add((IAType)BuiltinType.ASTRING);
                }
                boolean autogenerated = ((ABoolean)datasetDetailsRecord.getValueByPos(4)).getBoolean();
                ArrayList<String> filterField = null;
                int filterFieldPos = datasetDetailsRecord.getType().getFieldIndex("FilterField");
                if (filterFieldPos >= 0) {
                    filterField = new ArrayList<String>();
                    cursor = ((AOrderedList)datasetDetailsRecord.getValueByPos(filterFieldPos)).getCursor();
                    while (cursor.next()) {
                        filterField.add(((AString)cursor.get()).getStringValue());
                    }
                }
                ArrayList<Integer> keyFieldSourceIndicator = new ArrayList<Integer>();
                int keyFieldSourceIndicatorIndex = datasetDetailsRecord.getType().getFieldIndex("KeySourceIndicator");
                if (keyFieldSourceIndicatorIndex >= 0) {
                    cursor = ((AOrderedList)datasetDetailsRecord.getValueByPos(keyFieldSourceIndicatorIndex)).getCursor();
                    while (cursor.next()) {
                        keyFieldSourceIndicator.add(Integer.valueOf(((AInt8)cursor.get()).getByteValue()));
                    }
                } else {
                    for (int index = 0; index < partitioningKey.size(); ++index) {
                        keyFieldSourceIndicator.add(0);
                    }
                }
                datasetDetails = new InternalDatasetDetails(fileStructure, partitioningStrategy, partitioningKey, partitioningKey, keyFieldSourceIndicator, partitioningKeyType, autogenerated, filterField, false);
                break;
            }
            case EXTERNAL: {
                ARecord datasetDetailsRecord = (ARecord)datasetRecord.getValueByPos(9);
                String adapter = ((AString)datasetDetailsRecord.getValueByPos(0)).getStringValue();
                cursor = ((AOrderedList)datasetDetailsRecord.getValueByPos(1)).getCursor();
                HashMap<String, String> properties = new HashMap<String, String>();
                while (cursor.next()) {
                    ARecord field = (ARecord)cursor.get();
                    key = ((AString)field.getValueByPos(0)).getStringValue();
                    value = ((AString)field.getValueByPos(1)).getStringValue();
                    properties.put(key, value);
                }
                Date timestamp = new Date(((ADateTime)datasetDetailsRecord.getValueByPos(2)).getChrononTime());
                DatasetConfig.ExternalDatasetTransactionState state = DatasetConfig.ExternalDatasetTransactionState.values()[((AInt32)datasetDetailsRecord.getValueByPos(3)).getIntegerValue()];
                datasetDetails = new ExternalDatasetDetails(adapter, properties, timestamp, state);
            }
        }
        Map<String, String> hints = this.getDatasetHints(datasetRecord);
        String metaTypeDataverseName = null;
        String metaTypeName = null;
        int metaTypeDataverseNameIndex = datasetRecord.getType().getFieldIndex("MetatypeDataverseName");
        if (metaTypeDataverseNameIndex >= 0) {
            metaTypeDataverseName = ((AString)datasetRecord.getValueByPos(metaTypeDataverseNameIndex)).getStringValue();
            int metaTypeNameIndex = datasetRecord.getType().getFieldIndex("MetatypeName");
            metaTypeName = ((AString)datasetRecord.getValueByPos(metaTypeNameIndex)).getStringValue();
        }
        return new Dataset(dataverseName, datasetName, typeDataverseName, typeName, metaTypeDataverseName, metaTypeName, nodeGroupName, compactionPolicy, compactionPolicyProperties, datasetDetails, hints, datasetType, datasetId, pendingOp);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Dataset dataset) throws IOException, MetadataException {
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        this.tupleBuilder.reset();
        this.aString.setValue(dataset.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(dataset.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.DATASET_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(dataset.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(dataset.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(dataset.getItemTypeDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(dataset.getItemTypeName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(3, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(dataset.getDatasetType().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(4, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(dataset.getNodeGroupName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(5, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(dataset.getCompactionPolicy());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(6, (IValueReference)this.fieldValue);
        listBuilder.reset((AbstractCollectionType)((AOrderedListType)MetadataRecordTypes.DATASET_RECORDTYPE.getFieldTypes()[7]));
        if (dataset.getCompactionPolicyProperties() != null) {
            for (Map.Entry<String, String> property : dataset.getCompactionPolicyProperties().entrySet()) {
                String name = property.getKey();
                String value = property.getValue();
                itemValue.reset();
                DatasetUtils.writePropertyTypeRecord(name, value, itemValue.getDataOutput(), MetadataRecordTypes.COMPACTION_POLICY_PROPERTIES_RECORDTYPE);
                listBuilder.addItem((IValueReference)itemValue);
            }
        }
        this.fieldValue.reset();
        listBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(7, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.writeDatasetDetailsRecordType(this.recordBuilder, dataset, this.fieldValue.getDataOutput());
        UnorderedListBuilder uListBuilder = new UnorderedListBuilder();
        uListBuilder.reset((AbstractCollectionType)((AUnorderedListType)MetadataRecordTypes.DATASET_RECORDTYPE.getFieldTypes()[10]));
        for (Map.Entry<String, String> property : dataset.getHints().entrySet()) {
            String name = property.getKey();
            String value = property.getValue();
            itemValue.reset();
            this.writeDatasetHintRecord(name, value, itemValue.getDataOutput());
            uListBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        uListBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(10, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(Calendar.getInstance().getTime().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(11, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aInt32.setValue(dataset.getDatasetId());
        this.aInt32Serde.serialize((Object)this.aInt32, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(12, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aInt32.setValue(dataset.getPendingOp());
        this.aInt32Serde.serialize((Object)this.aInt32, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(13, (IValueReference)this.fieldValue);
        this.writeOpenFields(dataset);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }

    protected void writeOpenFields(Dataset dataset) throws HyracksDataException {
        if (dataset.hasMetaPart()) {
            this.fieldName.reset();
            this.aString.setValue("MetatypeDataverseName");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aString.setValue(dataset.getMetaItemTypeDataverseName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
            this.fieldName.reset();
            this.aString.setValue("MetatypeName");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aString.setValue(dataset.getMetaItemTypeName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        }
    }

    protected void writeDatasetDetailsRecordType(IARecordBuilder recordBuilder, Dataset dataset, DataOutput dataOutput) throws HyracksDataException {
        dataset.getDatasetDetails().writeDatasetDetailsRecordType(this.fieldValue.getDataOutput());
        switch (dataset.getDatasetType()) {
            case INTERNAL: {
                recordBuilder.addField(8, (IValueReference)this.fieldValue);
                break;
            }
            case EXTERNAL: {
                recordBuilder.addField(9, (IValueReference)this.fieldValue);
            }
        }
    }

    protected Map<String, String> getDatasetHints(ARecord datasetRecord) {
        HashMap<String, String> hints = new HashMap<String, String>();
        AUnorderedList list = (AUnorderedList)datasetRecord.getValueByPos(10);
        IACursor cursor = list.getCursor();
        while (cursor.next()) {
            ARecord field = (ARecord)cursor.get();
            String key = ((AString)field.getValueByPos(0)).getStringValue();
            String value = ((AString)field.getValueByPos(1)).getStringValue();
            hints.put(key, value);
        }
        return hints;
    }

    protected void writeDatasetHintRecord(String name, String value, DataOutput out) throws HyracksDataException {
        RecordBuilder propertyRecordBuilder = new RecordBuilder();
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        propertyRecordBuilder.reset(MetadataRecordTypes.DATASET_HINTS_RECORDTYPE);
        AMutableString aString = new AMutableString("");
        ISerializerDeserializer stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
        fieldValue.reset();
        aString.setValue(name);
        stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(0, (IValueReference)fieldValue);
        fieldValue.reset();
        aString.setValue(value);
        stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(1, (IValueReference)fieldValue);
        propertyRecordBuilder.write(out, true);
    }
}

