/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.util.Map;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.external.feed.api.IFeed;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.api.IMetadataEntity;

public class Feed
implements IMetadataEntity<Feed>,
IFeed {
    private static final long serialVersionUID = 1L;
    public static final String EXTENSION_NAME = "Feed";
    private EntityId feedId;
    private FunctionSignature appliedFunction;
    private IFeed.FeedType feedType;
    private String displayName;
    private String adapterName;
    private Map<String, String> adapterConfiguration;
    private String sourceFeedName;

    public Feed(String dataverseName, String feedName, FunctionSignature appliedFunction, IFeed.FeedType feedType, String sourceFeedName, String adapterName, Map<String, String> configuration) {
        this.feedId = new EntityId(EXTENSION_NAME, dataverseName, feedName);
        this.appliedFunction = appliedFunction;
        this.feedType = feedType;
        this.displayName = feedType + "(" + this.feedId + ")";
        this.adapterName = adapterName;
        this.adapterConfiguration = configuration;
        this.sourceFeedName = sourceFeedName;
    }

    public EntityId getFeedId() {
        return this.feedId;
    }

    public String getDataverseName() {
        return this.feedId.getDataverse();
    }

    public String getFeedName() {
        return this.feedId.getEntityName();
    }

    public FunctionSignature getAppliedFunction() {
        return this.appliedFunction;
    }

    public IFeed.FeedType getFeedType() {
        return this.feedType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Feed)) {
            return false;
        }
        Feed otherFeed = (Feed)other;
        return otherFeed.getFeedId().equals((Object)this.feedId);
    }

    public int hashCode() {
        return this.displayName.hashCode();
    }

    public String toString() {
        return this.feedType + "(" + this.feedId + ")";
    }

    @Override
    public Feed addToCache(MetadataCache cache) {
        return cache.addFeedIfNotExists(this);
    }

    @Override
    public Feed dropFromCache(MetadataCache cache) {
        return cache.dropFeed(this);
    }

    public String getAdapterName() {
        return this.adapterName;
    }

    public Map<String, String> getAdapterConfiguration() {
        return this.adapterConfiguration;
    }

    public String getSourceFeedName() {
        return this.sourceFeedName;
    }
}

