/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.metadata.IDatasetDetails;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.api.IMetadataEntity;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;

public class Dataset
implements IMetadataEntity<Dataset> {
    public static final byte OP_READ = 0;
    public static final byte OP_INSERT = 1;
    public static final byte OP_DELETE = 2;
    public static final byte OP_UPSERT = 3;
    private static final long serialVersionUID = 1L;
    private final String dataverseName;
    private final String datasetName;
    private final String itemTypeDataverseName;
    private final String itemTypeName;
    private final String nodeGroupName;
    private final String compactionPolicy;
    private final Map<String, String> compactionPolicyProperties;
    private final DatasetConfig.DatasetType datasetType;
    private final IDatasetDetails datasetDetails;
    private final Map<String, String> hints;
    private final int datasetId;
    private int pendingOp;
    private final String metaItemTypeDataverseName;
    private final String metaItemTypeName;

    public Dataset(String dataverseName, String datasetName, String itemTypeDataverseName, String itemTypeName, String nodeGroupName, String compactionPolicy, Map<String, String> compactionPolicyProperties, IDatasetDetails datasetDetails, Map<String, String> hints, DatasetConfig.DatasetType datasetType, int datasetId, int pendingOp) {
        this(dataverseName, datasetName, itemTypeDataverseName, itemTypeName, null, null, nodeGroupName, compactionPolicy, compactionPolicyProperties, datasetDetails, hints, datasetType, datasetId, pendingOp);
    }

    public Dataset(String dataverseName, String datasetName, String itemTypeDataverseName, String itemTypeName, String metaItemTypeDataverseName, String metaItemTypeName, String nodeGroupName, String compactionPolicy, Map<String, String> compactionPolicyProperties, IDatasetDetails datasetDetails, Map<String, String> hints, DatasetConfig.DatasetType datasetType, int datasetId, int pendingOp) {
        this.dataverseName = dataverseName;
        this.datasetName = datasetName;
        this.itemTypeName = itemTypeName;
        this.itemTypeDataverseName = itemTypeDataverseName;
        this.metaItemTypeDataverseName = metaItemTypeDataverseName;
        this.metaItemTypeName = metaItemTypeName;
        this.nodeGroupName = nodeGroupName;
        this.compactionPolicy = compactionPolicy;
        this.compactionPolicyProperties = compactionPolicyProperties;
        this.datasetType = datasetType;
        this.datasetDetails = datasetDetails;
        this.datasetId = datasetId;
        this.pendingOp = pendingOp;
        this.hints = hints;
    }

    public Dataset(Dataset dataset) {
        this(dataset.dataverseName, dataset.datasetName, dataset.itemTypeDataverseName, dataset.itemTypeName, dataset.metaItemTypeDataverseName, dataset.metaItemTypeName, dataset.nodeGroupName, dataset.compactionPolicy, dataset.compactionPolicyProperties, dataset.datasetDetails, dataset.hints, dataset.datasetType, dataset.datasetId, dataset.pendingOp);
    }

    public String getDataverseName() {
        return this.dataverseName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public String getItemTypeName() {
        return this.itemTypeName;
    }

    public String getItemTypeDataverseName() {
        return this.itemTypeDataverseName;
    }

    public String getNodeGroupName() {
        return this.nodeGroupName;
    }

    public String getCompactionPolicy() {
        return this.compactionPolicy;
    }

    public Map<String, String> getCompactionPolicyProperties() {
        return this.compactionPolicyProperties;
    }

    public DatasetConfig.DatasetType getDatasetType() {
        return this.datasetType;
    }

    public IDatasetDetails getDatasetDetails() {
        return this.datasetDetails;
    }

    public Map<String, String> getHints() {
        return this.hints;
    }

    public int getDatasetId() {
        return this.datasetId;
    }

    public int getPendingOp() {
        return this.pendingOp;
    }

    public String getMetaItemTypeDataverseName() {
        return this.metaItemTypeDataverseName;
    }

    public String getMetaItemTypeName() {
        return this.metaItemTypeName;
    }

    public boolean hasMetaPart() {
        return this.metaItemTypeDataverseName != null && this.metaItemTypeName != null;
    }

    public void setPendingOp(int pendingOp) {
        this.pendingOp = pendingOp;
    }

    @Override
    public Dataset addToCache(MetadataCache cache) {
        return cache.addDatasetIfNotExists(this);
    }

    @Override
    public Dataset dropFromCache(MetadataCache cache) {
        return cache.dropDataset(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Dataset)) {
            return false;
        }
        Dataset otherDataset = (Dataset)other;
        if (!otherDataset.dataverseName.equals(this.dataverseName)) {
            return false;
        }
        return otherDataset.datasetName.equals(this.datasetName);
    }

    public boolean allow(ILogicalOperator topOp, byte operation) {
        return !this.hasMetaPart();
    }

    public String toString() {
        return this.dataverseName + "." + this.datasetName;
    }
}

