/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.valueextractors;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.api.IValueExtractor;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.tuples.TypeAwareTupleReference;
import org.apache.hyracks.storage.am.common.tuples.TypeAwareTupleWriter;

public class TupleCopyValueExtractor
implements IValueExtractor<ITupleReference> {
    private final TypeAwareTupleWriter tupleWriter;
    private final TypeAwareTupleReference tupleReference;
    private byte[] tupleBytes;
    private ByteBuffer buf;

    public TupleCopyValueExtractor(ITypeTraits[] typeTraits) {
        this.tupleWriter = new TypeAwareTupleWriter(typeTraits);
        this.tupleReference = (TypeAwareTupleReference)this.tupleWriter.createTupleReference();
    }

    @Override
    public ITupleReference getValue(JobId jobId, ITupleReference tuple) throws MetadataException, HyracksDataException, IOException {
        int numBytes = this.tupleWriter.bytesRequired(tuple);
        this.tupleBytes = new byte[numBytes];
        this.tupleWriter.writeTuple(tuple, this.tupleBytes, 0);
        this.buf = ByteBuffer.wrap(this.tupleBytes);
        this.tupleReference.resetByTupleOffset(this.buf, 0);
        return this.tupleReference;
    }
}

