/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.valueextractors;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.dataflow.data.nontagged.serde.AObjectSerializerDeserializer;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.api.IValueExtractor;
import org.apache.asterix.om.base.AString;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class NestedDatatypeNameValueExtractor
implements IValueExtractor<String> {
    private final String datatypeName;

    public NestedDatatypeNameValueExtractor(String datatypeName) {
        this.datatypeName = datatypeName;
    }

    @Override
    public String getValue(JobId jobId, ITupleReference tuple) throws MetadataException, HyracksDataException {
        int recordLength;
        int recordStartOffset;
        byte[] serRecord = tuple.getFieldData(2);
        ByteArrayInputStream stream = new ByteArrayInputStream(serRecord, recordStartOffset = tuple.getFieldStart(2), recordLength = tuple.getFieldLength(2));
        DataInputStream in = new DataInputStream(stream);
        String nestedType = ((AString)AObjectSerializerDeserializer.INSTANCE.deserialize((DataInput)in)).getStringValue();
        if (nestedType.equals(this.datatypeName)) {
            recordStartOffset = tuple.getFieldStart(1);
            recordLength = tuple.getFieldLength(1);
            stream = new ByteArrayInputStream(serRecord, recordStartOffset, recordLength);
            in = new DataInputStream(stream);
            return ((AString)AObjectSerializerDeserializer.INSTANCE.deserialize((DataInput)in)).getStringValue();
        }
        return null;
    }
}

