/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.valueextractors;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.rmi.RemoteException;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.dataflow.data.nontagged.serde.AObjectSerializerDeserializer;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.MetadataNode;
import org.apache.asterix.metadata.api.IValueExtractor;
import org.apache.asterix.om.base.AString;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class DatatypeNameValueExtractor
implements IValueExtractor<String> {
    private final String dataverseName;
    private final MetadataNode metadataNode;

    public DatatypeNameValueExtractor(String dataverseName, MetadataNode metadataNode) {
        this.dataverseName = dataverseName;
        this.metadataNode = metadataNode;
    }

    @Override
    public String getValue(JobId jobId, ITupleReference tuple) throws MetadataException, HyracksDataException {
        byte[] serRecord = tuple.getFieldData(2);
        int recordStartOffset = tuple.getFieldStart(2);
        int recordLength = tuple.getFieldLength(2);
        ByteArrayInputStream stream = new ByteArrayInputStream(serRecord, recordStartOffset, recordLength);
        DataInputStream in = new DataInputStream(stream);
        String typeName = ((AString)AObjectSerializerDeserializer.INSTANCE.deserialize((DataInput)in)).getStringValue();
        try {
            if (this.metadataNode.getDatatype(jobId, this.dataverseName, typeName).getIsAnonymous()) {
                typeName = this.metadataNode.getDatatypeNamesUsingThisDatatype(jobId, this.dataverseName, typeName).get(0);
            }
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        return typeName;
    }
}

