/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.utils.DatasetLock;

public class MetadataLockManager {
    public static MetadataLockManager INSTANCE = new MetadataLockManager();
    private final ConcurrentHashMap<String, ReentrantReadWriteLock> dataversesLocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, DatasetLock> datasetsLocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ReentrantReadWriteLock> functionsLocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ReentrantReadWriteLock> nodeGroupsLocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ReentrantReadWriteLock> feedsLocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ReentrantReadWriteLock> feedPolicyLocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ReentrantReadWriteLock> compactionPolicyLocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ReentrantReadWriteLock> dataTypeLocks = new ConcurrentHashMap();

    private MetadataLockManager() {
    }

    public void acquireDataverseReadLock(String dataverseName) {
        ReentrantReadWriteLock dvLock = this.dataversesLocks.get(dataverseName);
        if (dvLock == null) {
            this.dataversesLocks.putIfAbsent(dataverseName, new ReentrantReadWriteLock());
            dvLock = this.dataversesLocks.get(dataverseName);
        }
        dvLock.readLock().lock();
    }

    public void releaseDataverseReadLock(String dataverseName) {
        this.dataversesLocks.get(dataverseName).readLock().unlock();
    }

    public void acquireDataverseWriteLock(String dataverseName) {
        ReentrantReadWriteLock dvLock = this.dataversesLocks.get(dataverseName);
        if (dvLock == null) {
            this.dataversesLocks.putIfAbsent(dataverseName, new ReentrantReadWriteLock());
            dvLock = this.dataversesLocks.get(dataverseName);
        }
        dvLock.writeLock().lock();
    }

    public void releaseDataverseWriteLock(String dataverseName) {
        this.dataversesLocks.get(dataverseName).writeLock().unlock();
    }

    public void acquireDatasetReadLock(String datasetName) {
        DatasetLock dsLock = this.datasetsLocks.get(datasetName);
        if (dsLock == null) {
            this.datasetsLocks.putIfAbsent(datasetName, new DatasetLock());
            dsLock = this.datasetsLocks.get(datasetName);
        }
        dsLock.acquireReadLock();
    }

    public void releaseDatasetReadLock(String datasetName) {
        this.datasetsLocks.get(datasetName).releaseReadLock();
    }

    public void acquireDatasetWriteLock(String datasetName) {
        DatasetLock dsLock = this.datasetsLocks.get(datasetName);
        if (dsLock == null) {
            this.datasetsLocks.putIfAbsent(datasetName, new DatasetLock());
            dsLock = this.datasetsLocks.get(datasetName);
        }
        dsLock.acquireWriteLock();
    }

    public void releaseDatasetWriteLock(String datasetName) {
        this.datasetsLocks.get(datasetName).releaseWriteLock();
    }

    public void acquireDatasetModifyLock(String datasetName) {
        DatasetLock dsLock = this.datasetsLocks.get(datasetName);
        if (dsLock == null) {
            this.datasetsLocks.putIfAbsent(datasetName, new DatasetLock());
            dsLock = this.datasetsLocks.get(datasetName);
        }
        dsLock.acquireReadLock();
        dsLock.acquireReadModifyLock();
    }

    public void releaseDatasetModifyLock(String datasetName) {
        DatasetLock dsLock = this.datasetsLocks.get(datasetName);
        dsLock.releaseReadModifyLock();
        dsLock.releaseReadLock();
    }

    public void acquireDatasetCreateIndexLock(String datasetName) {
        DatasetLock dsLock = this.datasetsLocks.get(datasetName);
        if (dsLock == null) {
            this.datasetsLocks.putIfAbsent(datasetName, new DatasetLock());
            dsLock = this.datasetsLocks.get(datasetName);
        }
        dsLock.acquireReadLock();
        dsLock.acquireWriteModifyLock();
    }

    public void releaseDatasetCreateIndexLock(String datasetName) {
        DatasetLock dsLock = this.datasetsLocks.get(datasetName);
        dsLock.releaseWriteModifyLock();
        dsLock.releaseReadLock();
    }

    public void acquireExternalDatasetRefreshLock(String datasetName) {
        DatasetLock dsLock = this.datasetsLocks.get(datasetName);
        if (dsLock == null) {
            this.datasetsLocks.putIfAbsent(datasetName, new DatasetLock());
            dsLock = this.datasetsLocks.get(datasetName);
        }
        dsLock.acquireReadLock();
        dsLock.acquireRefreshLock();
    }

    public void releaseExternalDatasetRefreshLock(String datasetName) {
        DatasetLock dsLock = this.datasetsLocks.get(datasetName);
        dsLock.releaseRefreshLock();
        dsLock.releaseReadLock();
    }

    public void acquireFunctionReadLock(String functionName) {
        ReentrantReadWriteLock fLock = this.functionsLocks.get(functionName);
        if (fLock == null) {
            this.functionsLocks.putIfAbsent(functionName, new ReentrantReadWriteLock());
            fLock = this.functionsLocks.get(functionName);
        }
        fLock.readLock().lock();
    }

    public void releaseFunctionReadLock(String functionName) {
        this.functionsLocks.get(functionName).readLock().unlock();
    }

    public void acquireFunctionWriteLock(String functionName) {
        ReentrantReadWriteLock fLock = this.functionsLocks.get(functionName);
        if (fLock == null) {
            this.functionsLocks.putIfAbsent(functionName, new ReentrantReadWriteLock());
            fLock = this.functionsLocks.get(functionName);
        }
        fLock.writeLock().lock();
    }

    public void releaseFunctionWriteLock(String functionName) {
        this.functionsLocks.get(functionName).writeLock().unlock();
    }

    public void acquireNodeGroupReadLock(String nodeGroupName) {
        ReentrantReadWriteLock ngLock = this.nodeGroupsLocks.get(nodeGroupName);
        if (ngLock == null) {
            this.nodeGroupsLocks.putIfAbsent(nodeGroupName, new ReentrantReadWriteLock());
            ngLock = this.nodeGroupsLocks.get(nodeGroupName);
        }
        ngLock.readLock().lock();
    }

    public void releaseNodeGroupReadLock(String nodeGroupName) {
        this.nodeGroupsLocks.get(nodeGroupName).readLock().unlock();
    }

    public void acquireNodeGroupWriteLock(String nodeGroupName) {
        ReentrantReadWriteLock ngLock = this.nodeGroupsLocks.get(nodeGroupName);
        if (ngLock == null) {
            this.nodeGroupsLocks.putIfAbsent(nodeGroupName, new ReentrantReadWriteLock());
            ngLock = this.nodeGroupsLocks.get(nodeGroupName);
        }
        ngLock.writeLock().lock();
    }

    public void releaseNodeGroupWriteLock(String nodeGroupName) {
        this.nodeGroupsLocks.get(nodeGroupName).writeLock().unlock();
    }

    public void acquireFeedReadLock(String feedName) {
        ReentrantReadWriteLock fLock = this.feedsLocks.get(feedName);
        if (fLock == null) {
            this.feedsLocks.putIfAbsent(feedName, new ReentrantReadWriteLock());
            fLock = this.feedsLocks.get(feedName);
        }
        fLock.readLock().lock();
    }

    public void releaseFeedReadLock(String feedName) {
        this.feedsLocks.get(feedName).readLock().unlock();
    }

    public void acquireFeedWriteLock(String feedName) {
        ReentrantReadWriteLock fLock = this.feedsLocks.get(feedName);
        if (fLock == null) {
            this.feedsLocks.putIfAbsent(feedName, new ReentrantReadWriteLock());
            fLock = this.feedsLocks.get(feedName);
        }
        fLock.writeLock().lock();
    }

    public void releaseFeedWriteLock(String feedName) {
        this.feedsLocks.get(feedName).writeLock().unlock();
    }

    public void acquireFeedPolicyWriteLock(String policyName) {
        ReentrantReadWriteLock fLock = this.feedPolicyLocks.get(policyName);
        if (fLock == null) {
            this.feedPolicyLocks.putIfAbsent(policyName, new ReentrantReadWriteLock());
            fLock = this.feedPolicyLocks.get(policyName);
        }
        fLock.writeLock().lock();
    }

    public void releaseFeedPolicyWriteLock(String policyName) {
        this.feedPolicyLocks.get(policyName).writeLock().unlock();
    }

    public void acquireCompactionPolicyReadLock(String compactionPolicyName) {
        ReentrantReadWriteLock compactionPolicyLock = this.compactionPolicyLocks.get(compactionPolicyName);
        if (compactionPolicyLock == null) {
            this.compactionPolicyLocks.putIfAbsent(compactionPolicyName, new ReentrantReadWriteLock());
            compactionPolicyLock = this.compactionPolicyLocks.get(compactionPolicyName);
        }
        compactionPolicyLock.readLock().lock();
    }

    public void releaseCompactionPolicyReadLock(String compactionPolicyName) {
        this.compactionPolicyLocks.get(compactionPolicyName).readLock().unlock();
    }

    public void acquireCompactionPolicyWriteLock(String compactionPolicyName) {
        ReentrantReadWriteLock compactionPolicyLock = this.compactionPolicyLocks.get(compactionPolicyName);
        if (compactionPolicyLock == null) {
            this.compactionPolicyLocks.putIfAbsent(compactionPolicyName, new ReentrantReadWriteLock());
            compactionPolicyLock = this.compactionPolicyLocks.get(compactionPolicyName);
        }
        compactionPolicyLock.writeLock().lock();
    }

    public void releaseCompactionPolicyWriteLock(String compactionPolicyName) {
        this.compactionPolicyLocks.get(compactionPolicyName).writeLock().unlock();
    }

    public void acquireDataTypeReadLock(String dataTypeName) {
        ReentrantReadWriteLock dataTypeLock = this.dataTypeLocks.get(dataTypeName);
        if (dataTypeLock == null) {
            this.dataTypeLocks.putIfAbsent(dataTypeName, new ReentrantReadWriteLock());
            dataTypeLock = this.dataTypeLocks.get(dataTypeName);
        }
        dataTypeLock.readLock().lock();
    }

    public void releaseDataTypeReadLock(String dataTypeName) {
        this.dataTypeLocks.get(dataTypeName).readLock().unlock();
    }

    public void acquireDataTypeWriteLock(String dataTypeName) {
        ReentrantReadWriteLock dataTypeLock = this.dataTypeLocks.get(dataTypeName);
        if (dataTypeLock == null) {
            this.dataTypeLocks.putIfAbsent(dataTypeName, new ReentrantReadWriteLock());
            dataTypeLock = this.dataTypeLocks.get(dataTypeName);
        }
        dataTypeLock.writeLock().lock();
    }

    public void releaseDataTypeWriteLock(String dataTypeName) {
        this.dataTypeLocks.get(dataTypeName).writeLock().unlock();
    }

    public void createDatasetBegin(String dataverseName, String itemTypeFullyQualifiedName, String nodeGroupName, String compactionPolicyName, String datasetFullyQualifiedName, boolean isDefaultCompactionPolicy) {
        this.acquireDataverseReadLock(dataverseName);
        this.acquireDataTypeReadLock(itemTypeFullyQualifiedName);
        this.acquireNodeGroupReadLock(nodeGroupName);
        if (!isDefaultCompactionPolicy) {
            this.acquireCompactionPolicyReadLock(compactionPolicyName);
        }
        this.acquireDatasetWriteLock(datasetFullyQualifiedName);
    }

    public void createDatasetEnd(String dataverseName, String itemTypeFullyQualifiedName, String nodeGroupName, String compactionPolicyName, String datasetFullyQualifiedName, boolean isDefaultCompactionPolicy) {
        this.releaseDatasetWriteLock(datasetFullyQualifiedName);
        if (!isDefaultCompactionPolicy) {
            this.releaseCompactionPolicyReadLock(compactionPolicyName);
        }
        this.releaseNodeGroupReadLock(nodeGroupName);
        this.releaseDataTypeReadLock(itemTypeFullyQualifiedName);
        this.releaseDataverseReadLock(dataverseName);
    }

    public void createIndexBegin(String dataverseName, String datasetFullyQualifiedName) {
        this.acquireDataverseReadLock(dataverseName);
        this.acquireDatasetCreateIndexLock(datasetFullyQualifiedName);
    }

    public void createIndexEnd(String dataverseName, String datasetFullyQualifiedName) {
        this.releaseDatasetCreateIndexLock(datasetFullyQualifiedName);
        this.releaseDataverseReadLock(dataverseName);
    }

    public void createTypeBegin(String dataverseName, String itemTypeFullyQualifiedName) {
        this.acquireDataverseReadLock(dataverseName);
        this.acquireDataTypeWriteLock(itemTypeFullyQualifiedName);
    }

    public void createTypeEnd(String dataverseName, String itemTypeFullyQualifiedName) {
        this.releaseDataTypeWriteLock(itemTypeFullyQualifiedName);
        this.releaseDataverseReadLock(dataverseName);
    }

    public void dropDatasetBegin(String dataverseName, String datasetFullyQualifiedName) {
        this.acquireDataverseReadLock(dataverseName);
        this.acquireDatasetWriteLock(datasetFullyQualifiedName);
    }

    public void dropDatasetEnd(String dataverseName, String datasetFullyQualifiedName) {
        this.releaseDatasetWriteLock(datasetFullyQualifiedName);
        this.releaseDataverseReadLock(dataverseName);
    }

    public void dropIndexBegin(String dataverseName, String datasetFullyQualifiedName) {
        this.acquireDataverseReadLock(dataverseName);
        this.acquireDatasetWriteLock(datasetFullyQualifiedName);
    }

    public void dropIndexEnd(String dataverseName, String datasetFullyQualifiedName) {
        this.releaseDatasetWriteLock(datasetFullyQualifiedName);
        this.releaseDataverseReadLock(dataverseName);
    }

    public void dropTypeBegin(String dataverseName, String dataTypeFullyQualifiedName) {
        this.acquireDataverseReadLock(dataverseName);
        this.acquireDataTypeWriteLock(dataTypeFullyQualifiedName);
    }

    public void dropTypeEnd(String dataverseName, String dataTypeFullyQualifiedName) {
        this.releaseDataTypeWriteLock(dataTypeFullyQualifiedName);
        this.releaseDataverseReadLock(dataverseName);
    }

    public void functionStatementBegin(String dataverseName, String functionFullyQualifiedName) {
        this.acquireDataverseReadLock(dataverseName);
        this.acquireFunctionWriteLock(functionFullyQualifiedName);
    }

    public void functionStatementEnd(String dataverseName, String functionFullyQualifiedName) {
        this.releaseFunctionWriteLock(functionFullyQualifiedName);
        this.releaseDataverseReadLock(dataverseName);
    }

    public void modifyDatasetBegin(String dataverseName, String datasetFullyQualifiedName) {
        this.acquireDataverseReadLock(dataverseName);
        this.acquireDatasetModifyLock(datasetFullyQualifiedName);
    }

    public void modifyDatasetEnd(String dataverseName, String datasetFullyQualifiedName) {
        this.releaseDatasetModifyLock(datasetFullyQualifiedName);
        this.releaseDataverseReadLock(dataverseName);
    }

    public void insertDeleteBegin(String dataverseName, String datasetFullyQualifiedName, List<String> dataverses, List<String> datasets) {
        String current;
        int i;
        dataverses.add(dataverseName);
        datasets.add(datasetFullyQualifiedName);
        Collections.sort(dataverses);
        Collections.sort(datasets);
        String previous = null;
        for (i = 0; i < dataverses.size(); ++i) {
            current = dataverses.get(i);
            if (current.equals(previous)) continue;
            this.acquireDataverseReadLock(current);
            previous = current;
        }
        for (i = 0; i < datasets.size(); ++i) {
            current = datasets.get(i);
            if (current.equals(previous)) continue;
            if (current.equals(datasetFullyQualifiedName)) {
                this.acquireDatasetModifyLock(current);
            } else {
                this.acquireDatasetReadLock(current);
            }
            previous = current;
        }
    }

    public void insertDeleteEnd(String dataverseName, String datasetFullyQualifiedName, List<String> dataverses, List<String> datasets) {
        String current;
        int i;
        String previous = null;
        for (i = dataverses.size() - 1; i >= 0; --i) {
            current = dataverses.get(i);
            if (current.equals(previous)) continue;
            this.releaseDataverseReadLock(current);
            previous = current;
        }
        for (i = datasets.size() - 1; i >= 0; --i) {
            current = datasets.get(i);
            if (current.equals(previous)) continue;
            if (current.equals(datasetFullyQualifiedName)) {
                this.releaseDatasetModifyLock(current);
            } else {
                this.releaseDatasetReadLock(current);
            }
            previous = current;
        }
    }

    public void dropFeedBegin(String dataverseName, String feedFullyQualifiedName) {
        this.acquireDataverseReadLock(dataverseName);
        this.acquireFeedWriteLock(feedFullyQualifiedName);
    }

    public void dropFeedEnd(String dataverseName, String feedFullyQualifiedName) {
        this.releaseFeedWriteLock(feedFullyQualifiedName);
        this.releaseDataverseReadLock(dataverseName);
    }

    public void dropFeedPolicyBegin(String dataverseName, String policyName) {
        this.releaseFeedWriteLock(policyName);
        this.releaseDataverseReadLock(dataverseName);
    }

    public void dropFeedPolicyEnd(String dataverseName, String policyName) {
        this.releaseFeedWriteLock(policyName);
        this.releaseDataverseReadLock(dataverseName);
    }

    public void createFeedBegin(String dataverseName, String feedFullyQualifiedName) {
        this.acquireDataverseReadLock(dataverseName);
        this.acquireFeedWriteLock(feedFullyQualifiedName);
    }

    public void createFeedEnd(String dataverseName, String feedFullyQualifiedName) {
        this.releaseFeedWriteLock(feedFullyQualifiedName);
        this.releaseDataverseReadLock(dataverseName);
    }

    public void connectFeedBegin(String dataverseName, String datasetFullyQualifiedName, String feedFullyQualifiedName) {
        this.acquireDataverseReadLock(dataverseName);
        this.acquireDatasetReadLock(datasetFullyQualifiedName);
        this.acquireFeedReadLock(feedFullyQualifiedName);
    }

    public void connectFeedEnd(String dataverseName, String datasetFullyQualifiedName, String feedFullyQualifiedName) {
        this.releaseFeedReadLock(feedFullyQualifiedName);
        this.releaseDatasetReadLock(datasetFullyQualifiedName);
        this.releaseDataverseReadLock(dataverseName);
    }

    public void createFeedPolicyBegin(String dataverseName, String policyName) {
        this.acquireDataverseReadLock(dataverseName);
        this.acquireFeedPolicyWriteLock(policyName);
    }

    public void createFeedPolicyEnd(String dataverseName, String policyName) {
        this.releaseFeedPolicyWriteLock(policyName);
        this.releaseDataverseReadLock(dataverseName);
    }

    public void disconnectFeedBegin(String dataverseName, String datasetFullyQualifiedName, String feedFullyQualifiedName) {
        this.acquireDataverseReadLock(dataverseName);
        this.acquireDatasetReadLock(datasetFullyQualifiedName);
        this.acquireFeedReadLock(feedFullyQualifiedName);
    }

    public void disconnectFeedEnd(String dataverseName, String datasetFullyQualifiedName, String feedFullyQualifiedName) {
        this.releaseFeedReadLock(feedFullyQualifiedName);
        this.releaseDatasetReadLock(datasetFullyQualifiedName);
        this.releaseDataverseReadLock(dataverseName);
    }

    public void subscribeFeedBegin(String dataverseName, String datasetFullyQualifiedName, String feedFullyQualifiedName) {
        this.acquireDataverseReadLock(dataverseName);
        this.acquireDatasetReadLock(datasetFullyQualifiedName);
        this.acquireFeedReadLock(feedFullyQualifiedName);
    }

    public void subscribeFeedEnd(String dataverseName, String datasetFullyQualifiedName, String feedFullyQualifiedName) {
        this.releaseFeedReadLock(feedFullyQualifiedName);
        this.releaseDatasetReadLock(datasetFullyQualifiedName);
        this.releaseDataverseReadLock(dataverseName);
    }

    public void compactBegin(String dataverseName, String datasetFullyQualifiedName) {
        this.acquireDataverseReadLock(dataverseName);
        this.acquireDatasetReadLock(datasetFullyQualifiedName);
    }

    public void compactEnd(String dataverseName, String datasetFullyQualifiedName) {
        this.releaseDatasetReadLock(datasetFullyQualifiedName);
        this.releaseDataverseReadLock(dataverseName);
    }

    public void queryBegin(Dataverse dataverse, List<String> dataverses, List<String> datasets) {
        String current;
        int i;
        if (dataverse != null) {
            dataverses.add(dataverse.getDataverseName());
        }
        Collections.sort(dataverses);
        Collections.sort(datasets);
        String previous = null;
        for (i = 0; i < dataverses.size(); ++i) {
            current = dataverses.get(i);
            if (current.equals(previous)) continue;
            this.acquireDataverseReadLock(current);
            previous = current;
        }
        for (i = 0; i < datasets.size(); ++i) {
            current = datasets.get(i);
            if (current.equals(previous)) continue;
            this.acquireDatasetReadLock(current);
            previous = current;
        }
    }

    public void queryEnd(List<String> dataverses, List<String> datasets) {
        String current;
        int i;
        String previous = null;
        for (i = dataverses.size() - 1; i >= 0; --i) {
            current = dataverses.get(i);
            if (current.equals(previous)) continue;
            this.releaseDataverseReadLock(current);
            previous = current;
        }
        for (i = datasets.size() - 1; i >= 0; --i) {
            current = datasets.get(i);
            if (current.equals(previous)) continue;
            this.releaseDatasetReadLock(current);
            previous = current;
        }
    }

    public void refreshDatasetBegin(String dataverseName, String datasetFullyQualifiedName) {
        this.acquireDataverseReadLock(dataverseName);
        this.acquireExternalDatasetRefreshLock(datasetFullyQualifiedName);
    }

    public void refreshDatasetEnd(String dataverseName, String datasetFullyQualifiedName) {
        this.releaseExternalDatasetRefreshLock(datasetFullyQualifiedName);
        this.releaseDataverseReadLock(dataverseName);
    }

    public void pregelixBegin(String dataverseName, String datasetFullyQualifiedNameFrom, String datasetFullyQualifiedNameTo) {
        this.acquireDataverseReadLock(dataverseName);
        if (datasetFullyQualifiedNameFrom.compareTo(datasetFullyQualifiedNameTo) < 0) {
            this.acquireDatasetReadLock(datasetFullyQualifiedNameFrom);
            this.acquireDatasetWriteLock(datasetFullyQualifiedNameTo);
        } else {
            this.acquireDatasetWriteLock(datasetFullyQualifiedNameTo);
            this.acquireDatasetReadLock(datasetFullyQualifiedNameFrom);
        }
    }

    public void pregelixEnd(String dataverseName, String datasetFullyQualifiedNameFrom, String datasetFullyQualifiedNameTo) {
        this.releaseDatasetReadLock(datasetFullyQualifiedNameFrom);
        this.releaseDatasetWriteLock(datasetFullyQualifiedNameTo);
        this.releaseDataverseReadLock(dataverseName);
    }
}

