/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.asterix.om.base.AMutableInt32;

public class DatasetLock {
    private ReentrantReadWriteLock dsLock = new ReentrantReadWriteLock(true);
    private ReentrantReadWriteLock dsModifyLock = new ReentrantReadWriteLock(true);
    private AMutableInt32 indexBuildCounter = new AMutableInt32(0);

    public void acquireReadLock() {
        this.dsLock.readLock().lock();
    }

    public void releaseReadLock() {
        this.dsLock.readLock().unlock();
    }

    public void acquireWriteLock() {
        this.dsLock.writeLock().lock();
    }

    public void releaseWriteLock() {
        this.dsLock.writeLock().unlock();
    }

    public void acquireReadModifyLock() {
        this.dsModifyLock.readLock().lock();
    }

    public void releaseReadModifyLock() {
        this.dsModifyLock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireWriteModifyLock() {
        AMutableInt32 aMutableInt32 = this.indexBuildCounter;
        synchronized (aMutableInt32) {
            if (this.indexBuildCounter.getIntegerValue() > 0) {
                this.indexBuildCounter.setValue(this.indexBuildCounter.getIntegerValue() + 1);
            } else {
                this.dsModifyLock.writeLock().lock();
                this.indexBuildCounter.setValue(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWriteModifyLock() {
        AMutableInt32 aMutableInt32 = this.indexBuildCounter;
        synchronized (aMutableInt32) {
            if (this.indexBuildCounter.getIntegerValue() == 1) {
                this.dsModifyLock.writeLock().unlock();
            }
            this.indexBuildCounter.setValue(this.indexBuildCounter.getIntegerValue() - 1);
        }
    }

    public void acquireRefreshLock() {
        this.dsModifyLock.writeLock().lock();
    }

    public void releaseRefreshLock() {
        this.dsModifyLock.writeLock().unlock();
    }
}

