/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.functions;

import org.apache.asterix.metadata.declared.AqlMetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.AsterixBuiltinFunctions;
import org.apache.asterix.om.typecomputer.base.IResultTypeComputer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;

public class MetadataBuiltinFunctions {
    public static void addMetadataBuiltinFunctions() {
        AsterixBuiltinFunctions.addFunction((FunctionIdentifier)AsterixBuiltinFunctions.DATASET, (IResultTypeComputer)new IResultTypeComputer(){

            public IAType computeType(ILogicalExpression expression, IVariableTypeEnvironment env, IMetadataProvider<?, ?> mp) throws AlgebricksException {
                AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)expression;
                if (f.getArguments().size() != 1) {
                    throw new AlgebricksException("dataset arity is 1, not " + f.getArguments().size());
                }
                ILogicalExpression a1 = (ILogicalExpression)((Mutable)f.getArguments().get(0)).getValue();
                IAType t1 = (IAType)env.getType(a1);
                if (t1.getTypeTag() == ATypeTag.ANY) {
                    return BuiltinType.ANY;
                }
                if (t1.getTypeTag() != ATypeTag.STRING) {
                    throw new AlgebricksException("Illegal type " + t1 + " for dataset() argument.");
                }
                if (a1.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
                    return BuiltinType.ANY;
                }
                AsterixConstantValue acv = (AsterixConstantValue)((ConstantExpression)a1).getValue();
                String datasetArg = ((AString)acv.getObject()).getStringValue();
                AqlMetadataProvider metadata = (AqlMetadataProvider)mp;
                Pair datasetInfo = MetadataBuiltinFunctions.getDatasetInfo(metadata, datasetArg);
                String dataverseName = (String)datasetInfo.first;
                String datasetName = (String)datasetInfo.second;
                if (dataverseName == null) {
                    throw new AlgebricksException("Unspecified dataverse!");
                }
                Dataset dataset = metadata.findDataset(dataverseName, datasetName);
                if (dataset == null) {
                    throw new AlgebricksException("Could not find dataset " + datasetName + " in dataverse " + dataverseName);
                }
                String tn = dataset.getItemTypeName();
                IAType t2 = metadata.findType(dataverseName, tn);
                if (t2 == null) {
                    throw new AlgebricksException("No type for dataset " + datasetName);
                }
                return t2;
            }
        }, (boolean)true);
        AsterixBuiltinFunctions.addPrivateFunction((FunctionIdentifier)AsterixBuiltinFunctions.FEED_COLLECT, (IResultTypeComputer)new IResultTypeComputer(){

            public IAType computeType(ILogicalExpression expression, IVariableTypeEnvironment env, IMetadataProvider<?, ?> mp) throws AlgebricksException {
                AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)expression;
                if (f.getArguments().size() != AsterixBuiltinFunctions.FEED_COLLECT.getArity()) {
                    throw new AlgebricksException("Incorrect number of arguments -> arity is " + AsterixBuiltinFunctions.FEED_COLLECT.getArity() + ", not " + f.getArguments().size());
                }
                ILogicalExpression a1 = (ILogicalExpression)((Mutable)f.getArguments().get(5)).getValue();
                IAType t1 = (IAType)env.getType(a1);
                if (t1.getTypeTag() == ATypeTag.ANY) {
                    return BuiltinType.ANY;
                }
                if (t1.getTypeTag() != ATypeTag.STRING) {
                    throw new AlgebricksException("Illegal type " + t1 + " for feed-ingest argument.");
                }
                if (a1.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
                    return BuiltinType.ANY;
                }
                AsterixConstantValue acv = (AsterixConstantValue)((ConstantExpression)a1).getValue();
                String typeArg = ((AString)acv.getObject()).getStringValue();
                AqlMetadataProvider metadata = (AqlMetadataProvider)mp;
                Pair argInfo = MetadataBuiltinFunctions.getDatasetInfo(metadata, typeArg);
                String dataverseName = (String)argInfo.first;
                String typeName = (String)argInfo.second;
                if (dataverseName == null) {
                    throw new AlgebricksException("Unspecified dataverse!");
                }
                IAType t2 = metadata.findType(dataverseName, typeName);
                if (t2 == null) {
                    throw new AlgebricksException("Unknown type  " + typeName);
                }
                return t2;
            }
        }, (boolean)true);
        AsterixBuiltinFunctions.addFunction((FunctionIdentifier)AsterixBuiltinFunctions.FEED_INTERCEPT, (IResultTypeComputer)new IResultTypeComputer(){

            public IAType computeType(ILogicalExpression expression, IVariableTypeEnvironment env, IMetadataProvider<?, ?> mp) throws AlgebricksException {
                AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)expression;
                if (f.getArguments().size() != 1) {
                    throw new AlgebricksException("dataset arity is 1, not " + f.getArguments().size());
                }
                ILogicalExpression a1 = (ILogicalExpression)((Mutable)f.getArguments().get(0)).getValue();
                IAType t1 = (IAType)env.getType(a1);
                if (t1.getTypeTag() == ATypeTag.ANY) {
                    return BuiltinType.ANY;
                }
                if (t1.getTypeTag() != ATypeTag.STRING) {
                    throw new AlgebricksException("Illegal type " + t1 + " for dataset() argument.");
                }
                if (a1.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
                    return BuiltinType.ANY;
                }
                AsterixConstantValue acv = (AsterixConstantValue)((ConstantExpression)a1).getValue();
                String datasetArg = ((AString)acv.getObject()).getStringValue();
                AqlMetadataProvider metadata = (AqlMetadataProvider)mp;
                Pair datasetInfo = MetadataBuiltinFunctions.getDatasetInfo(metadata, datasetArg);
                String dataverseName = (String)datasetInfo.first;
                String datasetName = (String)datasetInfo.second;
                if (dataverseName == null) {
                    throw new AlgebricksException("Unspecified dataverse!");
                }
                Dataset dataset = metadata.findDataset(dataverseName, datasetName);
                if (dataset == null) {
                    throw new AlgebricksException("Could not find dataset " + datasetName + " in dataverse " + dataverseName);
                }
                String tn = dataset.getItemTypeName();
                IAType t2 = metadata.findType(dataverseName, tn);
                if (t2 == null) {
                    throw new AlgebricksException("No type for dataset " + datasetName);
                }
                return t2;
            }
        }, (boolean)true);
    }

    private static Pair<String, String> getDatasetInfo(AqlMetadataProvider metadata, String datasetArg) {
        String second;
        String first;
        String[] nameComponents = datasetArg.split("\\.");
        if (nameComponents.length == 1) {
            first = metadata.getDefaultDataverse() == null ? null : metadata.getDefaultDataverse().getDataverseName();
            second = nameComponents[0];
        } else {
            first = nameComponents[0];
            second = nameComponents[1];
        }
        return new Pair((Object)first, (Object)second);
    }

    static {
        MetadataBuiltinFunctions.addMetadataBuiltinFunctions();
        AsterixBuiltinFunctions.addUnnestFun((FunctionIdentifier)AsterixBuiltinFunctions.DATASET, (boolean)false);
        AsterixBuiltinFunctions.addDatasetFunction((FunctionIdentifier)AsterixBuiltinFunctions.DATASET);
        AsterixBuiltinFunctions.addUnnestFun((FunctionIdentifier)AsterixBuiltinFunctions.FEED_COLLECT, (boolean)false);
        AsterixBuiltinFunctions.addDatasetFunction((FunctionIdentifier)AsterixBuiltinFunctions.FEED_COLLECT);
        AsterixBuiltinFunctions.addUnnestFun((FunctionIdentifier)AsterixBuiltinFunctions.FEED_INTERCEPT, (boolean)false);
        AsterixBuiltinFunctions.addDatasetFunction((FunctionIdentifier)AsterixBuiltinFunctions.FEED_INTERCEPT);
    }
}

