/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.functions;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.functions.AsterixExternalScalarFunctionInfo;
import org.apache.asterix.om.functions.AsterixFunction;
import org.apache.asterix.om.typecomputer.base.IResultTypeComputer;
import org.apache.asterix.om.typecomputer.impl.ABinaryTypeComputer;
import org.apache.asterix.om.typecomputer.impl.ADoubleTypeComputer;
import org.apache.asterix.om.typecomputer.impl.AFloatTypeComputer;
import org.apache.asterix.om.typecomputer.impl.AInt32TypeComputer;
import org.apache.asterix.om.typecomputer.impl.AStringTypeComputer;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;

public class ExternalFunctionCompilerUtil
implements Serializable {
    private static Pattern orderedListPattern = Pattern.compile("\\[*\\]");
    private static Pattern unorderedListPattern = Pattern.compile("[{{*}}]");

    public static IFunctionInfo getExternalFunctionInfo(MetadataTransactionContext txnCtx, Function function) throws MetadataException {
        String functionKind = function.getKind();
        IFunctionInfo finfo = null;
        if (AbstractFunctionCallExpression.FunctionKind.SCALAR.toString().equalsIgnoreCase(functionKind)) {
            finfo = ExternalFunctionCompilerUtil.getScalarFunctionInfo(txnCtx, function);
        } else if (AbstractFunctionCallExpression.FunctionKind.AGGREGATE.toString().equalsIgnoreCase(functionKind)) {
            finfo = ExternalFunctionCompilerUtil.getAggregateFunctionInfo(txnCtx, function);
        } else if (AbstractFunctionCallExpression.FunctionKind.STATEFUL.toString().equalsIgnoreCase(functionKind)) {
            finfo = ExternalFunctionCompilerUtil.getStatefulFunctionInfo(txnCtx, function);
        } else if (AbstractFunctionCallExpression.FunctionKind.UNNEST.toString().equalsIgnoreCase(functionKind)) {
            finfo = ExternalFunctionCompilerUtil.getUnnestFunctionInfo(txnCtx, function);
        }
        return finfo;
    }

    private static IFunctionInfo getScalarFunctionInfo(MetadataTransactionContext txnCtx, Function function) throws MetadataException {
        FunctionIdentifier fid = new FunctionIdentifier(function.getDataverseName(), function.getName(), function.getArity());
        IResultTypeComputer typeComputer = ExternalFunctionCompilerUtil.getResultTypeComputer(txnCtx, function);
        ArrayList<IAType> arguments = new ArrayList<IAType>();
        IAType returnType = null;
        List<String> paramTypes = function.getParams();
        for (String paramType : paramTypes) {
            arguments.add(ExternalFunctionCompilerUtil.getTypeInfo(paramType, txnCtx, function));
        }
        returnType = ExternalFunctionCompilerUtil.getTypeInfo(function.getReturnType(), txnCtx, function);
        AsterixExternalScalarFunctionInfo scalarFunctionInfo = new AsterixExternalScalarFunctionInfo(fid.getNamespace(), new AsterixFunction(fid.getName(), fid.getArity()), returnType, function.getFunctionBody(), function.getLanguage(), arguments, typeComputer);
        return scalarFunctionInfo;
    }

    private static IAType getTypeInfo(String paramType, MetadataTransactionContext txnCtx, Function function) throws MetadataException {
        if (paramType.equalsIgnoreCase(BuiltinType.AINT32.getDisplayName())) {
            return BuiltinType.AINT32;
        }
        if (paramType.equalsIgnoreCase(BuiltinType.AFLOAT.getDisplayName())) {
            return BuiltinType.AFLOAT;
        }
        if (paramType.equalsIgnoreCase(BuiltinType.ASTRING.getDisplayName())) {
            return BuiltinType.ASTRING;
        }
        if (paramType.equalsIgnoreCase(BuiltinType.ADOUBLE.getDisplayName())) {
            return BuiltinType.ADOUBLE;
        }
        IAType collection = ExternalFunctionCompilerUtil.getCollectionType(paramType, txnCtx, function);
        if (collection != null) {
            return collection;
        }
        Datatype datatype = MetadataManager.INSTANCE.getDatatype(txnCtx, function.getDataverseName(), paramType);
        if (datatype == null) {
            throw new MetadataException(" Type " + paramType + " not defined");
        }
        return datatype.getDatatype();
    }

    private static IAType getCollectionType(String paramType, MetadataTransactionContext txnCtx, Function function) throws MetadataException {
        Matcher matcher = orderedListPattern.matcher(paramType);
        if (matcher.find()) {
            String subType = paramType.substring(paramType.indexOf(91) + 1, paramType.lastIndexOf(93));
            return new AOrderedListType(ExternalFunctionCompilerUtil.getTypeInfo(subType, txnCtx, function), "AOrderedList");
        }
        matcher = unorderedListPattern.matcher(paramType);
        if (matcher.find()) {
            String subType = paramType.substring(paramType.indexOf("{{") + 2, paramType.lastIndexOf("}}"));
            return new AUnorderedListType(ExternalFunctionCompilerUtil.getTypeInfo(subType, txnCtx, function), "AUnorderedList");
        }
        return null;
    }

    private static IResultTypeComputer getResultTypeComputer(MetadataTransactionContext txnCtx, Function function) throws MetadataException {
        final IAType type = ExternalFunctionCompilerUtil.getTypeInfo(function.getReturnType(), txnCtx, function);
        switch (type.getTypeTag()) {
            case INT32: {
                return AInt32TypeComputer.INSTANCE;
            }
            case FLOAT: {
                return AFloatTypeComputer.INSTANCE;
            }
            case DOUBLE: {
                return ADoubleTypeComputer.INSTANCE;
            }
            case BINARY: {
                return ABinaryTypeComputer.INSTANCE;
            }
            case STRING: {
                return AStringTypeComputer.INSTANCE;
            }
            case ORDEREDLIST: {
                return new IResultTypeComputer(){

                    public IAType computeType(ILogicalExpression expression, IVariableTypeEnvironment env, IMetadataProvider<?, ?> metadataProvider) throws AlgebricksException {
                        return new AOrderedListType(((AOrderedListType)type).getItemType(), ((AOrderedListType)type).getItemType().getTypeName());
                    }
                };
            }
            case UNORDEREDLIST: {
                return new IResultTypeComputer(){

                    public IAType computeType(ILogicalExpression expression, IVariableTypeEnvironment env, IMetadataProvider<?, ?> metadataProvider) throws AlgebricksException {
                        return new AUnorderedListType(type, type.getTypeName());
                    }
                };
            }
        }
        IResultTypeComputer typeComputer = new IResultTypeComputer(){

            public IAType computeType(ILogicalExpression expression, IVariableTypeEnvironment env, IMetadataProvider<?, ?> mp) throws AlgebricksException {
                return type;
            }
        };
        return typeComputer;
    }

    private static IAType getType(Function function, MetadataTransactionContext txnCtx) throws AlgebricksException {
        IAType collectionType = null;
        try {
            collectionType = ExternalFunctionCompilerUtil.getCollectionType(function.getReturnType(), txnCtx, function);
            if (collectionType != null) {
                return collectionType;
            }
            Datatype datatype = MetadataManager.INSTANCE.getDatatype(txnCtx, function.getDataverseName(), function.getReturnType());
            return datatype.getDatatype();
        }
        catch (MetadataException me) {
            throw new AlgebricksException((Throwable)((Object)me));
        }
    }

    private static IFunctionInfo getUnnestFunctionInfo(MetadataTransactionContext txnCtx, Function function) {
        return null;
    }

    private static IFunctionInfo getStatefulFunctionInfo(MetadataTransactionContext txnCtx, Function function) {
        return null;
    }

    private static IFunctionInfo getAggregateFunctionInfo(MetadataTransactionContext txnCtx, Function function) {
        return null;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        ExternalFunctionCompilerUtil obj = new ExternalFunctionCompilerUtil();
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream("/tmp/ecu.obj"));
        oos.writeObject(obj);
    }
}

