/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.feeds;

import org.apache.asterix.common.feeds.FeedConnectionId;
import org.apache.asterix.common.feeds.api.IFeedMessage;
import org.apache.asterix.common.feeds.message.FeedMessage;
import org.json.JSONException;
import org.json.JSONObject;

public class XAQLFeedMessage
extends FeedMessage {
    private static final long serialVersionUID = 1L;
    private final String aql;
    private final FeedConnectionId connectionId;

    public XAQLFeedMessage(FeedConnectionId connectionId, String aql) {
        super(IFeedMessage.MessageType.XAQL);
        this.connectionId = connectionId;
        this.aql = aql;
    }

    public String toString() {
        return this.messageType.name() + " " + this.connectionId + " [" + this.aql + "] ";
    }

    public FeedConnectionId getConnectionId() {
        return this.connectionId;
    }

    public String getAql() {
        return this.aql;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put("message-type", (Object)this.messageType.name());
        obj.put("dataverse", (Object)this.connectionId.getFeedId().getDataverse());
        obj.put("feed", (Object)this.connectionId.getFeedId().getFeedName());
        obj.put("dataset", (Object)this.connectionId.getDatasetName());
        obj.put("aql", (Object)this.aql);
        return obj;
    }
}

