/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.feeds;

import org.apache.asterix.common.feeds.FeedConnectionId;
import org.apache.asterix.common.feeds.api.IFeedMessage;
import org.apache.asterix.common.feeds.message.FeedMessage;
import org.json.JSONException;
import org.json.JSONObject;

public class PrepareStallMessage
extends FeedMessage {
    private static final long serialVersionUID = 1L;
    private final FeedConnectionId connectionId;
    private final int computePartitionsRetainLimit;

    public PrepareStallMessage(FeedConnectionId connectionId, int computePartitionsRetainLimit) {
        super(IFeedMessage.MessageType.PREPARE_STALL);
        this.connectionId = connectionId;
        this.computePartitionsRetainLimit = computePartitionsRetainLimit;
    }

    public String toString() {
        return IFeedMessage.MessageType.PREPARE_STALL.name() + "  " + this.connectionId;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put("message-type", (Object)this.messageType.name());
        obj.put("dataverse", (Object)this.connectionId.getFeedId().getDataverse());
        obj.put("feed", (Object)this.connectionId.getFeedId().getFeedName());
        obj.put("dataset", (Object)this.connectionId.getDatasetName());
        obj.put("compute-partition-retain-limit", this.computePartitionsRetainLimit);
        return obj;
    }

    public FeedConnectionId getConnectionId() {
        return this.connectionId;
    }

    public int getComputePartitionsRetainLimit() {
        return this.computePartitionsRetainLimit;
    }
}

