/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.feeds;

import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.CharBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageListener {
    private static final Logger LOGGER = Logger.getLogger(MessageListener.class.getName());
    private final int port;
    private final LinkedBlockingQueue<String> outbox;
    private ExecutorService executorService = Executors.newFixedThreadPool(10);
    private MessageListenerServer listenerServer;

    public MessageListener(int port, LinkedBlockingQueue<String> outbox) {
        this.port = port;
        this.outbox = outbox;
    }

    public void stop() {
        this.listenerServer.stop();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Stopped message service at " + this.port);
        }
        if (!this.executorService.isShutdown()) {
            this.executorService.shutdownNow();
        }
    }

    public void start() throws IOException {
        this.listenerServer = new MessageListenerServer(this.port, this.outbox);
        this.executorService.execute(this.listenerServer);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Starting message service at " + this.port);
        }
    }

    public static interface IMessageAnalyzer {
        public LinkedBlockingQueue<String> getMessageQueue();
    }

    private static class MessageListenerServer
    implements Runnable {
        private final int port;
        private final LinkedBlockingQueue<String> outbox;
        private ServerSocket server;

        public MessageListenerServer(int port, LinkedBlockingQueue<String> outbox) {
            this.port = port;
            this.outbox = outbox;
        }

        public void stop() {
            try {
                this.server.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            char EOL = (char)"\n".getBytes()[0];
            Socket client = null;
            try {
                char ch;
                this.server = new ServerSocket(this.port);
                client = this.server.accept();
                InputStream in = client.getInputStream();
                CharBuffer buffer = CharBuffer.allocate(5000);
                while ((ch = (char)in.read()) != '\uffffffff') {
                    while (ch != EOL) {
                        buffer.put(ch);
                        ch = (char)in.read();
                    }
                    buffer.flip();
                    String s = new String(buffer.array());
                    LinkedBlockingQueue<String> linkedBlockingQueue = this.outbox;
                    synchronized (linkedBlockingQueue) {
                        this.outbox.add(s + "\n");
                    }
                    buffer.position(0);
                    buffer.limit(5000);
                }
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Unable to start Message listener" + this.server);
                }
            }
            finally {
                if (this.server != null) {
                    try {
                        this.server.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

