/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.feeds;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.feeds.SubscribableFeedRuntimeId;
import org.apache.asterix.common.feeds.api.IFeedSubscriptionManager;
import org.apache.asterix.common.feeds.api.ISubscribableRuntime;

public class FeedSubscriptionManager
implements IFeedSubscriptionManager {
    private static Logger LOGGER = Logger.getLogger(FeedSubscriptionManager.class.getName());
    private final String nodeId;
    private final Map<SubscribableFeedRuntimeId, ISubscribableRuntime> subscribableRuntimes;

    public FeedSubscriptionManager(String nodeId) {
        this.nodeId = nodeId;
        this.subscribableRuntimes = new HashMap<SubscribableFeedRuntimeId, ISubscribableRuntime>();
    }

    public void registerFeedSubscribableRuntime(ISubscribableRuntime subscribableRuntime) {
        SubscribableFeedRuntimeId sid = (SubscribableFeedRuntimeId)subscribableRuntime.getRuntimeId();
        if (!this.subscribableRuntimes.containsKey(sid)) {
            this.subscribableRuntimes.put(sid, subscribableRuntime);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Registered feed subscribable runtime " + subscribableRuntime);
            }
        } else if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.warning("Feed ingestion runtime " + subscribableRuntime + " already registered.");
        }
    }

    public ISubscribableRuntime getSubscribableRuntime(SubscribableFeedRuntimeId subscribableFeedRuntimeId) {
        return this.subscribableRuntimes.get(subscribableFeedRuntimeId);
    }

    public void deregisterFeedSubscribableRuntime(SubscribableFeedRuntimeId ingestionId) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("De-registered feed subscribable runtime " + ingestionId);
        }
        this.subscribableRuntimes.remove(ingestionId);
    }

    public String toString() {
        return "IngestionManager [" + this.nodeId + "]";
    }
}

