/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.feeds;

import java.util.Map;
import org.apache.asterix.common.feeds.FeedConnectionId;
import org.apache.asterix.common.feeds.api.IFeedRuntime;
import org.apache.asterix.metadata.feeds.FeedMetaComputeNodePushable;
import org.apache.asterix.metadata.feeds.FeedMetaNodePushable;
import org.apache.asterix.metadata.feeds.FeedMetaStoreNodePushable;
import org.apache.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;

public class FeedMetaOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private IOperatorDescriptor coreOperator;
    private final FeedConnectionId feedConnectionId;
    private final Map<String, String> feedPolicyProperties;
    private final IFeedRuntime.FeedRuntimeType runtimeType;
    private final String operandId;

    public FeedMetaOperatorDescriptor(JobSpecification spec, FeedConnectionId feedConnectionId, IOperatorDescriptor coreOperatorDescriptor, Map<String, String> feedPolicyProperties, IFeedRuntime.FeedRuntimeType runtimeType, boolean enableSubscriptionMode, String operandId) {
        super((IOperatorDescriptorRegistry)spec, coreOperatorDescriptor.getInputArity(), coreOperatorDescriptor.getOutputArity());
        this.feedConnectionId = feedConnectionId;
        this.feedPolicyProperties = feedPolicyProperties;
        if (coreOperatorDescriptor.getOutputRecordDescriptors().length == 1) {
            this.recordDescriptors[0] = coreOperatorDescriptor.getOutputRecordDescriptors()[0];
        }
        this.coreOperator = coreOperatorDescriptor;
        this.runtimeType = runtimeType;
        this.operandId = operandId;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        Object nodePushable = null;
        switch (this.runtimeType) {
            case COMPUTE: {
                nodePushable = new FeedMetaComputeNodePushable(ctx, recordDescProvider, partition, nPartitions, this.coreOperator, this.feedConnectionId, this.feedPolicyProperties, this.operandId);
                break;
            }
            case STORE: {
                nodePushable = new FeedMetaStoreNodePushable(ctx, recordDescProvider, partition, nPartitions, this.coreOperator, this.feedConnectionId, this.feedPolicyProperties, this.operandId);
                break;
            }
            case OTHER: {
                nodePushable = new FeedMetaNodePushable(ctx, recordDescProvider, partition, nPartitions, this.coreOperator, this.feedConnectionId, this.feedPolicyProperties, this.operandId);
                break;
            }
            case ETS: {
                nodePushable = ((AlgebricksMetaOperatorDescriptor)this.coreOperator).createPushRuntime(ctx, recordDescProvider, partition, nPartitions);
                break;
            }
            case JOIN: {
                break;
            }
            default: {
                throw new HyracksDataException((Throwable)new IllegalArgumentException("Invalid feed runtime: " + this.runtimeType));
            }
        }
        return nodePushable;
    }

    public String toString() {
        return "FeedMeta [" + this.coreOperator + " ]";
    }

    public IOperatorDescriptor getCoreOperator() {
        return this.coreOperator;
    }

    public IFeedRuntime.FeedRuntimeType getRuntimeType() {
        return this.runtimeType;
    }
}

