/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.feeds;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.formats.nontagged.AqlSerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class FeedFrameTupleDecorator {
    private AMutableString aString = new AMutableString("");
    private AMutableInt64 aInt64 = new AMutableInt64(0L);
    private AMutableInt32 aInt32 = new AMutableInt32(0);
    private AtomicInteger tupleId = new AtomicInteger(0);
    private static ISerializerDeserializer<AString> stringSerde = AqlSerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
    private static ISerializerDeserializer<AInt32> int32Serde = AqlSerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
    private static ISerializerDeserializer<AInt64> int64Serde = AqlSerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    private final int partition;
    private final ArrayBackedValueStorage attrNameStorage;
    private final ArrayBackedValueStorage attrValueStorage;

    public FeedFrameTupleDecorator(int partition) {
        this.partition = partition;
        this.attrNameStorage = new ArrayBackedValueStorage();
        this.attrValueStorage = new ArrayBackedValueStorage();
    }

    public void addLongAttribute(String attrName, long attrValue, IARecordBuilder recordBuilder) throws HyracksDataException, AsterixException {
        this.attrNameStorage.reset();
        this.aString.setValue(attrName);
        stringSerde.serialize((Object)this.aString, this.attrNameStorage.getDataOutput());
        this.attrValueStorage.reset();
        this.aInt64.setValue(attrValue);
        int64Serde.serialize((Object)this.aInt64, this.attrValueStorage.getDataOutput());
        recordBuilder.addField((IValueReference)this.attrNameStorage, (IValueReference)this.attrValueStorage);
    }

    public void addIntegerAttribute(String attrName, int attrValue, IARecordBuilder recordBuilder) throws HyracksDataException, AsterixException {
        this.attrNameStorage.reset();
        this.aString.setValue(attrName);
        stringSerde.serialize((Object)this.aString, this.attrNameStorage.getDataOutput());
        this.attrValueStorage.reset();
        this.aInt32.setValue(attrValue);
        int32Serde.serialize((Object)this.aInt32, this.attrValueStorage.getDataOutput());
        recordBuilder.addField((IValueReference)this.attrNameStorage, (IValueReference)this.attrValueStorage);
    }

    public void addTupleId(IARecordBuilder recordBuilder) throws HyracksDataException, AsterixException {
        this.addIntegerAttribute("intake-tupleid", this.tupleId.incrementAndGet(), recordBuilder);
    }

    public void addIntakePartition(IARecordBuilder recordBuilder) throws HyracksDataException, AsterixException {
        this.addIntegerAttribute("intake-partition", this.partition, recordBuilder);
    }

    public void addIntakeTimestamp(IARecordBuilder recordBuilder) throws HyracksDataException, AsterixException {
        this.addLongAttribute("intake-timestamp", System.currentTimeMillis(), recordBuilder);
    }

    public void addStoreTimestamp(IARecordBuilder recordBuilder) throws HyracksDataException, AsterixException {
        this.addLongAttribute("store-timestamp", System.currentTimeMillis(), recordBuilder);
    }
}

