/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.feeds;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.feeds.FeedConnectionId;
import org.apache.asterix.common.feeds.FeedRuntime;
import org.apache.asterix.common.feeds.FeedRuntimeId;
import org.apache.asterix.common.feeds.FeedRuntimeManager;
import org.apache.asterix.common.feeds.api.IFeedConnectionManager;

public class FeedConnectionManager
implements IFeedConnectionManager {
    private static final Logger LOGGER = Logger.getLogger(FeedConnectionManager.class.getName());
    private Map<FeedConnectionId, FeedRuntimeManager> feedRuntimeManagers = new HashMap<FeedConnectionId, FeedRuntimeManager>();
    private final String nodeId;

    public FeedConnectionManager(String nodeId) {
        this.nodeId = nodeId;
    }

    public FeedRuntimeManager getFeedRuntimeManager(FeedConnectionId feedId) {
        return this.feedRuntimeManagers.get(feedId);
    }

    public void deregisterFeed(FeedConnectionId feedId) {
        block3: {
            try {
                FeedRuntimeManager mgr = this.feedRuntimeManagers.get(feedId);
                if (mgr != null) {
                    mgr.close();
                    this.feedRuntimeManagers.remove(feedId);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block3;
                LOGGER.warning("Exception in closing feed runtime" + e.getMessage());
            }
        }
    }

    public synchronized void registerFeedRuntime(FeedConnectionId connectionId, FeedRuntime feedRuntime) throws Exception {
        FeedRuntimeManager runtimeMgr = this.feedRuntimeManagers.get(connectionId);
        if (runtimeMgr == null) {
            runtimeMgr = new FeedRuntimeManager(connectionId, (IFeedConnectionManager)this);
            this.feedRuntimeManagers.put(connectionId, runtimeMgr);
        }
        runtimeMgr.registerFeedRuntime(feedRuntime.getRuntimeId(), feedRuntime);
    }

    public void deRegisterFeedRuntime(FeedConnectionId connectionId, FeedRuntimeId feedRuntimeId) {
        FeedRuntimeManager runtimeMgr = this.feedRuntimeManagers.get(connectionId);
        if (runtimeMgr != null) {
            runtimeMgr.deregisterFeedRuntime(feedRuntimeId);
        }
    }

    public FeedRuntime getFeedRuntime(FeedConnectionId connectionId, FeedRuntimeId feedRuntimeId) {
        FeedRuntimeManager runtimeMgr = this.feedRuntimeManagers.get(connectionId);
        return runtimeMgr != null ? runtimeMgr.getFeedRuntime(feedRuntimeId) : null;
    }

    public String toString() {
        return "FeedManager [" + this.nodeId + "]";
    }

    public List<FeedRuntimeId> getRegisteredRuntimes() {
        ArrayList<FeedRuntimeId> runtimes = new ArrayList<FeedRuntimeId>();
        for (Map.Entry<FeedConnectionId, FeedRuntimeManager> entry : this.feedRuntimeManagers.entrySet()) {
            runtimes.addAll(entry.getValue().getFeedRuntimes());
        }
        return runtimes;
    }
}

