/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.feeds;

import java.nio.ByteBuffer;
import org.apache.asterix.common.feeds.FeedConnectionId;
import org.apache.asterix.common.feeds.FeedId;
import org.apache.asterix.common.feeds.api.IFeedOperatorOutputSideHandler;
import org.apache.asterix.common.feeds.api.ISubscribableRuntime;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;

public class CollectTransformFeedFrameWriter
implements IFeedOperatorOutputSideHandler {
    private final FeedConnectionId connectionId;
    private IFrameWriter downstreamWriter;
    private final FrameTupleAccessor inputFrameTupleAccessor;
    private final FrameTupleAppender tupleAppender;
    private final IFrame frame;
    private ArrayTupleBuilder tupleBuilder = new ArrayTupleBuilder(1);

    public CollectTransformFeedFrameWriter(IHyracksTaskContext ctx, IFrameWriter downstreamWriter, ISubscribableRuntime sourceRuntime, RecordDescriptor outputRecordDescriptor, FeedConnectionId connectionId) throws HyracksDataException {
        this.downstreamWriter = downstreamWriter;
        RecordDescriptor inputRecordDescriptor = sourceRuntime.getRecordDescriptor();
        this.inputFrameTupleAccessor = new FrameTupleAccessor(inputRecordDescriptor);
        this.tupleAppender = new FrameTupleAppender();
        this.frame = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        this.tupleAppender.reset(this.frame, true);
        this.connectionId = connectionId;
    }

    public void open() throws HyracksDataException {
        this.downstreamWriter.open();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.inputFrameTupleAccessor.reset(buffer);
        int nTuple = this.inputFrameTupleAccessor.getTupleCount();
        for (int t = 0; t < nTuple; ++t) {
            this.tupleBuilder.addField((IFrameTupleAccessor)this.inputFrameTupleAccessor, t, 0);
            this.appendTupleToFrame();
            this.tupleBuilder.reset();
        }
    }

    private void appendTupleToFrame() throws HyracksDataException {
        if (!this.tupleAppender.append(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray(), 0, this.tupleBuilder.getSize())) {
            FrameUtils.flushFrame((ByteBuffer)this.frame.getBuffer(), (IFrameWriter)this.downstreamWriter);
            this.tupleAppender.reset(this.frame, true);
            if (!this.tupleAppender.append(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray(), 0, this.tupleBuilder.getSize())) {
                throw new IllegalStateException();
            }
        }
    }

    public void fail() throws HyracksDataException {
        this.downstreamWriter.fail();
    }

    public void close() throws HyracksDataException {
        this.downstreamWriter.close();
    }

    public FeedId getFeedId() {
        return this.connectionId.getFeedId();
    }

    public IFeedOperatorOutputSideHandler.Type getType() {
        return IFeedOperatorOutputSideHandler.Type.COLLECT_TRANSFORM_FEED_OUTPUT_HANDLER;
    }

    public IFrameWriter getDownstreamWriter() {
        return this.downstreamWriter;
    }

    public FeedConnectionId getConnectionId() {
        return this.connectionId;
    }

    public void reset(IFrameWriter writer) {
        this.downstreamWriter = writer;
    }
}

