/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.feeds;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.feeds.DistributeFeedFrameWriter;
import org.apache.asterix.common.feeds.FeedId;
import org.apache.asterix.common.feeds.IngestionRuntime;
import org.apache.asterix.common.feeds.api.IAdapterRuntimeManager;
import org.apache.asterix.common.feeds.api.IFeedAdapter;
import org.apache.asterix.common.feeds.api.IIntakeProgressTracker;
import org.apache.asterix.metadata.feeds.AdapterExecutor;

public class AdapterRuntimeManager
implements IAdapterRuntimeManager {
    private static final Logger LOGGER = Logger.getLogger(AdapterRuntimeManager.class.getName());
    private final FeedId feedId;
    private final IFeedAdapter feedAdapter;
    private final IIntakeProgressTracker tracker;
    private final AdapterExecutor adapterExecutor;
    private final int partition;
    private final ExecutorService executorService;
    private IngestionRuntime ingestionRuntime;
    private IAdapterRuntimeManager.State state;

    public AdapterRuntimeManager(FeedId feedId, IFeedAdapter feedAdapter, IIntakeProgressTracker tracker, DistributeFeedFrameWriter writer, int partition) {
        this.feedId = feedId;
        this.feedAdapter = feedAdapter;
        this.tracker = tracker;
        this.partition = partition;
        this.adapterExecutor = new AdapterExecutor(partition, writer, feedAdapter, this);
        this.executorService = Executors.newSingleThreadExecutor();
        this.state = IAdapterRuntimeManager.State.INACTIVE_INGESTION;
    }

    public void start() throws Exception {
        this.state = IAdapterRuntimeManager.State.ACTIVE_INGESTION;
        this.executorService.execute(this.adapterExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.feedAdapter.stop();
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe("Unable to stop adapter " + this.feedAdapter + ", encountered exception " + exception);
            }
        }
        finally {
            this.state = IAdapterRuntimeManager.State.FINISHED_INGESTION;
            this.executorService.shutdown();
        }
    }

    public FeedId getFeedId() {
        return this.feedId;
    }

    public String toString() {
        return this.feedId + "[" + this.partition + "]";
    }

    public IFeedAdapter getFeedAdapter() {
        return this.feedAdapter;
    }

    public IIntakeProgressTracker getTracker() {
        return this.tracker;
    }

    public synchronized IAdapterRuntimeManager.State getState() {
        return this.state;
    }

    public synchronized void setState(IAdapterRuntimeManager.State state) {
        this.state = state;
    }

    public AdapterExecutor getAdapterExecutor() {
        return this.adapterExecutor;
    }

    public int getPartition() {
        return this.partition;
    }

    public IngestionRuntime getIngestionRuntime() {
        return this.ingestionRuntime;
    }

    public IIntakeProgressTracker getProgressTracker() {
        return this.tracker;
    }
}

