/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.feeds;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.feeds.DistributeFeedFrameWriter;
import org.apache.asterix.common.feeds.api.IAdapterRuntimeManager;
import org.apache.asterix.common.feeds.api.IFeedAdapter;
import org.apache.hyracks.api.comm.IFrameWriter;

public class AdapterExecutor
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(AdapterExecutor.class.getName());
    private final DistributeFeedFrameWriter writer;
    private final IFeedAdapter adapter;
    private final IAdapterRuntimeManager adapterManager;

    public AdapterExecutor(int partition, DistributeFeedFrameWriter writer, IFeedAdapter adapter, IAdapterRuntimeManager adapterManager) {
        this.writer = writer;
        this.adapter = adapter;
        this.adapterManager = adapterManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int partition = this.adapterManager.getPartition();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Starting ingestion for partition:" + partition);
        }
        boolean continueIngestion = true;
        boolean failedIngestion = false;
        while (continueIngestion) {
            try {
                this.adapter.start(partition, (IFrameWriter)this.writer);
                continueIngestion = false;
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.severe("Exception during feed ingestion " + e.getMessage());
                    e.printStackTrace();
                }
                failedIngestion = !(continueIngestion = this.adapter.handleException(e));
            }
        }
        this.adapterManager.setState(failedIngestion ? IAdapterRuntimeManager.State.FAILED_INGESTION : IAdapterRuntimeManager.State.FINISHED_INGESTION);
        IAdapterRuntimeManager iAdapterRuntimeManager = this.adapterManager;
        synchronized (iAdapterRuntimeManager) {
            this.adapterManager.notifyAll();
        }
    }
}

