/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.external;

import java.nio.ByteBuffer;
import org.apache.asterix.metadata.external.ExternalFileIndexAccessor;
import org.apache.asterix.metadata.external.FilesIndexDescription;
import org.apache.asterix.metadata.external.IControlledAdapter;
import org.apache.asterix.metadata.external.IControlledAdapterFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.INullWriterFactory;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.storage.am.common.api.IIndexLifecycleManagerProvider;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.dataflow.AbstractTreeIndexOperatorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.btree.dataflow.ExternalBTreeDataflowHelper;
import org.apache.hyracks.storage.am.lsm.btree.dataflow.ExternalBTreeDataflowHelperFactory;
import org.apache.hyracks.storage.common.IStorageManagerInterface;

public class ExternalLoopkupOperatorDiscriptor
extends AbstractTreeIndexOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final IControlledAdapterFactory adapterFactory;
    private final INullWriterFactory iNullWriterFactory;

    public ExternalLoopkupOperatorDiscriptor(IOperatorDescriptorRegistry spec, IControlledAdapterFactory adapterFactory, RecordDescriptor outRecDesc, ExternalBTreeDataflowHelperFactory externalFilesIndexDataFlowHelperFactory, boolean propagateInput, IIndexLifecycleManagerProvider lcManagerProvider, IStorageManagerInterface storageManager, IFileSplitProvider fileSplitProvider, int datasetId, double bloomFilterFalsePositiveRate, ISearchOperationCallbackFactory searchOpCallbackFactory, boolean retainNull, INullWriterFactory iNullWriterFactory) {
        super(spec, 1, 1, outRecDesc, storageManager, lcManagerProvider, fileSplitProvider, FilesIndexDescription.EXTERNAL_FILE_INDEX_TYPE_TRAITS, FilesIndexDescription.FILES_INDEX_COMP_FACTORIES, FilesIndexDescription.BLOOM_FILTER_FIELDS, (IIndexDataflowHelperFactory)externalFilesIndexDataFlowHelperFactory, null, propagateInput, retainNull, iNullWriterFactory, null, searchOpCallbackFactory, null);
        this.adapterFactory = adapterFactory;
        this.iNullWriterFactory = iNullWriterFactory;
    }

    public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, final IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        final ExternalFileIndexAccessor fileIndexAccessor = new ExternalFileIndexAccessor((ExternalBTreeDataflowHelper)this.dataflowHelperFactory.createIndexDataflowHelper((IIndexOperatorDescriptor)this, ctx, partition), this);
        return new AbstractUnaryInputUnaryOutputOperatorNodePushable(){
            private final IControlledAdapter adapter;
            {
                this.adapter = ExternalLoopkupOperatorDiscriptor.this.adapterFactory.createAdapter(ctx, fileIndexAccessor, recordDescProvider.getInputRecordDescriptor(ExternalLoopkupOperatorDiscriptor.this.getActivityId(), 0));
            }

            public void open() throws HyracksDataException {
                fileIndexAccessor.openIndex();
                try {
                    this.adapter.initialize(ctx, ExternalLoopkupOperatorDiscriptor.this.iNullWriterFactory);
                }
                catch (Exception e) {
                    fileIndexAccessor.closeIndex();
                    throw new HyracksDataException("error during opening a controlled adapter", (Throwable)e);
                }
                this.writer.open();
            }

            public void close() throws HyracksDataException {
                try {
                    this.adapter.close(this.writer);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new HyracksDataException("controlled adapter failed to close", (Throwable)e);
                }
                finally {
                    fileIndexAccessor.closeIndex();
                    this.writer.close();
                }
            }

            public void fail() throws HyracksDataException {
                try {
                    this.adapter.fail();
                    this.writer.fail();
                }
                catch (Exception e) {
                    throw new HyracksDataException("controlled adapter failed to clean up", (Throwable)e);
                }
                finally {
                    fileIndexAccessor.closeIndex();
                }
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                try {
                    this.adapter.nextFrame(buffer, this.writer);
                }
                catch (Exception e) {
                    throw new HyracksDataException("controlled adapter failed to process a frame", (Throwable)e);
                }
            }
        };
    }
}

