/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.external;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.Serializable;
import java.util.Date;
import org.apache.asterix.formats.nontagged.AqlSerializerDeserializerProvider;
import org.apache.asterix.metadata.entities.ExternalFile;
import org.apache.asterix.metadata.external.ExternalLoopkupOperatorDiscriptor;
import org.apache.asterix.metadata.external.FilesIndexDescription;
import org.apache.asterix.om.base.ADateTime;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.btree.util.BTreeUtils;
import org.apache.hyracks.storage.am.common.api.IIndexCursor;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallback;
import org.apache.hyracks.storage.am.common.api.ISearchPredicate;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.lsm.btree.dataflow.ExternalBTreeDataflowHelper;
import org.apache.hyracks.storage.am.lsm.btree.impls.ExternalBTree;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessorInternal;

public class ExternalFileIndexAccessor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ExternalBTreeDataflowHelper indexDataflowHelper;
    private ExternalLoopkupOperatorDiscriptor opDesc;
    private IHyracksTaskContext ctx;
    private ExternalBTree index;
    private ArrayTupleBuilder searchKeyTupleBuilder;
    private ArrayTupleReference searchKey;
    private MultiComparator searchCmp;
    private AMutableInt32 currentFileNumber = new AMutableInt32(-1);
    private ISerializerDeserializer intSerde = AqlSerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
    private RangePredicate searchPredicate;
    private ILSMIndexAccessorInternal fileIndexAccessor;
    private IIndexCursor fileIndexSearchCursor;

    public ExternalFileIndexAccessor(ExternalBTreeDataflowHelper indexDataflowHelper, ExternalLoopkupOperatorDiscriptor opDesc) {
        this.indexDataflowHelper = indexDataflowHelper;
        this.opDesc = opDesc;
    }

    public void openIndex() throws HyracksDataException {
        this.indexDataflowHelper.open();
        this.index = (ExternalBTree)this.indexDataflowHelper.getIndexInstance();
        try {
            this.searchKey = new ArrayTupleReference();
            this.searchKeyTupleBuilder = new ArrayTupleBuilder(1);
            this.searchKeyTupleBuilder.reset();
            this.searchKeyTupleBuilder.addField(this.intSerde, (Object)this.currentFileNumber);
            this.searchKey.reset(this.searchKeyTupleBuilder.getFieldEndOffsets(), this.searchKeyTupleBuilder.getByteArray());
            this.searchCmp = BTreeUtils.getSearchMultiComparator((IBinaryComparatorFactory[])this.index.getComparatorFactories(), (ITupleReference)this.searchKey);
            this.searchPredicate = new RangePredicate((ITupleReference)this.searchKey, (ITupleReference)this.searchKey, true, true, this.searchCmp, this.searchCmp);
            ISearchOperationCallback searchCallback = this.opDesc.getSearchOpCallbackFactory().createSearchOperationCallback(this.indexDataflowHelper.getResourceID(), this.ctx);
            this.fileIndexAccessor = this.index.createAccessor(searchCallback, this.indexDataflowHelper.getVersion());
            this.fileIndexSearchCursor = this.fileIndexAccessor.createSearchCursor(false);
        }
        catch (Exception e) {
            this.indexDataflowHelper.close();
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void searchForFile(int fileNumber, ExternalFile file) throws Exception {
        this.currentFileNumber.setValue(fileNumber);
        this.searchKeyTupleBuilder.reset();
        this.searchKeyTupleBuilder.addField(this.intSerde, (Object)this.currentFileNumber);
        this.searchKey.reset(this.searchKeyTupleBuilder.getFieldEndOffsets(), this.searchKeyTupleBuilder.getByteArray());
        this.fileIndexSearchCursor.reset();
        this.fileIndexAccessor.search(this.fileIndexSearchCursor, (ISearchPredicate)this.searchPredicate);
        if (!this.fileIndexSearchCursor.hasNext()) {
            throw new HyracksDataException("Was not able to find a file in the files index");
        }
        this.fileIndexSearchCursor.next();
        ITupleReference tuple = this.fileIndexSearchCursor.getTuple();
        byte[] serRecord = tuple.getFieldData(1);
        int recordStartOffset = tuple.getFieldStart(1);
        int recordLength = tuple.getFieldLength(1);
        ByteArrayInputStream stream = new ByteArrayInputStream(serRecord, recordStartOffset, recordLength);
        DataInputStream in = new DataInputStream(stream);
        ARecord externalFileRecord = (ARecord)FilesIndexDescription.EXTERNAL_FILE_RECORD_SERDE.deserialize((DataInput)in);
        this.setExternalFileFromARecord(externalFileRecord, file);
    }

    private void setExternalFileFromARecord(ARecord externalFileRecord, ExternalFile file) {
        file.setFileName(((AString)externalFileRecord.getValueByPos(0)).getStringValue());
        file.setSize(((AInt64)externalFileRecord.getValueByPos(1)).getLongValue());
        file.setLastModefiedTime(new Date(((ADateTime)externalFileRecord.getValueByPos(2)).getChrononTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeIndex() throws HyracksDataException {
        try {
            this.fileIndexSearchCursor.close();
        }
        finally {
            this.indexDataflowHelper.close();
        }
    }
}

