/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.formats.nontagged.AqlSerializerDeserializerProvider;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.MetadataNode;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.AsterixBuiltinTypeMap;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ACollectionCursor;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class IndexTupleTranslator
extends AbstractTupleTranslator<Index> {
    public static final int INDEX_DATAVERSENAME_TUPLE_FIELD_INDEX = 0;
    public static final int INDEX_DATASETNAME_TUPLE_FIELD_INDEX = 1;
    public static final int INDEX_INDEXNAME_TUPLE_FIELD_INDEX = 2;
    public static final int INDEX_PAYLOAD_TUPLE_FIELD_INDEX = 3;
    public static final String GRAM_LENGTH_FIELD_NAME = "GramLength";
    public static final String INDEX_SEARCHKEY_TYPE_FIELD_NAME = "SearchKeyType";
    public static final String INDEX_ISENFORCED_FIELD_NAME = "IsEnforced";
    private OrderedListBuilder listBuilder = new OrderedListBuilder();
    private OrderedListBuilder primaryKeyListBuilder = new OrderedListBuilder();
    private AOrderedListType stringList = new AOrderedListType((IAType)BuiltinType.ASTRING, null);
    private ArrayBackedValueStorage nameValue = new ArrayBackedValueStorage();
    private ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
    private List<List<String>> searchKey;
    private List<IAType> searchKeyType;
    protected ISerializerDeserializer<AInt32> intSerde = AqlSerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
    private ISerializerDeserializer<ARecord> recordSerde = AqlSerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)MetadataRecordTypes.INDEX_RECORDTYPE);
    private final MetadataNode metadataNode;
    private final JobId jobId;

    public IndexTupleTranslator(JobId jobId, MetadataNode metadataNode, boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.INDEX_DATASET.getFieldCount());
        this.jobId = jobId;
        this.metadataNode = metadataNode;
    }

    @Override
    public Index getMetadataEntityFromTuple(ITupleReference frameTuple) throws IOException, MetadataException {
        byte[] serRecord = frameTuple.getFieldData(3);
        int recordStartOffset = frameTuple.getFieldStart(3);
        int recordLength = frameTuple.getFieldLength(3);
        ByteArrayInputStream stream = new ByteArrayInputStream(serRecord, recordStartOffset, recordLength);
        DataInputStream in = new DataInputStream(stream);
        ARecord rec = (ARecord)this.recordSerde.deserialize((DataInput)in);
        String dvName = ((AString)rec.getValueByPos(0)).getStringValue();
        String dsName = ((AString)rec.getValueByPos(1)).getStringValue();
        String indexName = ((AString)rec.getValueByPos(2)).getStringValue();
        DatasetConfig.IndexType indexStructure = DatasetConfig.IndexType.valueOf((String)((AString)rec.getValueByPos(3)).getStringValue());
        IACursor fieldNameCursor = ((AOrderedList)rec.getValueByPos(4)).getCursor();
        ArrayList<List<String>> searchKey = new ArrayList<List<String>>();
        while (fieldNameCursor.next()) {
            AOrderedList fieldNameList = (AOrderedList)fieldNameCursor.get();
            IACursor nestedFieldNameCursor = fieldNameList.getCursor();
            ArrayList<String> nestedFieldName = new ArrayList<String>();
            while (nestedFieldNameCursor.next()) {
                nestedFieldName.add(((AString)nestedFieldNameCursor.get()).getStringValue());
            }
            searchKey.add(nestedFieldName);
        }
        int indexKeyTypeFieldPos = rec.getType().findFieldPosition(INDEX_SEARCHKEY_TYPE_FIELD_NAME);
        ACollectionCursor fieldTypeCursor = new ACollectionCursor();
        if (indexKeyTypeFieldPos > 0) {
            fieldTypeCursor = ((AOrderedList)rec.getValueByPos(indexKeyTypeFieldPos)).getCursor();
        }
        ArrayList<IAType> searchKeyType = new ArrayList<IAType>(searchKey.size());
        while (fieldTypeCursor.next()) {
            String typeName = ((AString)fieldTypeCursor.get()).getStringValue();
            IAType fieldType = AsterixBuiltinTypeMap.getTypeFromTypeName(this.metadataNode, this.jobId, dvName, typeName, false);
            searchKeyType.add(fieldType);
        }
        if (searchKeyType.isEmpty()) {
            String datatypeName = this.metadataNode.getDataset(this.jobId, dvName, dsName).getItemTypeName();
            ARecordType recordDt = (ARecordType)this.metadataNode.getDatatype(this.jobId, dvName, datatypeName).getDatatype();
            for (int i = 0; i < searchKey.size(); ++i) {
                IAType fieldType = recordDt.getSubFieldType((List)searchKey.get(i));
                searchKeyType.add(fieldType);
            }
        }
        int isEnforcedFieldPos = rec.getType().findFieldPosition(INDEX_ISENFORCED_FIELD_NAME);
        Boolean isEnforcingKeys = false;
        if (isEnforcedFieldPos > 0) {
            isEnforcingKeys = ((ABoolean)rec.getValueByPos(isEnforcedFieldPos)).getBoolean();
        }
        Boolean isPrimaryIndex = ((ABoolean)rec.getValueByPos(5)).getBoolean();
        int pendingOp = ((AInt32)rec.getValueByPos(7)).getIntegerValue();
        int gramLength = -1;
        int gramLenPos = rec.getType().findFieldPosition(GRAM_LENGTH_FIELD_NAME);
        if (gramLenPos >= 0) {
            gramLength = ((AInt32)rec.getValueByPos(gramLenPos)).getIntegerValue();
        }
        return new Index(dvName, dsName, indexName, indexStructure, searchKey, searchKeyType, gramLength, isEnforcingKeys, isPrimaryIndex, pendingOp);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Index instance) throws IOException, MetadataException {
        this.tupleBuilder.reset();
        this.aString.setValue(instance.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(instance.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(instance.getIndexName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.INDEX_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(instance.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(instance.getDatasetName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(instance.getIndexName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(instance.getIndexType().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(3, (IValueReference)this.fieldValue);
        this.primaryKeyListBuilder.reset((AbstractCollectionType)((AOrderedListType)MetadataRecordTypes.INDEX_RECORDTYPE.getFieldTypes()[4]));
        this.searchKey = instance.getKeyFieldNames();
        for (List<String> field : this.searchKey) {
            this.listBuilder.reset((AbstractCollectionType)this.stringList);
            for (String subField : field) {
                this.itemValue.reset();
                this.aString.setValue(subField);
                this.stringSerde.serialize((Object)this.aString, this.itemValue.getDataOutput());
                this.listBuilder.addItem((IValueReference)this.itemValue);
            }
            this.itemValue.reset();
            this.listBuilder.write(this.itemValue.getDataOutput(), true);
            this.primaryKeyListBuilder.addItem((IValueReference)this.itemValue);
        }
        this.fieldValue.reset();
        this.primaryKeyListBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(4, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        if (instance.isPrimaryIndex()) {
            this.booleanSerde.serialize((Object)ABoolean.TRUE, this.fieldValue.getDataOutput());
        } else {
            this.booleanSerde.serialize((Object)ABoolean.FALSE, this.fieldValue.getDataOutput());
        }
        this.recordBuilder.addField(5, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(Calendar.getInstance().getTime().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(6, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.intSerde.serialize((Object)new AInt32(instance.getPendingOp()), this.fieldValue.getDataOutput());
        this.recordBuilder.addField(7, (IValueReference)this.fieldValue);
        if (instance.getGramLength() > 0) {
            this.fieldValue.reset();
            this.nameValue.reset();
            this.aString.setValue(GRAM_LENGTH_FIELD_NAME);
            this.stringSerde.serialize((Object)this.aString, this.nameValue.getDataOutput());
            this.intSerde.serialize((Object)new AInt32(instance.getGramLength()), this.fieldValue.getDataOutput());
            try {
                this.recordBuilder.addField((IValueReference)this.nameValue, (IValueReference)this.fieldValue);
            }
            catch (AsterixException e) {
                throw new MetadataException(e);
            }
        }
        if (instance.isEnforcingKeyFileds()) {
            OrderedListBuilder typeListBuilder = new OrderedListBuilder();
            typeListBuilder.reset((AbstractCollectionType)new AOrderedListType((IAType)BuiltinType.ANY, null));
            ArrayBackedValueStorage nameValue = new ArrayBackedValueStorage();
            nameValue.reset();
            this.aString.setValue(INDEX_SEARCHKEY_TYPE_FIELD_NAME);
            this.stringSerde.serialize((Object)this.aString, nameValue.getDataOutput());
            this.searchKeyType = instance.getKeyFieldTypes();
            for (IAType type : this.searchKeyType) {
                this.itemValue.reset();
                this.aString.setValue(type.getTypeName());
                this.stringSerde.serialize((Object)this.aString, this.itemValue.getDataOutput());
                typeListBuilder.addItem((IValueReference)this.itemValue);
            }
            this.fieldValue.reset();
            typeListBuilder.write(this.fieldValue.getDataOutput(), true);
            try {
                this.recordBuilder.addField((IValueReference)nameValue, (IValueReference)this.fieldValue);
            }
            catch (AsterixException e) {
                throw new MetadataException(e);
            }
            this.fieldValue.reset();
            nameValue.reset();
            this.aString.setValue(INDEX_ISENFORCED_FIELD_NAME);
            this.stringSerde.serialize((Object)this.aString, nameValue.getDataOutput());
            this.booleanSerde.serialize((Object)ABoolean.TRUE, this.fieldValue.getDataOutput());
            try {
                this.recordBuilder.addField((IValueReference)nameValue, (IValueReference)this.fieldValue);
            }
            catch (AsterixException e) {
                throw new MetadataException(e);
            }
        }
        try {
            this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        }
        catch (AsterixException e) {
            throw new MetadataException(e);
        }
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

