/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Calendar;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.formats.nontagged.AqlSerializerDeserializerProvider;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.metadata.feeds.AdapterIdentifier;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class DatasourceAdapterTupleTranslator
extends AbstractTupleTranslator<DatasourceAdapter> {
    public static final int ADAPTER_DATAVERSENAME_TUPLE_FIELD_INDEX = 0;
    public static final int ADAPTER_NAME_TUPLE_FIELD_INDEX = 1;
    public static final int ADAPTER_PAYLOAD_TUPLE_FIELD_INDEX = 2;
    private ISerializerDeserializer<ARecord> recordSerDes = AqlSerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)MetadataRecordTypes.DATASOURCE_ADAPTER_RECORDTYPE);

    public DatasourceAdapterTupleTranslator(boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET.getFieldCount());
    }

    @Override
    public DatasourceAdapter getMetadataEntityFromTuple(ITupleReference tuple) throws MetadataException, IOException {
        byte[] serRecord = tuple.getFieldData(2);
        int recordStartOffset = tuple.getFieldStart(2);
        int recordLength = tuple.getFieldLength(2);
        ByteArrayInputStream stream = new ByteArrayInputStream(serRecord, recordStartOffset, recordLength);
        DataInputStream in = new DataInputStream(stream);
        ARecord adapterRecord = (ARecord)this.recordSerDes.deserialize((DataInput)in);
        return this.createAdapterFromARecord(adapterRecord);
    }

    private DatasourceAdapter createAdapterFromARecord(ARecord adapterRecord) {
        String dataverseName = ((AString)adapterRecord.getValueByPos(0)).getStringValue();
        String adapterName = ((AString)adapterRecord.getValueByPos(1)).getStringValue();
        String classname = ((AString)adapterRecord.getValueByPos(2)).getStringValue();
        DatasourceAdapter.AdapterType adapterType = DatasourceAdapter.AdapterType.valueOf(((AString)adapterRecord.getValueByPos(3)).getStringValue());
        return new DatasourceAdapter(new AdapterIdentifier(dataverseName, adapterName), classname, adapterType);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(DatasourceAdapter adapter) throws IOException, MetadataException {
        this.tupleBuilder.reset();
        this.aString.setValue(adapter.getAdapterIdentifier().getNamespace());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(adapter.getAdapterIdentifier().getName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.DATASOURCE_ADAPTER_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(adapter.getAdapterIdentifier().getNamespace());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(adapter.getAdapterIdentifier().getName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(adapter.getClassname());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(adapter.getType().name());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(3, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(Calendar.getInstance().getTime().toString());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(4, (IValueReference)this.fieldValue);
        try {
            this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        }
        catch (AsterixException e) {
            throw new MetadataException(e);
        }
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

