/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.util.Map;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.metadata.api.IMetadataEntity;
import org.apache.asterix.metadata.entities.Feed;

public class PrimaryFeed
extends Feed
implements IMetadataEntity {
    private static final long serialVersionUID = 1L;
    private final String adaptorName;
    private final Map<String, String> adaptorConfiguration;

    public PrimaryFeed(String dataverseName, String datasetName, String adaptorName, Map<String, String> adaptorConfiguration, FunctionSignature appliedFunction) {
        super(dataverseName, datasetName, appliedFunction, Feed.FeedType.PRIMARY);
        this.adaptorName = adaptorName;
        this.adaptorConfiguration = adaptorConfiguration;
    }

    public String getAdaptorName() {
        return this.adaptorName;
    }

    public Map<String, String> getAdaptorConfiguration() {
        return this.adaptorConfiguration;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other) || !(other instanceof PrimaryFeed)) {
            return false;
        }
        PrimaryFeed otherFeed = (PrimaryFeed)other;
        if (!otherFeed.getAdaptorName().equals(this.adaptorName)) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.adaptorConfiguration.entrySet()) {
            if (entry.getValue().equals(otherFeed.getAdaptorConfiguration().get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "PrimaryFeed (" + this.adaptorName + ")";
    }
}

