/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.formats.nontagged.AqlSerializerDeserializerProvider;
import org.apache.asterix.metadata.IDatasetDetails;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class InternalDatasetDetails
implements IDatasetDetails {
    private static final long serialVersionUID = 1L;
    protected final FileStructure fileStructure;
    protected final PartitioningStrategy partitioningStrategy;
    protected final List<List<String>> partitioningKeys;
    protected final List<List<String>> primaryKeys;
    protected final List<IAType> primaryKeyTypes;
    protected final boolean autogenerated;
    protected final boolean temp;
    protected long lastAccessTime;
    protected final List<String> filterField;
    public static final String FILTER_FIELD_NAME = "FilterField";

    public InternalDatasetDetails(FileStructure fileStructure, PartitioningStrategy partitioningStrategy, List<List<String>> partitioningKey, List<List<String>> primaryKey, List<IAType> primaryKeyType, boolean autogenerated, List<String> filterField, boolean temp) {
        this.fileStructure = fileStructure;
        this.partitioningStrategy = partitioningStrategy;
        this.partitioningKeys = partitioningKey;
        this.primaryKeys = primaryKey;
        this.primaryKeyTypes = primaryKeyType;
        this.autogenerated = autogenerated;
        this.filterField = filterField;
        this.temp = temp;
        this.lastAccessTime = System.currentTimeMillis();
    }

    public List<List<String>> getPartitioningKey() {
        return this.partitioningKeys;
    }

    public boolean isAutogenerated() {
        return this.autogenerated;
    }

    public List<List<String>> getPrimaryKey() {
        return this.primaryKeys;
    }

    public List<IAType> getPrimaryKeyType() {
        return this.primaryKeyTypes;
    }

    public FileStructure getFileStructure() {
        return this.fileStructure;
    }

    public PartitioningStrategy getPartitioningStrategy() {
        return this.partitioningStrategy;
    }

    public List<String> getFilterField() {
        return this.filterField;
    }

    @Override
    public DatasetConfig.DatasetType getDatasetType() {
        this.lastAccessTime = System.currentTimeMillis();
        return DatasetConfig.DatasetType.INTERNAL;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public boolean isTemp() {
        return this.temp;
    }

    @Override
    public void writeDatasetDetailsRecordType(DataOutput out) throws HyracksDataException {
        RecordBuilder internalRecordBuilder = new RecordBuilder();
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        OrderedListBuilder primaryKeyListBuilder = new OrderedListBuilder();
        AOrderedListType stringList = new AOrderedListType((IAType)BuiltinType.ASTRING, null);
        AOrderedListType heterogeneousList = new AOrderedListType((IAType)BuiltinType.ANY, null);
        internalRecordBuilder.reset(MetadataRecordTypes.INTERNAL_DETAILS_RECORDTYPE);
        AMutableString aString = new AMutableString("");
        ISerializerDeserializer booleanSerde = AqlSerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
        ISerializerDeserializer stringSerde = AqlSerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
        fieldValue.reset();
        aString.setValue(this.getFileStructure().toString());
        stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        internalRecordBuilder.addField(0, (IValueReference)fieldValue);
        fieldValue.reset();
        aString.setValue(this.getPartitioningStrategy().toString());
        stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        internalRecordBuilder.addField(1, (IValueReference)fieldValue);
        primaryKeyListBuilder.reset((AbstractCollectionType)((AOrderedListType)MetadataRecordTypes.INTERNAL_DETAILS_RECORDTYPE.getFieldTypes()[2]));
        for (List<String> field : this.partitioningKeys) {
            listBuilder.reset((AbstractCollectionType)stringList);
            for (String subField : field) {
                itemValue.reset();
                aString.setValue(subField);
                stringSerde.serialize((Object)aString, itemValue.getDataOutput());
                listBuilder.addItem((IValueReference)itemValue);
            }
            itemValue.reset();
            listBuilder.write(itemValue.getDataOutput(), true);
            primaryKeyListBuilder.addItem((IValueReference)itemValue);
        }
        fieldValue.reset();
        primaryKeyListBuilder.write(fieldValue.getDataOutput(), true);
        internalRecordBuilder.addField(2, (IValueReference)fieldValue);
        primaryKeyListBuilder.reset((AbstractCollectionType)((AOrderedListType)MetadataRecordTypes.INTERNAL_DETAILS_RECORDTYPE.getFieldTypes()[3]));
        for (List<String> field : this.primaryKeys) {
            listBuilder.reset((AbstractCollectionType)stringList);
            for (String subField : field) {
                itemValue.reset();
                aString.setValue(subField);
                stringSerde.serialize((Object)aString, itemValue.getDataOutput());
                listBuilder.addItem((IValueReference)itemValue);
            }
            itemValue.reset();
            listBuilder.write(itemValue.getDataOutput(), true);
            primaryKeyListBuilder.addItem((IValueReference)itemValue);
        }
        fieldValue.reset();
        primaryKeyListBuilder.write(fieldValue.getDataOutput(), true);
        internalRecordBuilder.addField(3, (IValueReference)fieldValue);
        fieldValue.reset();
        ABoolean b = this.isAutogenerated() ? ABoolean.TRUE : ABoolean.FALSE;
        booleanSerde.serialize((Object)b, fieldValue.getDataOutput());
        internalRecordBuilder.addField(4, (IValueReference)fieldValue);
        List<String> filterField = this.getFilterField();
        if (filterField != null) {
            listBuilder.reset((AbstractCollectionType)heterogeneousList);
            ArrayBackedValueStorage nameValue = new ArrayBackedValueStorage();
            nameValue.reset();
            aString.setValue(FILTER_FIELD_NAME);
            stringSerde.serialize((Object)aString, nameValue.getDataOutput());
            for (String field : filterField) {
                itemValue.reset();
                aString.setValue(field);
                stringSerde.serialize((Object)aString, itemValue.getDataOutput());
                listBuilder.addItem((IValueReference)itemValue);
            }
            fieldValue.reset();
            listBuilder.write(fieldValue.getDataOutput(), true);
            try {
                internalRecordBuilder.addField((IValueReference)nameValue, (IValueReference)fieldValue);
            }
            catch (AsterixException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        try {
            internalRecordBuilder.write(out, true);
        }
        catch (IOException | AsterixException e) {
            throw new HyracksDataException(e);
        }
    }

    protected void writePropertyTypeRecord(String name, String value, DataOutput out, ARecordType recordType) throws HyracksDataException {
        RecordBuilder propertyRecordBuilder = new RecordBuilder();
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        propertyRecordBuilder.reset(recordType);
        AMutableString aString = new AMutableString("");
        ISerializerDeserializer stringSerde = AqlSerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
        fieldValue.reset();
        aString.setValue(name);
        stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(0, (IValueReference)fieldValue);
        fieldValue.reset();
        aString.setValue(value);
        stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(1, (IValueReference)fieldValue);
        try {
            propertyRecordBuilder.write(out, true);
        }
        catch (IOException | AsterixException e) {
            throw new HyracksDataException(e);
        }
    }

    public static enum PartitioningStrategy {
        HASH;

    }

    public static enum FileStructure {
        BTREE;

    }
}

