/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.io.IOException;
import java.util.List;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.api.IMetadataEntity;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.NonTaggedFormatUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class Index
implements IMetadataEntity,
Comparable<Index> {
    private static final long serialVersionUID = 1L;
    private final String dataverseName;
    private final String datasetName;
    private final String indexName;
    private final DatasetConfig.IndexType indexType;
    private final List<List<String>> keyFieldNames;
    private final List<IAType> keyFieldTypes;
    private final boolean enforceKeyFields;
    private final boolean isPrimaryIndex;
    private final int gramLength;
    private int pendingOp;

    public Index(String dataverseName, String datasetName, String indexName, DatasetConfig.IndexType indexType, List<List<String>> keyFieldNames, List<IAType> keyFieldTypes, int gramLength, boolean enforceKeyFields, boolean isPrimaryIndex, int pendingOp) {
        this.dataverseName = dataverseName;
        this.datasetName = datasetName;
        this.indexName = indexName;
        this.indexType = indexType;
        this.keyFieldNames = keyFieldNames;
        this.keyFieldTypes = keyFieldTypes;
        this.gramLength = gramLength;
        this.enforceKeyFields = enforceKeyFields;
        this.isPrimaryIndex = isPrimaryIndex;
        this.pendingOp = pendingOp;
    }

    public Index(String dataverseName, String datasetName, String indexName, DatasetConfig.IndexType indexType, List<List<String>> keyFieldNames, List<IAType> keyFieldTypes, boolean enforceKeyFields, boolean isPrimaryIndex, int pendingOp) {
        this.dataverseName = dataverseName;
        this.datasetName = datasetName;
        this.indexName = indexName;
        this.indexType = indexType;
        this.keyFieldNames = keyFieldNames;
        this.keyFieldTypes = keyFieldTypes;
        this.gramLength = -1;
        this.enforceKeyFields = enforceKeyFields;
        this.isPrimaryIndex = isPrimaryIndex;
        this.pendingOp = pendingOp;
    }

    public String getDataverseName() {
        return this.dataverseName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public List<List<String>> getKeyFieldNames() {
        return this.keyFieldNames;
    }

    public List<IAType> getKeyFieldTypes() {
        return this.keyFieldTypes;
    }

    public int getGramLength() {
        return this.gramLength;
    }

    public DatasetConfig.IndexType getIndexType() {
        return this.indexType;
    }

    public boolean isPrimaryIndex() {
        return this.isPrimaryIndex;
    }

    public boolean isEnforcingKeyFileds() {
        return this.enforceKeyFields;
    }

    public int getPendingOp() {
        return this.pendingOp;
    }

    public void setPendingOp(int pendingOp) {
        this.pendingOp = pendingOp;
    }

    public boolean isSecondaryIndex() {
        return !this.isPrimaryIndex();
    }

    public static Pair<IAType, Boolean> getNonNullableType(IAType keyType) throws AlgebricksException {
        boolean nullable = false;
        if (NonTaggedFormatUtil.isOptional((IAType)keyType)) {
            keyType = ((AUnionType)keyType).getNullableType();
            nullable = true;
        }
        return new Pair((Object)keyType, (Object)nullable);
    }

    public static Pair<IAType, Boolean> getNonNullableOpenFieldType(IAType fieldType, List<String> fieldName, ARecordType recType) throws AlgebricksException {
        Pair<IAType, Boolean> keyPairType = null;
        try {
            ARecordType subType = recType;
            for (int i = 0; i < fieldName.size(); ++i) {
                if ((subType = subType.getFieldType(fieldName.get(i))) != null) continue;
                keyPairType = Index.getNonNullableType(fieldType);
                break;
            }
            if (subType != null) {
                keyPairType = Index.getNonNullableKeyFieldType(fieldName, recType);
            }
        }
        catch (IOException e) {
            throw new AlgebricksException((Throwable)e);
        }
        return keyPairType;
    }

    public static Pair<IAType, Boolean> getNonNullableKeyFieldType(List<String> expr, ARecordType recType) throws AlgebricksException {
        IAType keyType = Index.keyFieldType(expr, recType);
        return Index.getNonNullableType(keyType);
    }

    private static IAType keyFieldType(List<String> expr, ARecordType recType) throws AlgebricksException {
        ARecordType fieldType = recType;
        try {
            fieldType = recType.getSubFieldType(expr);
        }
        catch (IOException e) {
            throw new AlgebricksException("Could not find field " + expr + " in the schema.", (Throwable)e);
        }
        return fieldType;
    }

    public int hashCode() {
        return this.indexName.hashCode() ^ this.datasetName.hashCode() ^ this.dataverseName.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Index)) {
            return false;
        }
        Index otherIndex = (Index)other;
        if (!this.indexName.equals(otherIndex.getIndexName())) {
            return false;
        }
        if (!this.datasetName.equals(otherIndex.getDatasetName())) {
            return false;
        }
        return this.dataverseName.equals(otherIndex.getDataverseName());
    }

    @Override
    public Object addToCache(MetadataCache cache) {
        return cache.addIndexIfNotExists(this);
    }

    @Override
    public Object dropFromCache(MetadataCache cache) {
        return cache.dropIndex(this);
    }

    @Override
    public int compareTo(Index otherIndex) {
        if (this.isPrimaryIndex && !otherIndex.isPrimaryIndex) {
            return -1;
        }
        if (!this.isPrimaryIndex && otherIndex.isPrimaryIndex) {
            return 1;
        }
        if (this.indexType == DatasetConfig.IndexType.BTREE && otherIndex.indexType != DatasetConfig.IndexType.BTREE) {
            return -1;
        }
        if (this.indexType != DatasetConfig.IndexType.BTREE && otherIndex.indexType == DatasetConfig.IndexType.BTREE) {
            return 1;
        }
        if (this.indexType == DatasetConfig.IndexType.RTREE && otherIndex.indexType != DatasetConfig.IndexType.RTREE) {
            return -1;
        }
        if (this.indexType != DatasetConfig.IndexType.RTREE && otherIndex.indexType == DatasetConfig.IndexType.RTREE) {
            return 1;
        }
        int result = this.indexName.compareTo(otherIndex.getIndexName());
        if (result != 0) {
            return result;
        }
        result = this.datasetName.compareTo(otherIndex.getDatasetName());
        if (result != 0) {
            return result;
        }
        return this.dataverseName.compareTo(otherIndex.getDataverseName());
    }
}

