/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.util.List;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.api.IMetadataEntity;

public class Function
implements IMetadataEntity {
    public static final String LANGUAGE_AQL = "AQL";
    public static final String LANGUAGE_JAVA = "JAVA";
    public static final String RETURNTYPE_VOID = "VOID";
    public static final String NOT_APPLICABLE = "N/A";
    private final String dataverse;
    private final String name;
    private final int arity;
    private final List<String> params;
    private final String body;
    private final String returnType;
    private final String language;
    private final String kind;

    public Function(String dataverseName, String functionName, int arity, List<String> params, String returnType, String functionBody, String language, String functionKind) {
        this.dataverse = dataverseName;
        this.name = functionName;
        this.params = params;
        this.body = functionBody;
        this.returnType = returnType == null ? RETURNTYPE_VOID : returnType;
        this.language = language;
        this.kind = functionKind;
        this.arity = arity;
    }

    public String getDataverseName() {
        return this.dataverse;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getParams() {
        return this.params;
    }

    public String getFunctionBody() {
        return this.body;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getLanguage() {
        return this.language;
    }

    public int getArity() {
        return this.arity;
    }

    public String getKind() {
        return this.kind;
    }

    @Override
    public Object addToCache(MetadataCache cache) {
        return cache.addFunctionIfNotExists(this);
    }

    @Override
    public Object dropFromCache(MetadataCache cache) {
        return cache.dropFunction(this);
    }
}

