/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import org.apache.asterix.common.feeds.FeedId;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.api.IMetadataEntity;

public class Feed
implements IMetadataEntity {
    private static final long serialVersionUID = 1L;
    protected final FeedId feedId;
    protected final FunctionSignature appliedFunction;
    protected final FeedType feedType;
    protected final String displayName;

    public Feed(String dataverseName, String datasetName, FunctionSignature appliedFunction, FeedType feedType) {
        this.feedId = new FeedId(dataverseName, datasetName);
        this.appliedFunction = appliedFunction;
        this.feedType = feedType;
        this.displayName = (Object)((Object)feedType) + "(" + this.feedId + ")";
    }

    public FeedId getFeedId() {
        return this.feedId;
    }

    public String getDataverseName() {
        return this.feedId.getDataverse();
    }

    public String getFeedName() {
        return this.feedId.getFeedName();
    }

    public FunctionSignature getAppliedFunction() {
        return this.appliedFunction;
    }

    public FeedType getFeedType() {
        return this.feedType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Feed)) {
            return false;
        }
        Feed otherFeed = (Feed)other;
        return otherFeed.getFeedId().equals((Object)this.feedId);
    }

    public int hashCode() {
        return this.displayName.hashCode();
    }

    public String toString() {
        return (Object)((Object)this.feedType) + "(" + this.feedId + ")";
    }

    @Override
    public Object addToCache(MetadataCache cache) {
        return cache.addFeedIfNotExists(this);
    }

    @Override
    public Object dropFromCache(MetadataCache cache) {
        return cache.dropFeed(this);
    }

    public static enum FeedType {
        PRIMARY,
        SECONDARY;

    }
}

