/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.metadata.IDatasetDetails;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.api.IMetadataEntity;

public class Dataset
implements IMetadataEntity {
    private static final long serialVersionUID = 1L;
    private final String dataverseName;
    private final String datasetName;
    private final String itemTypeName;
    private final String nodeGroupName;
    private final String compactionPolicy;
    private final Map<String, String> compactionPolicyProperties;
    private final DatasetConfig.DatasetType datasetType;
    private final IDatasetDetails datasetDetails;
    private final Map<String, String> hints;
    private final int datasetId;
    private int pendingOp;

    public Dataset(String dataverseName, String datasetName, String itemTypeName, String nodeGroupName, String compactionPolicy, Map<String, String> compactionPolicyProperties, IDatasetDetails datasetDetails, Map<String, String> hints, DatasetConfig.DatasetType datasetType, int datasetId, int pendingOp) {
        this.dataverseName = dataverseName;
        this.datasetName = datasetName;
        this.itemTypeName = itemTypeName;
        this.nodeGroupName = nodeGroupName;
        this.compactionPolicy = compactionPolicy;
        this.compactionPolicyProperties = compactionPolicyProperties;
        this.datasetType = datasetType;
        this.datasetDetails = datasetDetails;
        this.datasetId = datasetId;
        this.pendingOp = pendingOp;
        this.hints = hints;
    }

    public String getDataverseName() {
        return this.dataverseName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public String getItemTypeName() {
        return this.itemTypeName;
    }

    public String getNodeGroupName() {
        return this.nodeGroupName;
    }

    public String getCompactionPolicy() {
        return this.compactionPolicy;
    }

    public Map<String, String> getCompactionPolicyProperties() {
        return this.compactionPolicyProperties;
    }

    public DatasetConfig.DatasetType getDatasetType() {
        return this.datasetType;
    }

    public IDatasetDetails getDatasetDetails() {
        return this.datasetDetails;
    }

    public Map<String, String> getHints() {
        return this.hints;
    }

    public int getDatasetId() {
        return this.datasetId;
    }

    public int getPendingOp() {
        return this.pendingOp;
    }

    public void setPendingOp(int pendingOp) {
        this.pendingOp = pendingOp;
    }

    @Override
    public Object addToCache(MetadataCache cache) {
        return cache.addDatasetIfNotExists(this);
    }

    @Override
    public Object dropFromCache(MetadataCache cache) {
        return cache.dropDataset(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Dataset)) {
            return false;
        }
        Dataset otherDataset = (Dataset)other;
        if (!otherDataset.dataverseName.equals(this.dataverseName)) {
            return false;
        }
        return otherDataset.datasetName.equals(this.datasetName);
    }

    public String toString() {
        return this.dataverseName + "." + this.datasetName;
    }
}

