/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.feeds.api.IDatasourceAdapter;
import org.apache.asterix.om.base.AMutableUUID;
import org.apache.asterix.om.base.AUUID;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;

public class PKGeneratingAdapter
implements IDatasourceAdapter {
    private static final long serialVersionUID = 1L;
    private final RecordDescriptor inRecDesc;
    private final RecordDescriptor outRecDesc;
    private final IDatasourceAdapter wrappedAdapter;
    private final PKGeneratingPushRuntime pkRuntime;
    private final int pkIndex;

    public PKGeneratingAdapter(IHyracksTaskContext ctx, RecordDescriptor inRecDesc, RecordDescriptor outRecDesc, ARecordType inRecType, ARecordType outRecType, IDatasourceAdapter wrappedAdapter, int pkIndex) {
        this.inRecDesc = inRecDesc;
        this.outRecDesc = outRecDesc;
        this.wrappedAdapter = wrappedAdapter;
        this.pkRuntime = new PKGeneratingPushRuntime(ctx, inRecType, outRecType);
        this.pkIndex = pkIndex;
    }

    public void start(int partition, IFrameWriter writer) throws Exception {
        this.pkRuntime.setInputRecordDescriptor(0, this.inRecDesc);
        this.pkRuntime.setFrameWriter(0, writer, this.outRecDesc);
        this.pkRuntime.open();
        try {
            this.wrappedAdapter.start(partition, (IFrameWriter)this.pkRuntime);
        }
        catch (Throwable t) {
            this.pkRuntime.fail();
            throw t;
        }
        finally {
            this.pkRuntime.close();
        }
    }

    private class PKGeneratingPushRuntime
    extends AbstractOneInputOneOutputOneFramePushRuntime {
        private final IHyracksTaskContext ctx;
        private final ARecordType outRecType;
        private final ArrayTupleBuilder tb;
        private final AMutableUUID aUUID = new AMutableUUID(0L, 0L);
        private final byte AUUIDTag = ATypeTag.UUID.serialize();
        private final byte[] serializedUUID = new byte[16];
        private final PointableAllocator pa = new PointableAllocator();
        private final ARecordVisitablePointable recordPointable;
        private final IAType[] outClosedTypes;
        private final RecordBuilder recBuilder;

        public PKGeneratingPushRuntime(IHyracksTaskContext ctx, ARecordType inRecType, ARecordType outRecType) {
            this.ctx = ctx;
            this.outRecType = outRecType;
            this.tb = new ArrayTupleBuilder(2);
            this.recBuilder = new RecordBuilder();
            this.recordPointable = (ARecordVisitablePointable)this.pa.allocateRecordValue((IAType)inRecType);
            this.outClosedTypes = outRecType.getFieldTypes();
        }

        private void serializeUUID(AUUID aUUID, byte[] serializedUUID) {
            long v = aUUID.getLeastSignificantBits();
            serializedUUID[0] = (byte)(v >>> 56);
            serializedUUID[1] = (byte)(v >>> 48);
            serializedUUID[2] = (byte)(v >>> 40);
            serializedUUID[3] = (byte)(v >>> 32);
            serializedUUID[4] = (byte)(v >>> 24);
            serializedUUID[5] = (byte)(v >>> 16);
            serializedUUID[6] = (byte)(v >>> 8);
            serializedUUID[7] = (byte)(v >>> 0);
            v = aUUID.getMostSignificantBits();
            serializedUUID[8] = (byte)(v >>> 56);
            serializedUUID[9] = (byte)(v >>> 48);
            serializedUUID[10] = (byte)(v >>> 40);
            serializedUUID[11] = (byte)(v >>> 32);
            serializedUUID[12] = (byte)(v >>> 24);
            serializedUUID[13] = (byte)(v >>> 16);
            serializedUUID[14] = (byte)(v >>> 8);
            serializedUUID[15] = (byte)(v >>> 0);
        }

        public void open() throws HyracksDataException {
            this.initAccessAppendRef(this.ctx);
            this.recBuilder.reset(this.outRecType);
            this.recBuilder.init();
        }

        public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
            try {
                this.tAccess.reset(buffer);
                for (int i = 0; i < this.tAccess.getTupleCount(); ++i) {
                    List fp;
                    this.tb.reset();
                    this.tRef.reset((IFrameTupleAccessor)this.tAccess, i);
                    this.aUUID.nextUUID();
                    this.tb.getDataOutput().writeByte(this.AUUIDTag);
                    this.serializeUUID((AUUID)this.aUUID, this.serializedUUID);
                    this.tb.getDataOutput().write(this.serializedUUID);
                    this.tb.addFieldEndOffset();
                    this.recordPointable.set(this.tRef.getFieldData(0), this.tRef.getFieldStart(0), this.tRef.getFieldLength(0));
                    int inIndex = 0;
                    for (int f = 0; f < this.outClosedTypes.length; ++f) {
                        if (f == PKGeneratingAdapter.this.pkIndex) {
                            this.recBuilder.addField(f, this.serializedUUID);
                            continue;
                        }
                        this.recBuilder.addField(f, (IValueReference)this.recordPointable.getFieldValues().get(inIndex));
                        ++inIndex;
                    }
                    if (this.outRecType.isOpen() && (fp = this.recordPointable.getFieldNames()).size() >= this.outClosedTypes.length) {
                        for (int index = this.outClosedTypes.length - 1; index < fp.size(); ++index) {
                            this.recBuilder.addField((IValueReference)fp.get(index), (IValueReference)this.recordPointable.getFieldValues().get(index));
                        }
                    }
                    this.recBuilder.write(this.tb.getDataOutput(), true);
                    this.tb.addFieldEndOffset();
                    this.appendToFrameFromTupleBuilder(this.tb);
                }
            }
            catch (Exception e) {
                throw new HyracksDataException("Error in the auto id generation and merge of the record", (Throwable)e);
            }
        }

        public void close() throws HyracksDataException {
            this.flushIfNotFailed();
        }
    }
}

