/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.metadata.declared.AqlDataSource;
import org.apache.asterix.metadata.declared.AqlSourceId;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.utils.DatasetUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang.StringUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.properties.DefaultNodeGroupDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class LoadableDataSource
extends AqlDataSource {
    private final INodeDomain domain;
    private final IAType[] schemaTypes;
    private final Dataset targetDataset;
    private final List<List<String>> partitioningKeys;
    private final String adapter;
    private final Map<String, String> adapterProperties;
    private final boolean isPKAutoGenerated;

    public boolean isPKAutoGenerated() {
        return this.isPKAutoGenerated;
    }

    public LoadableDataSource(Dataset targetDataset, IAType itemType, String adapter, Map<String, String> properties) throws AlgebricksException, IOException {
        super(new AqlSourceId("loadable_dv", "loadable_ds"), "loadable_dv", "loadable_source", itemType, AqlDataSource.AqlDataSourceType.LOADABLE);
        this.targetDataset = targetDataset;
        this.adapter = adapter;
        this.adapterProperties = properties;
        this.partitioningKeys = DatasetUtils.getPartitioningKeys(targetDataset);
        this.domain = new DefaultNodeGroupDomain(targetDataset.getNodeGroupName());
        ARecordType recType = (ARecordType)itemType;
        this.isPKAutoGenerated = ((InternalDatasetDetails)targetDataset.getDatasetDetails()).isAutogenerated();
        if (this.isPKAutoGenerated) {
            try {
                recType = this.getStrippedPKType(new LinkedList<String>((Collection)this.partitioningKeys.get(0)), recType);
            }
            catch (AsterixException e) {
                throw new AlgebricksException((Throwable)e);
            }
        }
        this.schemaTypes = new IAType[]{recType};
    }

    /*
     * Enabled aggressive block sorting
     */
    private ARecordType getStrippedPKType(List<String> partitioningKeys, ARecordType recType) throws AsterixException, HyracksDataException {
        LinkedList<String> fieldNames = new LinkedList<String>();
        LinkedList<IAType> fieldTypes = new LinkedList<IAType>();
        int j = 0;
        int i = 0;
        while (true) {
            block6: {
                IAType fieldType;
                block5: {
                    block3: {
                        block4: {
                            if (i >= recType.getFieldNames().length) {
                                return new ARecordType(recType.getTypeName(), fieldNames.toArray(new String[0]), fieldTypes.toArray(new IAType[0]), recType.isOpen());
                            }
                            fieldType = null;
                            if (!partitioningKeys.get(0).equals(recType.getFieldNames()[j])) break block3;
                            if (recType.getFieldTypes()[j].getTypeTag() != ATypeTag.RECORD) break block4;
                            if (j != 0) {
                                throw new AsterixException("Autogenerated key " + StringUtils.join(partitioningKeys, (char)'.') + " should be a first field of the type " + recType.getTypeName());
                            }
                            partitioningKeys.remove(0);
                            fieldType = this.getStrippedPKType(partitioningKeys, (ARecordType)recType.getFieldTypes()[j]);
                            break block5;
                        }
                        ++j;
                        break block6;
                    }
                    fieldType = recType.getFieldTypes()[j];
                }
                fieldTypes.add(fieldType);
                fieldNames.add(recType.getFieldNames()[j]);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public IAType[] getSchemaTypes() {
        return this.schemaTypes;
    }

    @Override
    public INodeDomain getDomain() {
        return this.domain;
    }

    @Override
    public void computeLocalStructuralProperties(List<ILocalStructuralProperty> localProps, List<LogicalVariable> variables) {
    }

    public List<List<String>> getPartitioningKeys() {
        return this.partitioningKeys;
    }

    public String getAdapter() {
        return this.adapter;
    }

    public Map<String, String> getAdapterProperties() {
        return this.adapterProperties;
    }

    public IAType getLoadedType() {
        return this.schemaTypes[this.schemaTypes.length - 1];
    }

    public Dataset getTargetDataset() {
        return this.targetDataset;
    }
}

