/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.feeds.api.IDatasourceAdapter;
import org.apache.asterix.dataflow.data.nontagged.serde.ARecordSerializerDeserializer;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.util.NonTaggedFormatUtil;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;

public class FieldExtractingAdapter
implements IDatasourceAdapter {
    private static final long serialVersionUID = 1L;
    private final RecordDescriptor inRecDesc;
    private final RecordDescriptor outRecDesc;
    private final IDatasourceAdapter wrappedAdapter;
    private final FieldExtractingPushRuntime fefw;

    public FieldExtractingAdapter(IHyracksTaskContext ctx, RecordDescriptor inRecDesc, RecordDescriptor outRecDesc, int[][] extractFields, ARecordType rType, IDatasourceAdapter wrappedAdapter) {
        this.inRecDesc = inRecDesc;
        this.outRecDesc = outRecDesc;
        this.wrappedAdapter = wrappedAdapter;
        this.fefw = new FieldExtractingPushRuntime(ctx, extractFields, rType);
    }

    public void start(int partition, IFrameWriter writer) throws Exception {
        this.fefw.setInputRecordDescriptor(0, this.inRecDesc);
        this.fefw.setFrameWriter(0, writer, this.outRecDesc);
        this.fefw.open();
        try {
            this.wrappedAdapter.start(partition, (IFrameWriter)this.fefw);
        }
        catch (Throwable t) {
            this.fefw.fail();
            throw t;
        }
        finally {
            this.fefw.close();
        }
    }

    private static class FieldExtractingPushRuntime
    extends AbstractOneInputOneOutputOneFramePushRuntime {
        private final IHyracksTaskContext ctx;
        private final int[][] extractFields;
        private final ARecordType rType;
        private final int nullBitmapSize;
        private final ArrayTupleBuilder tb;

        public FieldExtractingPushRuntime(IHyracksTaskContext ctx, int[][] extractFields, ARecordType rType) {
            this.ctx = ctx;
            this.extractFields = extractFields;
            this.rType = rType;
            this.nullBitmapSize = ARecordType.computeNullBitmapSize((ARecordType)rType);
            this.tb = new ArrayTupleBuilder(extractFields.length + 1);
        }

        public void open() throws HyracksDataException {
            this.initAccessAppendRef(this.ctx);
        }

        public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
            this.tAccess.reset(buffer);
            for (int i = 0; i < this.tAccess.getTupleCount(); ++i) {
                this.tb.reset();
                this.tRef.reset((IFrameTupleAccessor)this.tAccess, i);
                byte[] record = this.tRef.getFieldData(0);
                int recStart = this.tRef.getFieldStart(0);
                int recLength = this.tRef.getFieldLength(0);
                for (int f = 0; f < this.extractFields.length; ++f) {
                    try {
                        byte[] subRecord = record;
                        int subFStart = recStart;
                        int subFOffset = 0;
                        boolean isNull = false;
                        ARecordType subFType = this.rType;
                        int subFLen = recLength;
                        int subBitMapSize = this.nullBitmapSize;
                        for (int j = 0; j < this.extractFields[f].length; ++j) {
                            subFOffset = ARecordSerializerDeserializer.getFieldOffsetById((byte[])subRecord, (int)subFStart, (int)this.extractFields[f][j], (int)subBitMapSize, (boolean)subFType.isOpen());
                            if (subFOffset == 0) {
                                this.tb.getDataOutput().write(ATypeTag.NULL.serialize());
                                isNull = true;
                                break;
                            }
                            subFType = subFType.getFieldTypes()[this.extractFields[f][j]];
                            try {
                                subFLen = NonTaggedFormatUtil.getFieldValueLength((byte[])subRecord, (int)(subFStart + subFOffset), (ATypeTag)subFType.getTypeTag(), (boolean)false);
                                if (j >= this.extractFields[f].length - 1) continue;
                                byte[] subRecordTmp = new byte[subFLen + 1];
                                subRecordTmp[0] = subFType.getTypeTag().serialize();
                                System.arraycopy(subRecord, subFStart + subFOffset, subRecordTmp, 1, subFLen);
                                subRecord = subRecordTmp;
                                subFStart = 0;
                                subBitMapSize = ARecordType.computeNullBitmapSize((ARecordType)subFType);
                                continue;
                            }
                            catch (AsterixException e) {
                                throw new HyracksDataException((Throwable)e);
                            }
                        }
                        if (!isNull) {
                            this.tb.getDataOutput().write(subFType.getTypeTag().serialize());
                            this.tb.getDataOutput().write(subRecord, subFStart + subFOffset, subFLen);
                        }
                    }
                    catch (IOException e) {
                        throw new HyracksDataException((Throwable)e);
                    }
                    this.tb.addFieldEndOffset();
                }
                this.tb.addField(record, recStart, this.tRef.getFieldLength(0));
                this.appendToFrameFromTupleBuilder(this.tb);
            }
        }

        public void close() throws HyracksDataException {
            this.flushIfNotFailed();
        }
    }
}

