/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import org.apache.asterix.common.feeds.FeedId;
import org.apache.asterix.common.feeds.api.IFeedLifecycleListener;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.AqlDataSource;
import org.apache.asterix.metadata.declared.AqlSourceId;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.AsterixClusterProperties;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;

public class FeedDataSource
extends AqlDataSource {
    private Feed feed;
    private final FeedId sourceFeedId;
    private final Feed.FeedType sourceFeedType;
    private final IFeedLifecycleListener.ConnectionLocation location;
    private final String targetDataset;
    private final String[] locations;
    private final int computeCardinality;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeedDataSource(AqlSourceId id, String targetDataset, IAType itemType, AqlDataSource.AqlDataSourceType dataSourceType, FeedId sourceFeedId, Feed.FeedType sourceFeedType, IFeedLifecycleListener.ConnectionLocation location, String[] locations) throws AlgebricksException {
        block7: {
            super(id, id.getDataverseName(), id.getDatasourceName(), itemType, dataSourceType);
            this.targetDataset = targetDataset;
            this.sourceFeedId = sourceFeedId;
            this.sourceFeedType = sourceFeedType;
            this.location = location;
            this.locations = locations;
            this.computeCardinality = AsterixClusterProperties.INSTANCE.getParticipantNodes().size();
            MetadataTransactionContext ctx = null;
            try {
                MetadataManager.INSTANCE.acquireReadLatch();
                ctx = MetadataManager.INSTANCE.beginTransaction();
                this.feed = MetadataManager.INSTANCE.getFeed(ctx, id.getDataverseName(), id.getDatasourceName());
                MetadataManager.INSTANCE.commitTransaction(ctx);
                this.initFeedDataSource(itemType);
            }
            catch (Exception e) {
                if (ctx == null) break block7;
                try {
                    MetadataManager.INSTANCE.abortTransaction(ctx);
                }
                catch (Exception e2) {
                    e2.addSuppressed(e);
                    throw new IllegalStateException("Unable to abort " + e2.getMessage());
                }
            }
            finally {
                MetadataManager.INSTANCE.releaseReadLatch();
            }
        }
    }

    public Feed getFeed() {
        return this.feed;
    }

    @Override
    public IAType[] getSchemaTypes() {
        return this.schemaTypes;
    }

    @Override
    public INodeDomain getDomain() {
        return this.domain;
    }

    public String getTargetDataset() {
        return this.targetDataset;
    }

    public FeedId getSourceFeedId() {
        return this.sourceFeedId;
    }

    public IFeedLifecycleListener.ConnectionLocation getLocation() {
        return this.location;
    }

    public String[] getLocations() {
        return this.locations;
    }

    private void initFeedDataSource(IAType itemType) {
        INodeDomain domainForExternalData;
        this.schemaTypes = new IAType[1];
        this.schemaTypes[0] = itemType;
        this.domain = domainForExternalData = new INodeDomain(){

            public Integer cardinality() {
                return null;
            }

            public boolean sameAs(INodeDomain domain) {
                return domain == this;
            }
        };
    }

    public Feed.FeedType getSourceFeedType() {
        return this.sourceFeedType;
    }

    public int getComputeCardinality() {
        return this.computeCardinality;
    }
}

