/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.io.IOException;
import java.util.List;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.AqlDataSource;
import org.apache.asterix.metadata.declared.AqlSourceId;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.utils.DatasetUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.properties.DefaultNodeGroupDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;

public class DatasetDataSource
extends AqlDataSource {
    private Dataset dataset;

    public DatasetDataSource(AqlSourceId id, String datasourceDataverse, String datasourceName, IAType itemType, AqlDataSource.AqlDataSourceType datasourceType) throws AlgebricksException {
        block9: {
            super(id, datasourceDataverse, datasourceName, itemType, datasourceType);
            MetadataTransactionContext ctx = null;
            try {
                ctx = MetadataManager.INSTANCE.beginTransaction();
                this.dataset = MetadataManager.INSTANCE.getDataset(ctx, datasourceDataverse, datasourceName);
                if (this.dataset == null) {
                    throw new AlgebricksException("Unknown dataset " + datasourceName + " in dataverse " + datasourceDataverse);
                }
                MetadataManager.INSTANCE.commitTransaction(ctx);
                switch (this.dataset.getDatasetType()) {
                    case INTERNAL: {
                        this.initInternalDataset(itemType);
                        break;
                    }
                    case EXTERNAL: {
                        this.initExternalDataset(itemType);
                    }
                }
            }
            catch (Exception e) {
                if (ctx == null) break block9;
                try {
                    MetadataManager.INSTANCE.abortTransaction(ctx);
                }
                catch (Exception e2) {
                    e2.addSuppressed(e);
                    throw new IllegalStateException("Unable to abort " + e2.getMessage());
                }
            }
        }
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    private void initInternalDataset(IAType itemType) throws IOException, AlgebricksException {
        List<List<String>> partitioningKeys = DatasetUtils.getPartitioningKeys(this.dataset);
        ARecordType recordType = (ARecordType)itemType;
        int n = partitioningKeys.size();
        this.schemaTypes = new IAType[n + 1];
        for (int i = 0; i < n; ++i) {
            this.schemaTypes[i] = recordType.getSubFieldType(partitioningKeys.get(i));
        }
        this.schemaTypes[n] = itemType;
        this.domain = new DefaultNodeGroupDomain(this.dataset.getNodeGroupName());
    }

    private void initExternalDataset(IAType itemType) {
        INodeDomain domainForExternalData;
        this.schemaTypes = new IAType[1];
        this.schemaTypes[0] = itemType;
        this.domain = domainForExternalData = new INodeDomain(){

            public Integer cardinality() {
                return null;
            }

            public boolean sameAs(INodeDomain domain) {
                return domain == this;
            }
        };
    }

    @Override
    public IAType[] getSchemaTypes() {
        return this.schemaTypes;
    }

    @Override
    public INodeDomain getDomain() {
        return this.domain;
    }

    @Override
    public void computeLocalStructuralProperties(List<ILocalStructuralProperty> localProps, List<LogicalVariable> variables) {
    }
}

