/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.config.AsterixStorageProperties;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.context.AsterixVirtualBufferCacheProvider;
import org.apache.asterix.common.context.ITransactionSubsystemProvider;
import org.apache.asterix.common.context.TransactionSubsystemProvider;
import org.apache.asterix.common.dataflow.AsterixLSMInvertedIndexInsertDeleteOperatorDescriptor;
import org.apache.asterix.common.dataflow.AsterixLSMTreeInsertDeleteOperatorDescriptor;
import org.apache.asterix.common.dataflow.IAsterixApplicationContextInfo;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.feeds.FeedActivity;
import org.apache.asterix.common.feeds.FeedConnectionId;
import org.apache.asterix.common.feeds.FeedPolicyAccessor;
import org.apache.asterix.common.feeds.api.ICentralFeedManager;
import org.apache.asterix.common.ioopcallbacks.LSMBTreeIOOperationCallbackFactory;
import org.apache.asterix.common.ioopcallbacks.LSMBTreeWithBuddyIOOperationCallbackFactory;
import org.apache.asterix.common.ioopcallbacks.LSMInvertedIndexIOOperationCallbackFactory;
import org.apache.asterix.common.ioopcallbacks.LSMRTreeIOOperationCallbackFactory;
import org.apache.asterix.common.parse.IParseFileSplitsDecl;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.dataflow.data.nontagged.valueproviders.AqlPrimitiveValueProviderFactory;
import org.apache.asterix.formats.base.IDataFormat;
import org.apache.asterix.formats.nontagged.AqlBinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.AqlLinearizeComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.AqlTypeTraitProvider;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.AqlDataSource;
import org.apache.asterix.metadata.declared.AqlIndex;
import org.apache.asterix.metadata.declared.AqlMetadataImplConfig;
import org.apache.asterix.metadata.declared.AqlSourceId;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.declared.FeedDataSource;
import org.apache.asterix.metadata.declared.FileSplitDataSink;
import org.apache.asterix.metadata.declared.FileSplitSinkId;
import org.apache.asterix.metadata.declared.LoadableDataSource;
import org.apache.asterix.metadata.declared.ResultSetDataSink;
import org.apache.asterix.metadata.declared.ResultSetSinkId;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.ExternalDatasetDetails;
import org.apache.asterix.metadata.entities.ExternalFile;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedPolicy;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.entities.PrimaryFeed;
import org.apache.asterix.metadata.external.IAdapterFactory;
import org.apache.asterix.metadata.external.IndexingConstants;
import org.apache.asterix.metadata.feeds.ExternalDataScanOperatorDescriptor;
import org.apache.asterix.metadata.feeds.FeedCollectOperatorDescriptor;
import org.apache.asterix.metadata.feeds.FeedIntakeOperatorDescriptor;
import org.apache.asterix.metadata.feeds.FeedUtil;
import org.apache.asterix.metadata.feeds.IFeedAdapterFactory;
import org.apache.asterix.metadata.utils.DatasetUtils;
import org.apache.asterix.metadata.utils.ExternalDatasetsRegistry;
import org.apache.asterix.om.functions.AsterixBuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.AsterixAppContextInfo;
import org.apache.asterix.om.util.AsterixClusterProperties;
import org.apache.asterix.om.util.NonTaggedFormatUtil;
import org.apache.asterix.runtime.base.AsterixTupleFilterFactory;
import org.apache.asterix.runtime.external.ExternalBTreeSearchOperatorDescriptor;
import org.apache.asterix.runtime.external.ExternalRTreeSearchOperatorDescriptor;
import org.apache.asterix.runtime.formats.FormatUtils;
import org.apache.asterix.runtime.formats.NonTaggedDataFormat;
import org.apache.asterix.runtime.job.listener.JobEventListenerFactory;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexInstantSearchOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexModificationOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexOperationTrackerProvider;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexSearchOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.SecondaryIndexModificationOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.SecondaryIndexOperationTrackerProvider;
import org.apache.asterix.transaction.management.opcallbacks.SecondaryIndexSearchOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.TempDatasetPrimaryIndexModificationOperationCallbackFactory;
import org.apache.asterix.transaction.management.opcallbacks.TempDatasetSecondaryIndexModificationOperationCallbackFactory;
import org.apache.asterix.transaction.management.service.transaction.AsterixRuntimeComponentsProvider;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSink;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourceIndex;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.algebricks.core.jobgen.impl.OperatorSchemaImpl;
import org.apache.hyracks.algebricks.data.IAWriterFactory;
import org.apache.hyracks.algebricks.data.IPrinterFactory;
import org.apache.hyracks.algebricks.data.IResultSerializerFactoryProvider;
import org.apache.hyracks.algebricks.data.ISerializerDeserializerProvider;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.std.SinkWriterRuntimeFactory;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.dataflow.value.IResultSerializerFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.data.std.accessors.PointableBinaryComparatorFactory;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.ShortPointable;
import org.apache.hyracks.dataflow.common.data.marshalling.ShortSerializerDeserializer;
import org.apache.hyracks.dataflow.std.file.ConstantFileSplitProvider;
import org.apache.hyracks.dataflow.std.file.FileScanOperatorDescriptor;
import org.apache.hyracks.dataflow.std.file.FileSplit;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.dataflow.std.file.ITupleParserFactory;
import org.apache.hyracks.dataflow.std.result.ResultWriterOperatorDescriptor;
import org.apache.hyracks.storage.am.btree.dataflow.BTreeSearchOperatorDescriptor;
import org.apache.hyracks.storage.am.btree.frames.BTreeNSMInteriorFrameFactory;
import org.apache.hyracks.storage.am.common.api.IIndexLifecycleManagerProvider;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriterFactory;
import org.apache.hyracks.storage.am.common.api.ITupleFilterFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.TreeIndexBulkLoadOperatorDescriptor;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.tuples.TypeAwareTupleWriterFactory;
import org.apache.hyracks.storage.am.lsm.btree.dataflow.ExternalBTreeWithBuddyDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.btree.dataflow.LSMBTreeDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationSchedulerProvider;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTrackerProvider;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCacheProvider;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.BinaryTokenizerOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.LSMInvertedIndexBulkLoadOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.LSMInvertedIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.PartitionedLSMInvertedIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.am.lsm.rtree.dataflow.ExternalRTreeDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.rtree.dataflow.LSMRTreeDataflowHelperFactory;
import org.apache.hyracks.storage.am.rtree.dataflow.RTreeSearchOperatorDescriptor;
import org.apache.hyracks.storage.am.rtree.frames.RTreePolicyType;
import org.apache.hyracks.storage.common.IStorageManagerInterface;

public class AqlMetadataProvider
implements IMetadataProvider<AqlSourceId, String> {
    private static Logger LOGGER = Logger.getLogger(AqlMetadataProvider.class.getName());
    private MetadataTransactionContext mdTxnCtx;
    private boolean isWriteTransaction;
    private final Map<String, String[]> stores;
    private Map<String, String> config;
    private IAWriterFactory writerFactory;
    private FileSplit outputFile;
    private boolean asyncResults;
    private ResultSetId resultSetId;
    private IResultSerializerFactoryProvider resultSerializerFactoryProvider;
    private final ICentralFeedManager centralFeedManager;
    private final Dataverse defaultDataverse;
    private JobId jobId;
    private Map<String, Integer> locks;
    private boolean isTemporaryDatasetWriteJob = true;
    private final AsterixStorageProperties storageProperties;
    public static final Map<String, String> adapterFactoryMapping = AqlMetadataProvider.initializeAdapterFactoryMapping();

    public String getPropertyValue(String propertyName) {
        return this.config.get(propertyName);
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public Map<String, String[]> getAllStores() {
        return this.stores;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public AqlMetadataProvider(Dataverse defaultDataverse, ICentralFeedManager centralFeedManager) {
        this.defaultDataverse = defaultDataverse;
        this.stores = AsterixAppContextInfo.getInstance().getMetadataProperties().getStores();
        this.storageProperties = AsterixAppContextInfo.getInstance().getStorageProperties();
        this.centralFeedManager = centralFeedManager;
    }

    public void setJobId(JobId jobId) {
        this.jobId = jobId;
    }

    public Dataverse getDefaultDataverse() {
        return this.defaultDataverse;
    }

    public String getDefaultDataverseName() {
        return this.defaultDataverse == null ? null : this.defaultDataverse.getDataverseName();
    }

    public void setWriteTransaction(boolean writeTransaction) {
        this.isWriteTransaction = writeTransaction;
    }

    public void setWriterFactory(IAWriterFactory writerFactory) {
        this.writerFactory = writerFactory;
    }

    public void setMetadataTxnContext(MetadataTransactionContext mdTxnCtx) {
        this.mdTxnCtx = mdTxnCtx;
    }

    public MetadataTransactionContext getMetadataTxnContext() {
        return this.mdTxnCtx;
    }

    public IAWriterFactory getWriterFactory() {
        return this.writerFactory;
    }

    public FileSplit getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(FileSplit outputFile) {
        this.outputFile = outputFile;
    }

    public boolean getResultAsyncMode() {
        return this.asyncResults;
    }

    public void setResultAsyncMode(boolean asyncResults) {
        this.asyncResults = asyncResults;
    }

    public ResultSetId getResultSetId() {
        return this.resultSetId;
    }

    public void setResultSetId(ResultSetId resultSetId) {
        this.resultSetId = resultSetId;
    }

    public void setResultSerializerFactoryProvider(IResultSerializerFactoryProvider rafp) {
        this.resultSerializerFactoryProvider = rafp;
    }

    public IResultSerializerFactoryProvider getResultSerializerFactoryProvider() {
        return this.resultSerializerFactoryProvider;
    }

    public ARecordType findOutputRecordType() throws AlgebricksException {
        String outputRecordType = this.getPropertyValue("output-record-type");
        if (outputRecordType == null) {
            return null;
        }
        String dataverse = this.getDefaultDataverseName();
        if (dataverse == null) {
            throw new AlgebricksException("Cannot declare output-record-type with no dataverse!");
        }
        IAType type = this.findType(dataverse, outputRecordType);
        if (!(type instanceof ARecordType)) {
            throw new AlgebricksException("Type " + outputRecordType + " is not a record type!");
        }
        return (ARecordType)type;
    }

    public AqlDataSource findDataSource(AqlSourceId id) throws AlgebricksException {
        AqlSourceId aqlId = id;
        try {
            return this.lookupSourceInMetadata(aqlId);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)((Object)e));
        }
    }

    public boolean isWriteTransaction() {
        return this.isWriteTransaction;
    }

    public boolean isTemporaryDatasetWriteJob() {
        return this.isTemporaryDatasetWriteJob;
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getScannerRuntime(IDataSource<AqlSourceId> dataSource, List<LogicalVariable> scanVariables, List<LogicalVariable> projectVariables, boolean projectPushed, List<LogicalVariable> minFilterVars, List<LogicalVariable> maxFilterVars, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, JobSpecification jobSpec, Object implConfig) throws AlgebricksException {
        try {
            switch (((AqlDataSource)dataSource).getDatasourceType()) {
                case FEED: {
                    return this.buildFeedCollectRuntime(jobSpec, dataSource);
                }
                case INTERNAL_DATASET: {
                    return this.buildInternalDatasetScan(jobSpec, scanVariables, minFilterVars, maxFilterVars, opSchema, typeEnv, dataSource, context, implConfig);
                }
                case EXTERNAL_DATASET: {
                    Dataset dataset = ((DatasetDataSource)dataSource).getDataset();
                    String itemTypeName = dataset.getItemTypeName();
                    IAType itemType = MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, dataset.getDataverseName(), itemTypeName).getDatatype();
                    ExternalDatasetDetails edd = (ExternalDatasetDetails)dataset.getDatasetDetails();
                    IAdapterFactory adapterFactory = this.getConfiguredAdapterFactory(dataset, edd.getAdapter(), edd.getProperties(), itemType, false, null);
                    return this.buildExternalDatasetDataScannerRuntime(jobSpec, itemType, adapterFactory, (IDataFormat)NonTaggedDataFormat.INSTANCE);
                }
                case LOADABLE: {
                    LoadableDataSource alds = (LoadableDataSource)dataSource;
                    List<List<String>> partitioningKeys = alds.getPartitioningKeys();
                    boolean isPKAutoGenerated = ((InternalDatasetDetails)alds.getTargetDataset().getDatasetDetails()).isAutogenerated();
                    ARecordType itemType = (ARecordType)alds.getLoadedType();
                    int pkIndex = 0;
                    IAdapterFactory adapterFactory = this.getConfiguredAdapterFactory(alds.getTargetDataset(), alds.getAdapter(), alds.getAdapterProperties(), (IAType)itemType, isPKAutoGenerated, partitioningKeys);
                    RecordDescriptor rDesc = JobGenHelper.mkRecordDescriptor((IVariableTypeEnvironment)typeEnv, (IOperatorSchema)opSchema, (JobGenContext)context);
                    return this.buildLoadableDatasetScan(jobSpec, alds, adapterFactory, rDesc, isPKAutoGenerated, partitioningKeys, itemType, pkIndex);
                }
            }
            throw new IllegalArgumentException();
        }
        catch (AsterixException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildFeedCollectRuntime(JobSpecification jobSpec, IDataSource<AqlSourceId> dataSource) throws AlgebricksException {
        FeedDataSource feedDataSource = (FeedDataSource)dataSource;
        FeedCollectOperatorDescriptor feedCollector = null;
        try {
            ARecordType feedOutputType = (ARecordType)feedDataSource.getItemType();
            ISerializerDeserializer payloadSerde = NonTaggedDataFormat.INSTANCE.getSerdeProvider().getSerializerDeserializer((Object)feedOutputType);
            RecordDescriptor feedDesc = new RecordDescriptor(new ISerializerDeserializer[]{payloadSerde});
            FeedPolicy feedPolicy = (FeedPolicy)((AqlDataSource)dataSource).getProperties().get("policy");
            if (feedPolicy == null) {
                throw new AlgebricksException("Feed not configured with a policy");
            }
            feedPolicy.getProperties().put("policy", feedPolicy.getPolicyName());
            FeedConnectionId feedConnectionId = new FeedConnectionId(feedDataSource.getId().getDataverseName(), feedDataSource.getId().getDatasourceName(), feedDataSource.getTargetDataset());
            feedCollector = new FeedCollectOperatorDescriptor(jobSpec, feedConnectionId, feedDataSource.getSourceFeedId(), feedOutputType, feedDesc, feedPolicy.getProperties(), feedDataSource.getLocation());
            return new Pair((Object)feedCollector, (Object)this.determineLocationConstraint(feedDataSource));
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private AlgebricksAbsolutePartitionConstraint determineLocationConstraint(FeedDataSource feedDataSource) throws AsterixException {
        String[] locationArray = null;
        String locations = null;
        block0 : switch (feedDataSource.getSourceFeedType()) {
            case PRIMARY: {
                Collection activities;
                block4 : switch (feedDataSource.getLocation()) {
                    case SOURCE_FEED_COMPUTE_STAGE: {
                        if (feedDataSource.getFeed().getFeedId().equals((Object)feedDataSource.getSourceFeedId())) {
                            locationArray = feedDataSource.getLocations();
                            break;
                        }
                        activities = this.centralFeedManager.getFeedLoadManager().getFeedActivities();
                        Iterator it = activities.iterator();
                        FeedActivity activity = null;
                        while (it.hasNext()) {
                            activity = (FeedActivity)it.next();
                            if (!activity.getDataverseName().equals(feedDataSource.getSourceFeedId().getDataverse()) || !activity.getFeedName().equals(feedDataSource.getSourceFeedId().getFeedName())) continue;
                            locations = (String)activity.getFeedActivityDetails().get("compute-locations");
                            locationArray = locations.split(",");
                            break block4;
                        }
                        break block0;
                    }
                    case SOURCE_FEED_INTAKE_STAGE: {
                        locationArray = feedDataSource.getLocations();
                    }
                }
                break;
            }
            case SECONDARY: {
                Collection activities = this.centralFeedManager.getFeedLoadManager().getFeedActivities();
                Iterator it = activities.iterator();
                FeedActivity activity = null;
                block13: while (it.hasNext()) {
                    activity = (FeedActivity)it.next();
                    if (!activity.getDataverseName().equals(feedDataSource.getSourceFeedId().getDataverse()) || !activity.getFeedName().equals(feedDataSource.getSourceFeedId().getFeedName())) continue;
                    switch (feedDataSource.getLocation()) {
                        case SOURCE_FEED_INTAKE_STAGE: {
                            locations = (String)activity.getFeedActivityDetails().get("collect-locations");
                            break block13;
                        }
                        case SOURCE_FEED_COMPUTE_STAGE: {
                            locations = (String)activity.getFeedActivityDetails().get("compute-locations");
                        }
                    }
                }
                if (locations != null) {
                    locationArray = locations.split(",");
                    break;
                }
                String message = "Unable to discover location(s) for source feed data hand-off " + feedDataSource.getSourceFeedId();
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.severe(message);
                }
                throw new AsterixException(message);
            }
        }
        AlgebricksAbsolutePartitionConstraint locationConstraint = new AlgebricksAbsolutePartitionConstraint(locationArray);
        return locationConstraint;
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildLoadableDatasetScan(JobSpecification jobSpec, LoadableDataSource alds, IAdapterFactory adapterFactory, RecordDescriptor rDesc, boolean isPKAutoGenerated, List<List<String>> primaryKeys, ARecordType recType, int pkIndex) throws AlgebricksException {
        AlgebricksPartitionConstraint constraint;
        if (!adapterFactory.getSupportedOperations().equals((Object)IAdapterFactory.SupportedOperation.READ) && !adapterFactory.getSupportedOperations().equals((Object)IAdapterFactory.SupportedOperation.READ_WRITE)) {
            throw new AlgebricksException(" External dataset adapter does not support read operation");
        }
        ExternalDataScanOperatorDescriptor dataScanner = new ExternalDataScanOperatorDescriptor(jobSpec, rDesc, adapterFactory);
        try {
            constraint = adapterFactory.getPartitionConstraint();
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
        return new Pair((Object)dataScanner, (Object)constraint);
    }

    public IDataFormat getDataFormat(String dataverseName) throws AsterixException {
        IDataFormat format;
        Dataverse dataverse = MetadataManager.INSTANCE.getDataverse(this.mdTxnCtx, dataverseName);
        try {
            format = (IDataFormat)Class.forName(dataverse.getDataFormat()).newInstance();
        }
        catch (Exception e) {
            throw new AsterixException((Throwable)e);
        }
        return format;
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildInternalDatasetScan(JobSpecification jobSpec, List<LogicalVariable> outputVars, List<LogicalVariable> minFilterVars, List<LogicalVariable> maxFilterVars, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, IDataSource<AqlSourceId> dataSource, JobGenContext context, Object implConfig) throws AlgebricksException, MetadataException {
        AqlSourceId asid = (AqlSourceId)dataSource.getId();
        String dataverseName = asid.getDataverseName();
        String datasetName = asid.getDatasourceName();
        Index primaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataverseName, datasetName, datasetName);
        int[] minFilterFieldIndexes = null;
        if (minFilterVars != null && !minFilterVars.isEmpty()) {
            minFilterFieldIndexes = new int[minFilterVars.size()];
            int i = 0;
            for (LogicalVariable v : minFilterVars) {
                minFilterFieldIndexes[i] = opSchema.findVariable(v);
                ++i;
            }
        }
        int[] maxFilterFieldIndexes = null;
        if (maxFilterVars != null && !maxFilterVars.isEmpty()) {
            maxFilterFieldIndexes = new int[maxFilterVars.size()];
            int i = 0;
            for (LogicalVariable v : maxFilterVars) {
                maxFilterFieldIndexes[i] = opSchema.findVariable(v);
                ++i;
            }
        }
        return this.buildBtreeRuntime(jobSpec, outputVars, opSchema, typeEnv, context, true, false, ((DatasetDataSource)dataSource).getDataset(), primaryIndex.getIndexName(), null, null, true, true, implConfig, minFilterFieldIndexes, maxFilterFieldIndexes);
    }

    private IAdapterFactory getConfiguredAdapterFactory(Dataset dataset, String adapterName, Map<String, String> configuration, IAType itemType, boolean isPKAutoGenerated, List<List<String>> primaryKeys) throws AlgebricksException {
        try {
            IAdapterFactory adapterFactory;
            String adapterFactoryClassname;
            DatasourceAdapter adapterEntity = MetadataManager.INSTANCE.getAdapter(this.mdTxnCtx, "Metadata", adapterName);
            if (adapterEntity != null) {
                adapterFactoryClassname = adapterEntity.getClassname();
                adapterFactory = (IAdapterFactory)Class.forName(adapterFactoryClassname).newInstance();
            } else {
                adapterFactoryClassname = adapterFactoryMapping.get(adapterName);
                if (adapterFactoryClassname == null) {
                    throw new AlgebricksException(" Unknown adapter :" + adapterName);
                }
                adapterFactory = (IAdapterFactory)Class.forName(adapterFactoryClassname).newInstance();
            }
            adapterFactory.configure(configuration, (ARecordType)itemType);
            Index filesIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName().concat("FilesIndex"));
            if (filesIndex != null && filesIndex.getPendingOp() == 0) {
                List<ExternalFile> files = MetadataManager.INSTANCE.getDatasetExternalFiles(this.mdTxnCtx, dataset);
                Iterator<ExternalFile> iterator = files.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().getPendingOp() == DatasetConfig.ExternalFilePendingOp.PENDING_NO_OP) continue;
                    iterator.remove();
                }
            }
            return adapterFactory;
        }
        catch (Exception e) {
            throw new AlgebricksException("Unable to create adapter " + e);
        }
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildExternalDatasetDataScannerRuntime(JobSpecification jobSpec, IAType itemType, IAdapterFactory adapterFactory, IDataFormat format) throws AlgebricksException {
        AlgebricksPartitionConstraint constraint;
        if (itemType.getTypeTag() != ATypeTag.RECORD) {
            throw new AlgebricksException("Can only scan datasets of records.");
        }
        if (!adapterFactory.getSupportedOperations().equals((Object)IAdapterFactory.SupportedOperation.READ) && !adapterFactory.getSupportedOperations().equals((Object)IAdapterFactory.SupportedOperation.READ_WRITE)) {
            throw new AlgebricksException(" External dataset adapter does not support read operation");
        }
        ISerializerDeserializer payloadSerde = format.getSerdeProvider().getSerializerDeserializer((Object)itemType);
        RecordDescriptor scannerDesc = new RecordDescriptor(new ISerializerDeserializer[]{payloadSerde});
        ExternalDataScanOperatorDescriptor dataScanner = new ExternalDataScanOperatorDescriptor(jobSpec, scannerDesc, adapterFactory);
        try {
            constraint = adapterFactory.getPartitionConstraint();
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
        return new Pair((Object)dataScanner, (Object)constraint);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildScannerRuntime(JobSpecification jobSpec, IAType itemType, IParseFileSplitsDecl decl, IDataFormat format) throws AlgebricksException {
        if (itemType.getTypeTag() != ATypeTag.RECORD) {
            throw new AlgebricksException("Can only scan datasets of records.");
        }
        ARecordType rt = (ARecordType)itemType;
        ITupleParserFactory tupleParser = format.createTupleParser(rt, decl);
        FileSplit[] splits = decl.getSplits();
        ConstantFileSplitProvider scannerSplitProvider = new ConstantFileSplitProvider(splits);
        ISerializerDeserializer payloadSerde = format.getSerdeProvider().getSerializerDeserializer((Object)itemType);
        RecordDescriptor scannerDesc = new RecordDescriptor(new ISerializerDeserializer[]{payloadSerde});
        FileScanOperatorDescriptor scanner = new FileScanOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, (IFileSplitProvider)scannerSplitProvider, tupleParser, scannerDesc);
        String[] locs = new String[splits.length];
        for (int i = 0; i < splits.length; ++i) {
            locs[i] = splits[i].getNodeName();
        }
        AlgebricksAbsolutePartitionConstraint apc = new AlgebricksAbsolutePartitionConstraint(locs);
        return new Pair((Object)scanner, (Object)apc);
    }

    public Triple<IOperatorDescriptor, AlgebricksPartitionConstraint, IFeedAdapterFactory> buildFeedIntakeRuntime(JobSpecification jobSpec, PrimaryFeed primaryFeed, FeedPolicyAccessor policyAccessor) throws Exception {
        Triple<IFeedAdapterFactory, ARecordType, DatasourceAdapter.AdapterType> factoryOutput = null;
        factoryOutput = FeedUtil.getPrimaryFeedFactoryAndOutput(primaryFeed, policyAccessor, this.mdTxnCtx);
        IFeedAdapterFactory adapterFactory = (IFeedAdapterFactory)factoryOutput.first;
        FeedIntakeOperatorDescriptor feedIngestor = null;
        switch ((DatasourceAdapter.AdapterType)((Object)factoryOutput.third)) {
            case INTERNAL: {
                feedIngestor = new FeedIntakeOperatorDescriptor(jobSpec, primaryFeed, adapterFactory, (ARecordType)factoryOutput.second, policyAccessor);
                break;
            }
            case EXTERNAL: {
                String libraryName = primaryFeed.getAdaptorName().trim().split("#")[0];
                feedIngestor = new FeedIntakeOperatorDescriptor(jobSpec, primaryFeed, libraryName, adapterFactory.getClass().getName(), (ARecordType)factoryOutput.second, policyAccessor);
            }
        }
        AlgebricksPartitionConstraint partitionConstraint = adapterFactory.getPartitionConstraint();
        return new Triple(feedIngestor, (Object)partitionConstraint, (Object)adapterFactory);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildBtreeRuntime(JobSpecification jobSpec, List<LogicalVariable> outputVars, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, boolean retainInput, boolean retainNull, Dataset dataset, String indexName, int[] lowKeyFields, int[] highKeyFields, boolean lowKeyInclusive, boolean highKeyInclusive, Object implConfig, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes) throws AlgebricksException {
        boolean isSecondary = true;
        int numSecondaryKeys = 0;
        try {
            ExternalBTreeSearchOperatorDescriptor btreeSearchOp;
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> spPc;
            ITypeTraits[] typeTraits;
            IBinaryComparatorFactory[] comparatorFactories;
            int[] bloomFilterKeyFields;
            boolean temp = dataset.getDatasetDetails().isTemp();
            Index primaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName());
            if (primaryIndex != null && dataset.getDatasetType() != DatasetConfig.DatasetType.EXTERNAL) {
                isSecondary = !indexName.equals(primaryIndex.getIndexName());
            }
            int numPrimaryKeys = DatasetUtils.getPartitioningKeys(dataset).size();
            RecordDescriptor outputRecDesc = JobGenHelper.mkRecordDescriptor((IVariableTypeEnvironment)typeEnv, (IOperatorSchema)opSchema, (JobGenContext)context);
            String itemTypeName = dataset.getItemTypeName();
            ARecordType itemType = (ARecordType)MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, dataset.getDataverseName(), itemTypeName).getDatatype();
            ITypeTraits[] filterTypeTraits = DatasetUtils.computeFilterTypeTraits(dataset, itemType);
            IBinaryComparatorFactory[] filterCmpFactories = DatasetUtils.computeFilterBinaryComparatorFactories(dataset, itemType, context.getBinaryComparatorFactoryProvider());
            int[] filterFields = null;
            int[] btreeFields = null;
            if (isSecondary) {
                Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
                numSecondaryKeys = secondaryIndex.getKeyFieldNames().size();
                bloomFilterKeyFields = new int[numSecondaryKeys];
                for (int i = 0; i < numSecondaryKeys; ++i) {
                    bloomFilterKeyFields[i] = i;
                }
                Pair<IBinaryComparatorFactory[], ITypeTraits[]> comparatorFactoriesAndTypeTraits = this.getComparatorFactoriesAndTypeTraitsOfSecondaryBTreeIndex(secondaryIndex.getIndexType(), secondaryIndex.getKeyFieldNames(), secondaryIndex.getKeyFieldTypes(), DatasetUtils.getPartitioningKeys(dataset), itemType, dataset.getDatasetType());
                comparatorFactories = (IBinaryComparatorFactory[])comparatorFactoriesAndTypeTraits.first;
                typeTraits = (ITypeTraits[])comparatorFactoriesAndTypeTraits.second;
                if (filterTypeTraits != null) {
                    filterFields = new int[]{numSecondaryKeys + numPrimaryKeys};
                    btreeFields = new int[numSecondaryKeys + numPrimaryKeys];
                    for (int k = 0; k < btreeFields.length; ++k) {
                        btreeFields[k] = k;
                    }
                }
            } else {
                bloomFilterKeyFields = new int[numPrimaryKeys];
                for (int i = 0; i < numPrimaryKeys; ++i) {
                    bloomFilterKeyFields[i] = i;
                }
                typeTraits = DatasetUtils.computeTupleTypeTraits(dataset, itemType);
                comparatorFactories = DatasetUtils.computeKeysBinaryComparatorFactories(dataset, itemType, context.getBinaryComparatorFactoryProvider());
                filterFields = DatasetUtils.createFilterFields(dataset);
                btreeFields = DatasetUtils.createBTreeFieldsWhenThereisAFilter(dataset);
            }
            IAsterixApplicationContextInfo appContext = (IAsterixApplicationContextInfo)context.getAppContext();
            try {
                spPc = this.splitProviderAndPartitionConstraintsForDataset(dataset.getDataverseName(), dataset.getDatasetName(), indexName, temp);
            }
            catch (Exception e) {
                throw new AlgebricksException((Throwable)e);
            }
            Object searchCallbackFactory = null;
            if (isSecondary) {
                searchCallbackFactory = temp ? NoOpOperationCallbackFactory.INSTANCE : new SecondaryIndexSearchOperationCallbackFactory();
            } else {
                JobId jobId = ((JobEventListenerFactory)jobSpec.getJobletEventListenerFactory()).getJobId();
                int datasetId = dataset.getDatasetId();
                int[] primaryKeyFields = new int[numPrimaryKeys];
                for (int i = 0; i < numPrimaryKeys; ++i) {
                    primaryKeyFields[i] = i;
                }
                AqlMetadataImplConfig aqlMetadataImplConfig = (AqlMetadataImplConfig)implConfig;
                TransactionSubsystemProvider txnSubsystemProvider = new TransactionSubsystemProvider();
                searchCallbackFactory = aqlMetadataImplConfig != null && aqlMetadataImplConfig.isInstantLock() ? (temp ? NoOpOperationCallbackFactory.INSTANCE : new PrimaryIndexInstantSearchOperationCallbackFactory(jobId, datasetId, primaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, 0)) : (temp ? NoOpOperationCallbackFactory.INSTANCE : new PrimaryIndexSearchOperationCallbackFactory(jobId, datasetId, primaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, 0));
            }
            Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtils.getMergePolicyFactory(dataset, this.mdTxnCtx);
            AsterixRuntimeComponentsProvider rtcProvider = AsterixRuntimeComponentsProvider.RUNTIME_PROVIDER;
            if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                btreeSearchOp = new BTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, outputRecDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)spPc.first, typeTraits, comparatorFactories, bloomFilterKeyFields, lowKeyFields, highKeyFields, lowKeyInclusive, highKeyInclusive, (IIndexDataflowHelperFactory)new LSMBTreeDataflowHelperFactory((IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(dataset.getDatasetId()), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)(isSecondary ? new SecondaryIndexOperationTrackerProvider(dataset.getDatasetId()) : new PrimaryIndexOperationTrackerProvider(dataset.getDatasetId())), (ILSMIOOperationSchedulerProvider)rtcProvider, (ILSMIOOperationCallbackFactory)LSMBTreeIOOperationCallbackFactory.INSTANCE, this.storageProperties.getBloomFilterFalsePositiveRate(), !isSecondary, filterTypeTraits, filterCmpFactories, btreeFields, filterFields, !temp), retainInput, retainNull, context.getNullWriterFactory(), (ISearchOperationCallbackFactory)searchCallbackFactory, minFilterFieldIndexes, maxFilterFieldIndexes);
            } else {
                int[] buddyBreeFields = new int[]{numSecondaryKeys};
                ExternalBTreeWithBuddyDataflowHelperFactory indexDataflowHelperFactory = new ExternalBTreeWithBuddyDataflowHelperFactory((ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new SecondaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)AsterixRuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMBTreeWithBuddyIOOperationCallbackFactory.INSTANCE, this.getStorageProperties().getBloomFilterFalsePositiveRate(), buddyBreeFields, ExternalDatasetsRegistry.INSTANCE.getAndLockDatasetVersion(dataset, this), !temp);
                btreeSearchOp = new ExternalBTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, outputRecDesc, (IStorageManagerInterface)rtcProvider, (IIndexLifecycleManagerProvider)rtcProvider, (IFileSplitProvider)spPc.first, typeTraits, comparatorFactories, bloomFilterKeyFields, lowKeyFields, highKeyFields, lowKeyInclusive, highKeyInclusive, (IIndexDataflowHelperFactory)indexDataflowHelperFactory, retainInput, retainNull, context.getNullWriterFactory(), (ISearchOperationCallbackFactory)searchCallbackFactory);
            }
            return new Pair((Object)btreeSearchOp, spPc.second);
        }
        catch (MetadataException me) {
            throw new AlgebricksException((Throwable)((Object)me));
        }
    }

    private Pair<IBinaryComparatorFactory[], ITypeTraits[]> getComparatorFactoriesAndTypeTraitsOfSecondaryBTreeIndex(DatasetConfig.IndexType indexType, List<List<String>> sidxKeyFieldNames, List<IAType> sidxKeyFieldTypes, List<List<String>> pidxKeyFieldNames, ARecordType recType, DatasetConfig.DatasetType dsType) throws AlgebricksException {
        IAType keyType;
        int i;
        int sidxKeyFieldCount = sidxKeyFieldNames.size();
        int pidxKeyFieldCount = pidxKeyFieldNames.size();
        ITypeTraits[] typeTraits = new ITypeTraits[sidxKeyFieldCount + pidxKeyFieldCount];
        IBinaryComparatorFactory[] comparatorFactories = new IBinaryComparatorFactory[sidxKeyFieldCount + pidxKeyFieldCount];
        for (i = 0; i < sidxKeyFieldCount; ++i) {
            Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(sidxKeyFieldTypes.get(i), sidxKeyFieldNames.get(i), recType);
            keyType = (IAType)keyPairType.first;
            comparatorFactories[i] = AqlBinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)keyType, true);
            typeTraits[i] = AqlTypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
        }
        int j = 0;
        while (j < pidxKeyFieldCount) {
            keyType = null;
            try {
                switch (dsType) {
                    case INTERNAL: {
                        keyType = recType.getSubFieldType(pidxKeyFieldNames.get(j));
                        break;
                    }
                    case EXTERNAL: {
                        keyType = IndexingConstants.getFieldType(j);
                        break;
                    }
                    default: {
                        throw new AlgebricksException("Unknown Dataset Type");
                    }
                }
            }
            catch (IOException | AsterixException e) {
                throw new AlgebricksException(e);
            }
            comparatorFactories[i] = AqlBinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)keyType, true);
            typeTraits[i] = AqlTypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
            ++j;
            ++i;
        }
        return new Pair((Object)comparatorFactories, (Object)typeTraits);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> buildRtreeRuntime(JobSpecification jobSpec, List<LogicalVariable> outputVars, IOperatorSchema opSchema, IVariableTypeEnvironment typeEnv, JobGenContext context, boolean retainInput, boolean retainNull, Dataset dataset, String indexName, int[] keyFields, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes) throws AlgebricksException {
        try {
            RTreeSearchOperatorDescriptor rtreeSearchOp;
            NoOpOperationCallbackFactory searchCallbackFactory;
            ARecordType recType = (ARecordType)this.findType(dataset.getDataverseName(), dataset.getItemTypeName());
            int numPrimaryKeys = DatasetUtils.getPartitioningKeys(dataset).size();
            boolean temp = dataset.getDatasetDetails().isTemp();
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            if (secondaryIndex == null) {
                throw new AlgebricksException("Code generation error: no index " + indexName + " for dataset " + dataset.getDatasetName());
            }
            List<List<String>> secondaryKeyFields = secondaryIndex.getKeyFieldNames();
            List<IAType> secondaryKeyTypes = secondaryIndex.getKeyFieldTypes();
            int numSecondaryKeys = secondaryKeyFields.size();
            if (numSecondaryKeys != 1) {
                throw new AlgebricksException("Cannot use " + numSecondaryKeys + " fields as a key for the R-tree index. There can be only one field as a key for the R-tree index.");
            }
            Pair<IAType, Boolean> keyTypePair = Index.getNonNullableOpenFieldType(secondaryKeyTypes.get(0), secondaryKeyFields.get(0), recType);
            IAType keyType = (IAType)keyTypePair.first;
            if (keyType == null) {
                throw new AlgebricksException("Could not find field " + secondaryKeyFields.get(0) + " in the schema.");
            }
            int numDimensions = NonTaggedFormatUtil.getNumDimensions((ATypeTag)keyType.getTypeTag());
            int numNestedSecondaryKeyFields = numDimensions * 2;
            IPrimitiveValueProviderFactory[] valueProviderFactories = new IPrimitiveValueProviderFactory[numNestedSecondaryKeyFields];
            for (int i = 0; i < numNestedSecondaryKeyFields; ++i) {
                valueProviderFactories[i] = AqlPrimitiveValueProviderFactory.INSTANCE;
            }
            RecordDescriptor outputRecDesc = JobGenHelper.mkRecordDescriptor((IVariableTypeEnvironment)typeEnv, (IOperatorSchema)opSchema, (JobGenContext)context);
            int keysStartIndex = outputRecDesc.getFieldCount() - numNestedSecondaryKeyFields - numPrimaryKeys;
            if (retainInput) {
                keysStartIndex -= numNestedSecondaryKeyFields;
            }
            IBinaryComparatorFactory[] comparatorFactories = JobGenHelper.variablesToAscBinaryComparatorFactories(outputVars, (int)keysStartIndex, (int)numNestedSecondaryKeyFields, (IVariableTypeEnvironment)typeEnv, (JobGenContext)context);
            ITypeTraits[] typeTraits = JobGenHelper.variablesToTypeTraits(outputVars, (int)keysStartIndex, (int)(numNestedSecondaryKeyFields + numPrimaryKeys), (IVariableTypeEnvironment)typeEnv, (JobGenContext)context);
            IAsterixApplicationContextInfo appContext = (IAsterixApplicationContextInfo)context.getAppContext();
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> spPc = this.splitProviderAndPartitionConstraintsForDataset(dataset.getDataverseName(), dataset.getDatasetName(), indexName, temp);
            IBinaryComparatorFactory[] primaryComparatorFactories = DatasetUtils.computeKeysBinaryComparatorFactories(dataset, recType, context.getBinaryComparatorFactoryProvider());
            int[] btreeFields = new int[primaryComparatorFactories.length];
            for (int i = 0; i < btreeFields.length; ++i) {
                btreeFields[i] = i + numNestedSecondaryKeyFields;
            }
            ITypeTraits[] filterTypeTraits = DatasetUtils.computeFilterTypeTraits(dataset, recType);
            IBinaryComparatorFactory[] filterCmpFactories = DatasetUtils.computeFilterBinaryComparatorFactories(dataset, recType, context.getBinaryComparatorFactoryProvider());
            int[] filterFields = null;
            int[] rtreeFields = null;
            if (filterTypeTraits != null) {
                filterFields = new int[]{numNestedSecondaryKeyFields + numPrimaryKeys};
                rtreeFields = new int[numNestedSecondaryKeyFields + numPrimaryKeys];
                for (int i = 0; i < rtreeFields.length; ++i) {
                    rtreeFields[i] = i;
                }
            }
            IAType nestedKeyType = NonTaggedFormatUtil.getNestedSpatialType((ATypeTag)keyType.getTypeTag());
            Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtils.getMergePolicyFactory(dataset, this.mdTxnCtx);
            Object object = searchCallbackFactory = temp ? NoOpOperationCallbackFactory.INSTANCE : new SecondaryIndexSearchOperationCallbackFactory();
            if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                rtreeSearchOp = new RTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, outputRecDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)spPc.first, typeTraits, comparatorFactories, keyFields, (IIndexDataflowHelperFactory)new LSMRTreeDataflowHelperFactory(valueProviderFactories, RTreePolicyType.RTREE, primaryComparatorFactories, (IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(dataset.getDatasetId()), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new SecondaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)AsterixRuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMRTreeIOOperationCallbackFactory.INSTANCE, AqlMetadataProvider.proposeLinearizer(nestedKeyType.getTypeTag(), comparatorFactories.length), this.storageProperties.getBloomFilterFalsePositiveRate(), rtreeFields, btreeFields, filterTypeTraits, filterCmpFactories, filterFields, !temp), retainInput, retainNull, context.getNullWriterFactory(), (ISearchOperationCallbackFactory)searchCallbackFactory, minFilterFieldIndexes, maxFilterFieldIndexes);
            } else {
                ExternalRTreeDataflowHelperFactory indexDataflowHelperFactory = new ExternalRTreeDataflowHelperFactory(valueProviderFactories, RTreePolicyType.RTREE, IndexingConstants.getBuddyBtreeComparatorFactories(), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new SecondaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)AsterixRuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMRTreeIOOperationCallbackFactory.INSTANCE, AqlMetadataProvider.proposeLinearizer(nestedKeyType.getTypeTag(), comparatorFactories.length), this.getStorageProperties().getBloomFilterFalsePositiveRate(), new int[]{numNestedSecondaryKeyFields}, ExternalDatasetsRegistry.INSTANCE.getAndLockDatasetVersion(dataset, this), !temp);
                rtreeSearchOp = new ExternalRTreeSearchOperatorDescriptor((IOperatorDescriptorRegistry)jobSpec, outputRecDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)spPc.first, typeTraits, comparatorFactories, keyFields, indexDataflowHelperFactory, retainInput, retainNull, context.getNullWriterFactory(), (ISearchOperationCallbackFactory)searchCallbackFactory);
            }
            return new Pair((Object)rtreeSearchOp, spPc.second);
        }
        catch (MetadataException me) {
            throw new AlgebricksException((Throwable)((Object)me));
        }
    }

    public Pair<IPushRuntimeFactory, AlgebricksPartitionConstraint> getWriteFileRuntime(IDataSink sink, int[] printColumns, IPrinterFactory[] printerFactories, RecordDescriptor inputDesc) {
        FileSplitDataSink fsds = (FileSplitDataSink)sink;
        FileSplitSinkId fssi = fsds.getId();
        FileSplit fs = fssi.getFileSplit();
        File outFile = fs.getLocalFile().getFile();
        String nodeId = fs.getNodeName();
        SinkWriterRuntimeFactory runtime = new SinkWriterRuntimeFactory(printColumns, printerFactories, outFile, this.getWriterFactory(), inputDesc);
        AlgebricksAbsolutePartitionConstraint apc = new AlgebricksAbsolutePartitionConstraint(new String[]{nodeId});
        return new Pair((Object)runtime, (Object)apc);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getResultHandleRuntime(IDataSink sink, int[] printColumns, IPrinterFactory[] printerFactories, RecordDescriptor inputDesc, boolean ordered, JobSpecification spec) throws AlgebricksException {
        ResultSetDataSink rsds = (ResultSetDataSink)sink;
        ResultSetSinkId rssId = rsds.getId();
        ResultSetId rsId = rssId.getResultSetId();
        ResultWriterOperatorDescriptor resultWriter = null;
        try {
            IResultSerializerFactory resultSerializedAppenderFactory = this.resultSerializerFactoryProvider.getAqlResultSerializerFactoryProvider(printColumns, printerFactories, this.getWriterFactory());
            resultWriter = new ResultWriterOperatorDescriptor((IOperatorDescriptorRegistry)spec, rsId, ordered, this.getResultAsyncMode(), resultSerializedAppenderFactory);
        }
        catch (IOException e) {
            throw new AlgebricksException((Throwable)e);
        }
        return new Pair((Object)resultWriter, null);
    }

    public IDataSourceIndex<String, AqlSourceId> findDataSourceIndex(String indexId, AqlSourceId dataSourceId) throws AlgebricksException {
        AqlDataSource ads = this.findDataSource(dataSourceId);
        Dataset dataset = ((DatasetDataSource)ads).getDataset();
        try {
            String indexName = indexId;
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            if (secondaryIndex != null) {
                return new AqlIndex(secondaryIndex, dataset.getDataverseName(), dataset.getDatasetName(), this);
            }
            Index primaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName());
            if (primaryIndex.getIndexName().equals(indexId)) {
                return new AqlIndex(primaryIndex, dataset.getDataverseName(), dataset.getDatasetName(), this);
            }
            return null;
        }
        catch (MetadataException me) {
            throw new AlgebricksException((Throwable)((Object)me));
        }
    }

    public AqlDataSource lookupSourceInMetadata(AqlSourceId aqlId) throws AlgebricksException, MetadataException {
        Dataset dataset = this.findDataset(aqlId.getDataverseName(), aqlId.getDatasourceName());
        if (dataset == null) {
            throw new AlgebricksException("Datasource with id " + aqlId + " was not found.");
        }
        String tName = dataset.getItemTypeName();
        IAType itemType = MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, aqlId.getDataverseName(), tName).getDatatype();
        AqlDataSource.AqlDataSourceType datasourceType = dataset.getDatasetType().equals((Object)DatasetConfig.DatasetType.EXTERNAL) ? AqlDataSource.AqlDataSourceType.EXTERNAL_DATASET : AqlDataSource.AqlDataSourceType.INTERNAL_DATASET;
        return new DatasetDataSource(aqlId, aqlId.getDataverseName(), aqlId.getDatasourceName(), itemType, datasourceType);
    }

    public boolean scannerOperatorIsLeaf(IDataSource<AqlSourceId> dataSource) {
        boolean result = false;
        switch (((AqlDataSource)dataSource).getDatasourceType()) {
            case INTERNAL_DATASET: 
            case EXTERNAL_DATASET: {
                result = ((DatasetDataSource)dataSource).getDataset().getDatasetType() == DatasetConfig.DatasetType.EXTERNAL;
                break;
            }
            case FEED: {
                result = true;
                break;
            }
            case LOADABLE: {
                result = true;
                break;
            }
        }
        return result;
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getWriteResultRuntime(IDataSource<AqlSourceId> dataSource, IOperatorSchema propagatedSchema, List<LogicalVariable> keys, LogicalVariable payload, List<LogicalVariable> additionalNonKeyFields, JobGenContext context, JobSpecification spec) throws AlgebricksException {
        String datasetName;
        String dataverseName = ((AqlSourceId)dataSource.getId()).getDataverseName();
        Dataset dataset = this.findDataset(dataverseName, datasetName = ((AqlSourceId)dataSource.getId()).getDatasourceName());
        if (dataset == null) {
            throw new AlgebricksException("Unknown dataset " + datasetName + " in dataverse " + dataverseName);
        }
        int numKeys = keys.size();
        int numFilterFields = DatasetUtils.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + 1 + numFilterFields];
        int[] bloomFilterKeyFields = new int[numKeys];
        int i = 0;
        for (LogicalVariable varKey : keys) {
            int idx;
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            bloomFilterKeyFields[i] = i;
            ++i;
        }
        fieldPermutation[numKeys] = propagatedSchema.findVariable(payload);
        if (numFilterFields > 0) {
            int idx;
            fieldPermutation[numKeys + 1] = idx = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
        }
        try {
            boolean temp = dataset.getDatasetDetails().isTemp();
            this.isTemporaryDatasetWriteJob = this.isTemporaryDatasetWriteJob && temp;
            Index primaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName());
            String indexName = primaryIndex.getIndexName();
            String itemTypeName = dataset.getItemTypeName();
            ARecordType itemType = (ARecordType)MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, dataset.getDataverseName(), itemTypeName).getDatatype();
            ITypeTraits[] typeTraits = DatasetUtils.computeTupleTypeTraits(dataset, itemType);
            IBinaryComparatorFactory[] comparatorFactories = DatasetUtils.computeKeysBinaryComparatorFactories(dataset, itemType, context.getBinaryComparatorFactoryProvider());
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.splitProviderAndPartitionConstraintsForDataset(((AqlSourceId)dataSource.getId()).getDataverseName(), datasetName, indexName, temp);
            IAsterixApplicationContextInfo appContext = (IAsterixApplicationContextInfo)context.getAppContext();
            long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
            ITypeTraits[] filterTypeTraits = DatasetUtils.computeFilterTypeTraits(dataset, itemType);
            IBinaryComparatorFactory[] filterCmpFactories = DatasetUtils.computeFilterBinaryComparatorFactories(dataset, itemType, context.getBinaryComparatorFactoryProvider());
            int[] filterFields = DatasetUtils.createFilterFields(dataset);
            int[] btreeFields = DatasetUtils.createBTreeFieldsWhenThereisAFilter(dataset);
            Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtils.getMergePolicyFactory(dataset, this.mdTxnCtx);
            TreeIndexBulkLoadOperatorDescriptor btreeBulkLoad = new TreeIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, null, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)splitsAndConstraint.first, typeTraits, comparatorFactories, bloomFilterKeyFields, fieldPermutation, 1.0f, false, numElementsHint, true, (IIndexDataflowHelperFactory)new LSMBTreeDataflowHelperFactory((IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(dataset.getDatasetId()), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new PrimaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)AsterixRuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMBTreeIOOperationCallbackFactory.INSTANCE, this.storageProperties.getBloomFilterFalsePositiveRate(), true, filterTypeTraits, filterCmpFactories, btreeFields, filterFields, !temp));
            return new Pair((Object)btreeBulkLoad, splitsAndConstraint.second);
        }
        catch (MetadataException me) {
            throw new AlgebricksException((Throwable)((Object)me));
        }
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getInsertOrDeleteRuntime(IndexOperation indexOp, IDataSource<AqlSourceId> dataSource, IOperatorSchema propagatedSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> keys, LogicalVariable payload, List<LogicalVariable> additionalNonKeyFields, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, boolean bulkload) throws AlgebricksException {
        String datasetName = ((AqlSourceId)dataSource.getId()).getDatasourceName();
        Dataset dataset = this.findDataset(((AqlSourceId)dataSource.getId()).getDataverseName(), datasetName);
        if (dataset == null) {
            throw new AlgebricksException("Unknown dataset " + datasetName + " in dataverse " + ((AqlSourceId)dataSource.getId()).getDataverseName());
        }
        boolean temp = dataset.getDatasetDetails().isTemp();
        this.isTemporaryDatasetWriteJob = this.isTemporaryDatasetWriteJob && temp;
        int numKeys = keys.size();
        int numFilterFields = DatasetUtils.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + 1 + numFilterFields];
        int[] bloomFilterKeyFields = new int[numKeys];
        int i = 0;
        for (LogicalVariable varKey : keys) {
            int idx;
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            bloomFilterKeyFields[i] = i;
            ++i;
        }
        fieldPermutation[numKeys] = propagatedSchema.findVariable(payload);
        if (numFilterFields > 0) {
            int idx;
            fieldPermutation[numKeys + 1] = idx = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
        }
        try {
            AsterixLSMTreeInsertDeleteOperatorDescriptor op;
            Index primaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), dataset.getDatasetName());
            String indexName = primaryIndex.getIndexName();
            String itemTypeName = dataset.getItemTypeName();
            ARecordType itemType = (ARecordType)MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, ((AqlSourceId)dataSource.getId()).getDataverseName(), itemTypeName).getDatatype();
            ITypeTraits[] typeTraits = DatasetUtils.computeTupleTypeTraits(dataset, itemType);
            IAsterixApplicationContextInfo appContext = (IAsterixApplicationContextInfo)context.getAppContext();
            IBinaryComparatorFactory[] comparatorFactories = DatasetUtils.computeKeysBinaryComparatorFactories(dataset, itemType, context.getBinaryComparatorFactoryProvider());
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.splitProviderAndPartitionConstraintsForDataset(((AqlSourceId)dataSource.getId()).getDataverseName(), datasetName, indexName, temp);
            JobId jobId = ((JobEventListenerFactory)spec.getJobletEventListenerFactory()).getJobId();
            int datasetId = dataset.getDatasetId();
            int[] primaryKeyFields = new int[numKeys];
            for (i = 0; i < numKeys; ++i) {
                primaryKeyFields[i] = i;
            }
            ITypeTraits[] filterTypeTraits = DatasetUtils.computeFilterTypeTraits(dataset, itemType);
            IBinaryComparatorFactory[] filterCmpFactories = DatasetUtils.computeFilterBinaryComparatorFactories(dataset, itemType, context.getBinaryComparatorFactoryProvider());
            int[] filterFields = DatasetUtils.createFilterFields(dataset);
            int[] btreeFields = DatasetUtils.createBTreeFieldsWhenThereisAFilter(dataset);
            TransactionSubsystemProvider txnSubsystemProvider = new TransactionSubsystemProvider();
            IModificationOperationCallbackFactory modificationCallbackFactory = (IModificationOperationCallbackFactory)(temp ? new TempDatasetPrimaryIndexModificationOperationCallbackFactory(jobId, datasetId, primaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, indexOp, 0) : new PrimaryIndexModificationOperationCallbackFactory(jobId, datasetId, primaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, indexOp, 0));
            Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtils.getMergePolicyFactory(dataset, this.mdTxnCtx);
            LSMBTreeDataflowHelperFactory idfh = new LSMBTreeDataflowHelperFactory((IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(datasetId), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new PrimaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)AsterixRuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMBTreeIOOperationCallbackFactory.INSTANCE, this.storageProperties.getBloomFilterFalsePositiveRate(), true, filterTypeTraits, filterCmpFactories, btreeFields, filterFields, !temp);
            if (bulkload) {
                long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
                op = new TreeIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)splitsAndConstraint.first, typeTraits, comparatorFactories, bloomFilterKeyFields, fieldPermutation, 1.0f, true, numElementsHint, true, (IIndexDataflowHelperFactory)idfh);
            } else {
                op = new AsterixLSMTreeInsertDeleteOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)splitsAndConstraint.first, typeTraits, comparatorFactories, bloomFilterKeyFields, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)idfh, null, modificationCallbackFactory, true, indexName);
            }
            return new Pair((Object)op, splitsAndConstraint.second);
        }
        catch (MetadataException me) {
            throw new AlgebricksException((Throwable)((Object)me));
        }
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getInsertRuntime(IDataSource<AqlSourceId> dataSource, IOperatorSchema propagatedSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> keys, LogicalVariable payload, List<LogicalVariable> additionalNonKeyFields, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, boolean bulkload) throws AlgebricksException {
        return this.getInsertOrDeleteRuntime(IndexOperation.INSERT, dataSource, propagatedSchema, typeEnv, keys, payload, additionalNonKeyFields, recordDesc, context, spec, bulkload);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getDeleteRuntime(IDataSource<AqlSourceId> dataSource, IOperatorSchema propagatedSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> keys, LogicalVariable payload, List<LogicalVariable> additionalNonKeyFields, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec) throws AlgebricksException {
        return this.getInsertOrDeleteRuntime(IndexOperation.DELETE, dataSource, propagatedSchema, typeEnv, keys, payload, additionalNonKeyFields, recordDesc, context, spec, false);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexInsertOrDeleteRuntime(IndexOperation indexOp, IDataSourceIndex<String, AqlSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, ILogicalExpression filterExpr, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, boolean bulkload) throws AlgebricksException {
        Index secondaryIndex;
        String datasetName;
        String indexName = (String)dataSourceIndex.getId();
        String dataverseName = ((AqlSourceId)dataSourceIndex.getDataSource().getId()).getDataverseName();
        Dataset dataset = this.findDataset(dataverseName, datasetName = ((AqlSourceId)dataSourceIndex.getDataSource().getId()).getDatasourceName());
        if (dataset == null) {
            throw new AlgebricksException("Unknown dataset " + datasetName);
        }
        try {
            secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)((Object)e));
        }
        AsterixTupleFilterFactory filterFactory = this.createTupleFilterFactory(inputSchemas, typeEnv, filterExpr, context);
        switch (secondaryIndex.getIndexType()) {
            case BTREE: {
                return this.getBTreeDmlRuntime(dataverseName, datasetName, indexName, propagatedSchema, typeEnv, primaryKeys, secondaryKeys, additionalNonKeyFields, filterFactory, recordDesc, context, spec, indexOp, bulkload);
            }
            case RTREE: {
                return this.getRTreeDmlRuntime(dataverseName, datasetName, indexName, propagatedSchema, typeEnv, primaryKeys, secondaryKeys, additionalNonKeyFields, filterFactory, recordDesc, context, spec, indexOp, bulkload);
            }
            case SINGLE_PARTITION_WORD_INVIX: 
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: 
            case LENGTH_PARTITIONED_NGRAM_INVIX: {
                return this.getInvertedIndexDmlRuntime(dataverseName, datasetName, indexName, propagatedSchema, typeEnv, primaryKeys, secondaryKeys, additionalNonKeyFields, filterFactory, recordDesc, context, spec, indexOp, secondaryIndex.getIndexType(), bulkload);
            }
        }
        throw new AlgebricksException("Insert and delete not implemented for index type: " + secondaryIndex.getIndexType());
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexInsertRuntime(IDataSourceIndex<String, AqlSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, ILogicalExpression filterExpr, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, boolean bulkload) throws AlgebricksException {
        return this.getIndexInsertOrDeleteRuntime(IndexOperation.INSERT, dataSourceIndex, propagatedSchema, inputSchemas, typeEnv, primaryKeys, secondaryKeys, additionalNonKeyFields, filterExpr, recordDesc, context, spec, bulkload);
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getTokenizerRuntime(IDataSourceIndex<String, AqlSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, ILogicalExpression filterExpr, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, boolean bulkload) throws AlgebricksException {
        Index secondaryIndex;
        String indexName = (String)dataSourceIndex.getId();
        String dataverseName = ((AqlSourceId)dataSourceIndex.getDataSource().getId()).getDataverseName();
        String datasetName = ((AqlSourceId)dataSourceIndex.getDataSource().getId()).getDatasourceName();
        OperatorSchemaImpl inputSchema = new OperatorSchemaImpl();
        if (inputSchemas.length <= 0) {
            throw new AlgebricksException("TokenizeOperator can not operate without any input variable.");
        }
        inputSchema = inputSchemas[0];
        Dataset dataset = this.findDataset(dataverseName, datasetName);
        if (dataset == null) {
            throw new AlgebricksException("Unknown dataset " + datasetName);
        }
        try {
            secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)((Object)e));
        }
        AsterixTupleFilterFactory filterFactory = this.createTupleFilterFactory(inputSchemas, typeEnv, filterExpr, context);
        switch (secondaryIndex.getIndexType()) {
            case SINGLE_PARTITION_WORD_INVIX: 
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: 
            case LENGTH_PARTITIONED_NGRAM_INVIX: {
                return this.getBinaryTokenizerRuntime(dataverseName, datasetName, indexName, (IOperatorSchema)inputSchema, propagatedSchema, typeEnv, primaryKeys, secondaryKeys, filterFactory, recordDesc, context, spec, IndexOperation.INSERT, secondaryIndex.getIndexType(), bulkload);
            }
        }
        throw new AlgebricksException("Currently, we do not support TokenizeOperator for the index type: " + secondaryIndex.getIndexType());
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getBinaryTokenizerRuntime(String dataverseName, String datasetName, String indexName, IOperatorSchema inputSchema, IOperatorSchema propagatedSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, AsterixTupleFilterFactory filterFactory, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, IndexOperation indexOp, DatasetConfig.IndexType indexType, boolean bulkload) throws AlgebricksException {
        int idx;
        if (primaryKeys.size() > 1) {
            throw new AlgebricksException("Cannot tokenize composite primary key.");
        }
        if (secondaryKeys.size() > 1) {
            throw new AlgebricksException("Cannot tokenize composite secondary key fields.");
        }
        boolean isPartitioned = indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
        int numKeys = inputSchema.getSize();
        ArrayList<LogicalVariable> otherKeys = new ArrayList<LogicalVariable>();
        if (inputSchema.getSize() > 0) {
            for (int k = 0; k < inputSchema.getSize(); ++k) {
                boolean found = false;
                for (LogicalVariable varKey : primaryKeys) {
                    if (varKey.equals((Object)inputSchema.getVariable(k))) {
                        found = true;
                        break;
                    }
                    found = false;
                }
                if (!found) {
                    for (LogicalVariable varKey : secondaryKeys) {
                        if (varKey.equals((Object)inputSchema.getVariable(k))) {
                            found = true;
                            break;
                        }
                        found = false;
                    }
                }
                if (found) continue;
                otherKeys.add(inputSchema.getVariable(k));
            }
        }
        int numTokenKeyPairFields = !isPartitioned ? 1 + numKeys : 2 + numKeys;
        int[] fieldPermutation = new int[numKeys];
        int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
        int i = 0;
        int j = 0;
        for (LogicalVariable varKey : primaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            modificationCallbackPrimaryKeyFields[j] = i++;
            ++j;
        }
        for (LogicalVariable varKey : otherKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            ++i;
        }
        for (LogicalVariable varKey : secondaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            ++i;
        }
        Dataset dataset = this.findDataset(dataverseName, datasetName);
        if (dataset == null) {
            throw new AlgebricksException("Unknown dataset " + datasetName + " in dataverse " + dataverseName);
        }
        String itemTypeName = dataset.getItemTypeName();
        try {
            IAType itemType = MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, dataset.getDataverseName(), itemTypeName).getDatatype();
            if (itemType.getTypeTag() != ATypeTag.RECORD) {
                throw new AlgebricksException("Only record types can be tokenized.");
            }
            ARecordType recType = (ARecordType)itemType;
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            List<List<String>> secondaryKeyExprs = secondaryIndex.getKeyFieldNames();
            int numTokenFields = !isPartitioned ? secondaryKeys.size() : secondaryKeys.size() + 1;
            ITypeTraits[] tokenTypeTraits = new ITypeTraits[numTokenFields];
            ITypeTraits[] invListsTypeTraits = new ITypeTraits[primaryKeys.size()];
            IAType secondaryKeyType = null;
            Pair<IAType, Boolean> keyPairType = Index.getNonNullableKeyFieldType(secondaryKeyExprs.get(0), recType);
            secondaryKeyType = (IAType)keyPairType.first;
            List<List<String>> partitioningKeys = DatasetUtils.getPartitioningKeys(dataset);
            i = 0;
            for (List<String> partitioningKey : partitioningKeys) {
                IAType keyType = recType.getSubFieldType(partitioningKey);
                invListsTypeTraits[i] = AqlTypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
                ++i;
            }
            tokenTypeTraits[0] = NonTaggedFormatUtil.getTokenTypeTrait((IAType)secondaryKeyType);
            if (isPartitioned) {
                tokenTypeTraits[1] = ShortPointable.TYPE_TRAITS;
            }
            IBinaryTokenizerFactory tokenizerFactory = NonTaggedFormatUtil.getBinaryTokenizerFactory((ATypeTag)secondaryKeyType.getTypeTag(), (DatasetConfig.IndexType)indexType, (int)secondaryIndex.getGramLength());
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.splitProviderAndPartitionConstraintsForDataset(dataverseName, datasetName, indexName, dataset.getDatasetDetails().isTemp());
            ISerializerDeserializer[] tokenKeyPairFields = new ISerializerDeserializer[numTokenKeyPairFields];
            ITypeTraits[] tokenKeyPairTypeTraits = new ITypeTraits[numTokenKeyPairFields];
            ISerializerDeserializerProvider serdeProvider = FormatUtils.getDefaultFormat().getSerdeProvider();
            for (int k = 0; k < recordDesc.getFieldCount(); ++k) {
                tokenKeyPairFields[k] = recordDesc.getFields()[k];
                tokenKeyPairTypeTraits[k] = recordDesc.getTypeTraits()[k];
            }
            int tokenOffset = recordDesc.getFieldCount();
            tokenKeyPairFields[tokenOffset] = serdeProvider.getSerializerDeserializer((Object)secondaryKeyType);
            tokenKeyPairTypeTraits[tokenOffset] = tokenTypeTraits[0];
            ++tokenOffset;
            if (isPartitioned) {
                tokenKeyPairFields[tokenOffset] = ShortSerializerDeserializer.INSTANCE;
                tokenKeyPairTypeTraits[tokenOffset] = tokenTypeTraits[1];
            }
            RecordDescriptor tokenKeyPairRecDesc = new RecordDescriptor(tokenKeyPairFields, tokenKeyPairTypeTraits);
            int docField = fieldPermutation[fieldPermutation.length - 1];
            int[] keyFields = new int[numKeys];
            for (int k = 0; k < keyFields.length; ++k) {
                keyFields[k] = k;
            }
            BinaryTokenizerOperatorDescriptor tokenizerOp = new BinaryTokenizerOperatorDescriptor((IOperatorDescriptorRegistry)spec, tokenKeyPairRecDesc, tokenizerFactory, docField, keyFields, isPartitioned, true);
            return new Pair((Object)tokenizerOp, splitsAndConstraint.second);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)((Object)e));
        }
        catch (IOException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    public Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getIndexDeleteRuntime(IDataSourceIndex<String, AqlSourceId> dataSourceIndex, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, ILogicalExpression filterExpr, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec) throws AlgebricksException {
        return this.getIndexInsertOrDeleteRuntime(IndexOperation.DELETE, dataSourceIndex, propagatedSchema, inputSchemas, typeEnv, primaryKeys, secondaryKeys, additionalNonKeyFields, filterExpr, recordDesc, context, spec, false);
    }

    private AsterixTupleFilterFactory createTupleFilterFactory(IOperatorSchema[] inputSchemas, IVariableTypeEnvironment typeEnv, ILogicalExpression filterExpr, JobGenContext context) throws AlgebricksException {
        if (filterExpr == null) {
            return null;
        }
        IExpressionRuntimeProvider expressionRuntimeProvider = context.getExpressionRuntimeProvider();
        IScalarEvaluatorFactory filterEvalFactory = expressionRuntimeProvider.createEvaluatorFactory(filterExpr, typeEnv, inputSchemas, context);
        return new AsterixTupleFilterFactory(filterEvalFactory, context.getBinaryBooleanInspectorFactory());
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getBTreeDmlRuntime(String dataverseName, String datasetName, String indexName, IOperatorSchema propagatedSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, AsterixTupleFilterFactory filterFactory, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, IndexOperation indexOp, boolean bulkload) throws AlgebricksException {
        int idx;
        Dataset dataset = this.findDataset(dataverseName, datasetName);
        if (dataset == null) {
            throw new AlgebricksException("Unknown dataset " + datasetName + " in dataverse " + dataverseName);
        }
        boolean temp = dataset.getDatasetDetails().isTemp();
        this.isTemporaryDatasetWriteJob = this.isTemporaryDatasetWriteJob && temp;
        int numKeys = primaryKeys.size() + secondaryKeys.size();
        int numFilterFields = DatasetUtils.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + numFilterFields];
        int[] bloomFilterKeyFields = new int[secondaryKeys.size()];
        int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
        int i = 0;
        int j = 0;
        for (LogicalVariable varKey : secondaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            bloomFilterKeyFields[i] = i;
            ++i;
        }
        for (LogicalVariable varKey : primaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            modificationCallbackPrimaryKeyFields[j] = i++;
            ++j;
        }
        if (numFilterFields > 0) {
            int idx2;
            fieldPermutation[numKeys] = idx2 = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
        }
        String itemTypeName = dataset.getItemTypeName();
        try {
            TreeIndexBulkLoadOperatorDescriptor op;
            IAType itemType = MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, dataset.getDataverseName(), itemTypeName).getDatatype();
            if (itemType.getTypeTag() != ATypeTag.RECORD) {
                throw new AlgebricksException("Only record types can be indexed.");
            }
            ARecordType recType = (ARecordType)itemType;
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            ITypeTraits[] filterTypeTraits = DatasetUtils.computeFilterTypeTraits(dataset, recType);
            IBinaryComparatorFactory[] filterCmpFactories = DatasetUtils.computeFilterBinaryComparatorFactories(dataset, recType, context.getBinaryComparatorFactoryProvider());
            int[] filterFields = null;
            int[] btreeFields = null;
            if (filterTypeTraits != null) {
                filterFields = new int[]{numKeys};
                btreeFields = new int[numKeys];
                for (int k = 0; k < btreeFields.length; ++k) {
                    btreeFields[k] = k;
                }
            }
            List<List<String>> secondaryKeyNames = secondaryIndex.getKeyFieldNames();
            List<IAType> secondaryKeyTypes = secondaryIndex.getKeyFieldTypes();
            ITypeTraits[] typeTraits = new ITypeTraits[numKeys];
            IBinaryComparatorFactory[] comparatorFactories = new IBinaryComparatorFactory[numKeys];
            for (i = 0; i < secondaryKeys.size(); ++i) {
                Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(secondaryKeyTypes.get(i), secondaryKeyNames.get(i), recType);
                IAType keyType = (IAType)keyPairType.first;
                comparatorFactories[i] = AqlBinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)keyType, true);
                typeTraits[i] = AqlTypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
            }
            List<List<String>> partitioningKeys = DatasetUtils.getPartitioningKeys(dataset);
            for (List<String> partitioningKey : partitioningKeys) {
                IAType keyType = recType.getSubFieldType(partitioningKey);
                comparatorFactories[i] = AqlBinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)keyType, true);
                typeTraits[i] = AqlTypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
                ++i;
            }
            IAsterixApplicationContextInfo appContext = (IAsterixApplicationContextInfo)context.getAppContext();
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.splitProviderAndPartitionConstraintsForDataset(dataverseName, datasetName, indexName, temp);
            JobId jobId = ((JobEventListenerFactory)spec.getJobletEventListenerFactory()).getJobId();
            int datasetId = dataset.getDatasetId();
            TransactionSubsystemProvider txnSubsystemProvider = new TransactionSubsystemProvider();
            IModificationOperationCallbackFactory modificationCallbackFactory = (IModificationOperationCallbackFactory)(temp ? new TempDatasetSecondaryIndexModificationOperationCallbackFactory(jobId, datasetId, modificationCallbackPrimaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, indexOp, 0) : new SecondaryIndexModificationOperationCallbackFactory(jobId, datasetId, modificationCallbackPrimaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, indexOp, 0));
            Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtils.getMergePolicyFactory(dataset, this.mdTxnCtx);
            LSMBTreeDataflowHelperFactory idfh = new LSMBTreeDataflowHelperFactory((IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(datasetId), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new SecondaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)AsterixRuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMBTreeIOOperationCallbackFactory.INSTANCE, this.storageProperties.getBloomFilterFalsePositiveRate(), false, filterTypeTraits, filterCmpFactories, btreeFields, filterFields, !temp);
            if (bulkload) {
                long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
                op = new TreeIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)splitsAndConstraint.first, typeTraits, comparatorFactories, bloomFilterKeyFields, fieldPermutation, 1.0f, false, numElementsHint, false, (IIndexDataflowHelperFactory)idfh);
            } else {
                op = new AsterixLSMTreeInsertDeleteOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)splitsAndConstraint.first, typeTraits, comparatorFactories, bloomFilterKeyFields, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)new LSMBTreeDataflowHelperFactory((IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(datasetId), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new SecondaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)AsterixRuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMBTreeIOOperationCallbackFactory.INSTANCE, this.storageProperties.getBloomFilterFalsePositiveRate(), false, filterTypeTraits, filterCmpFactories, btreeFields, filterFields, !temp), (ITupleFilterFactory)filterFactory, modificationCallbackFactory, false, indexName);
            }
            return new Pair((Object)op, splitsAndConstraint.second);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)((Object)e));
        }
        catch (IOException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getInvertedIndexDmlRuntime(String dataverseName, String datasetName, String indexName, IOperatorSchema propagatedSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, AsterixTupleFilterFactory filterFactory, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, IndexOperation indexOp, DatasetConfig.IndexType indexType, boolean bulkload) throws AlgebricksException {
        int idx;
        boolean isPartitioned = indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_WORD_INVIX || indexType == DatasetConfig.IndexType.LENGTH_PARTITIONED_NGRAM_INVIX;
        if (primaryKeys.size() > 1) {
            throw new AlgebricksException("Cannot create inverted index on dataset with composite primary key.");
        }
        if (secondaryKeys.size() > 1 && !isPartitioned) {
            throw new AlgebricksException("Cannot create composite inverted index on multiple fields.");
        }
        if (secondaryKeys.size() > 2 && isPartitioned) {
            throw new AlgebricksException("Cannot create composite inverted index on multiple fields.");
        }
        Dataset dataset = this.findDataset(dataverseName, datasetName);
        if (dataset == null) {
            throw new AlgebricksException("Unknown dataset " + datasetName + " in dataverse " + dataverseName);
        }
        boolean temp = dataset.getDatasetDetails().isTemp();
        this.isTemporaryDatasetWriteJob = this.isTemporaryDatasetWriteJob && temp;
        int numKeys = primaryKeys.size() + secondaryKeys.size();
        int numTokenKeyPairFields = !isPartitioned ? 1 + primaryKeys.size() : 2 + primaryKeys.size();
        int numFilterFields = DatasetUtils.getFilterField(dataset) == null ? 0 : 1;
        int[] fieldPermutation = new int[numKeys + numFilterFields];
        int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
        int i = 0;
        int j = 0;
        for (LogicalVariable varKey : secondaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            ++i;
        }
        for (LogicalVariable varKey : primaryKeys) {
            fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
            modificationCallbackPrimaryKeyFields[j] = i++;
            ++j;
        }
        if (numFilterFields > 0) {
            int idx2;
            fieldPermutation[numKeys] = idx2 = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
        }
        String itemTypeName = dataset.getItemTypeName();
        try {
            AsterixLSMInvertedIndexInsertDeleteOperatorDescriptor op;
            IAType itemType = MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, dataset.getDataverseName(), itemTypeName).getDatatype();
            if (itemType.getTypeTag() != ATypeTag.RECORD) {
                throw new AlgebricksException("Only record types can be indexed.");
            }
            ARecordType recType = (ARecordType)itemType;
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            List<List<String>> secondaryKeyExprs = secondaryIndex.getKeyFieldNames();
            List<IAType> secondaryKeyTypes = secondaryIndex.getKeyFieldTypes();
            int numTokenFields = 0;
            if (!isPartitioned || secondaryKeys.size() > 1) {
                numTokenFields = secondaryKeys.size();
            } else if (isPartitioned && secondaryKeys.size() == 1) {
                numTokenFields = secondaryKeys.size() + 1;
            }
            ITypeTraits[] tokenTypeTraits = new ITypeTraits[numTokenFields];
            ITypeTraits[] invListsTypeTraits = new ITypeTraits[primaryKeys.size()];
            IBinaryComparatorFactory[] tokenComparatorFactories = new IBinaryComparatorFactory[numTokenFields];
            IBinaryComparatorFactory[] invListComparatorFactories = DatasetUtils.computeKeysBinaryComparatorFactories(dataset, recType, context.getBinaryComparatorFactoryProvider());
            IAType secondaryKeyType = null;
            Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(secondaryKeyTypes.get(0), secondaryKeyExprs.get(0), recType);
            secondaryKeyType = (IAType)keyPairType.first;
            List<List<String>> partitioningKeys = DatasetUtils.getPartitioningKeys(dataset);
            i = 0;
            for (List<String> partitioningKey : partitioningKeys) {
                IAType keyType = recType.getSubFieldType(partitioningKey);
                invListsTypeTraits[i] = AqlTypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
                ++i;
            }
            tokenComparatorFactories[0] = NonTaggedFormatUtil.getTokenBinaryComparatorFactory((IAType)secondaryKeyType);
            tokenTypeTraits[0] = NonTaggedFormatUtil.getTokenTypeTrait((IAType)secondaryKeyType);
            if (isPartitioned) {
                tokenComparatorFactories[1] = PointableBinaryComparatorFactory.of((IPointableFactory)ShortPointable.FACTORY);
                tokenTypeTraits[1] = ShortPointable.TYPE_TRAITS;
            }
            IBinaryTokenizerFactory tokenizerFactory = NonTaggedFormatUtil.getBinaryTokenizerFactory((ATypeTag)secondaryKeyType.getTypeTag(), (DatasetConfig.IndexType)indexType, (int)secondaryIndex.getGramLength());
            ITypeTraits[] filterTypeTraits = DatasetUtils.computeFilterTypeTraits(dataset, recType);
            IBinaryComparatorFactory[] filterCmpFactories = DatasetUtils.computeFilterBinaryComparatorFactories(dataset, recType, context.getBinaryComparatorFactoryProvider());
            int[] filterFields = null;
            int[] invertedIndexFields = null;
            int[] filterFieldsForNonBulkLoadOps = null;
            int[] invertedIndexFieldsForNonBulkLoadOps = null;
            if (filterTypeTraits != null) {
                int k;
                filterFields = new int[]{numTokenFields + primaryKeys.size()};
                invertedIndexFields = new int[numTokenFields + primaryKeys.size()];
                for (k = 0; k < invertedIndexFields.length; ++k) {
                    invertedIndexFields[k] = k;
                }
                filterFieldsForNonBulkLoadOps = new int[numFilterFields];
                filterFieldsForNonBulkLoadOps[0] = numTokenKeyPairFields;
                invertedIndexFieldsForNonBulkLoadOps = new int[numTokenKeyPairFields];
                for (k = 0; k < invertedIndexFieldsForNonBulkLoadOps.length; ++k) {
                    invertedIndexFieldsForNonBulkLoadOps[k] = k;
                }
            }
            IAsterixApplicationContextInfo appContext = (IAsterixApplicationContextInfo)context.getAppContext();
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.splitProviderAndPartitionConstraintsForDataset(dataverseName, datasetName, indexName, temp);
            JobId jobId = ((JobEventListenerFactory)spec.getJobletEventListenerFactory()).getJobId();
            int datasetId = dataset.getDatasetId();
            TransactionSubsystemProvider txnSubsystemProvider = new TransactionSubsystemProvider();
            IModificationOperationCallbackFactory modificationCallbackFactory = (IModificationOperationCallbackFactory)(temp ? new TempDatasetSecondaryIndexModificationOperationCallbackFactory(jobId, datasetId, modificationCallbackPrimaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, indexOp, 2) : new SecondaryIndexModificationOperationCallbackFactory(jobId, datasetId, modificationCallbackPrimaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, indexOp, 2));
            Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtils.getMergePolicyFactory(dataset, this.mdTxnCtx);
            Object indexDataFlowFactory = !isPartitioned ? new LSMInvertedIndexDataflowHelperFactory((IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(datasetId), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new SecondaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)AsterixRuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMInvertedIndexIOOperationCallbackFactory.INSTANCE, this.storageProperties.getBloomFilterFalsePositiveRate(), invertedIndexFields, filterTypeTraits, filterCmpFactories, filterFields, filterFieldsForNonBulkLoadOps, invertedIndexFieldsForNonBulkLoadOps, !temp) : new PartitionedLSMInvertedIndexDataflowHelperFactory((IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(dataset.getDatasetId()), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new SecondaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)AsterixRuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMInvertedIndexIOOperationCallbackFactory.INSTANCE, this.storageProperties.getBloomFilterFalsePositiveRate(), invertedIndexFields, filterTypeTraits, filterCmpFactories, filterFields, filterFieldsForNonBulkLoadOps, invertedIndexFieldsForNonBulkLoadOps, !temp);
            if (bulkload) {
                long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
                op = new LSMInvertedIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, fieldPermutation, false, numElementsHint, false, appContext.getStorageManagerInterface(), (IFileSplitProvider)splitsAndConstraint.first, appContext.getIndexLifecycleManagerProvider(), tokenTypeTraits, tokenComparatorFactories, invListsTypeTraits, invListComparatorFactories, tokenizerFactory, (IIndexDataflowHelperFactory)indexDataFlowFactory);
            } else {
                op = new AsterixLSMInvertedIndexInsertDeleteOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, appContext.getStorageManagerInterface(), (IFileSplitProvider)splitsAndConstraint.first, appContext.getIndexLifecycleManagerProvider(), tokenTypeTraits, tokenComparatorFactories, invListsTypeTraits, invListComparatorFactories, tokenizerFactory, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)indexDataFlowFactory, (ITupleFilterFactory)filterFactory, modificationCallbackFactory, indexName);
            }
            return new Pair((Object)op, splitsAndConstraint.second);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)((Object)e));
        }
        catch (IOException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> getRTreeDmlRuntime(String dataverseName, String datasetName, String indexName, IOperatorSchema propagatedSchema, IVariableTypeEnvironment typeEnv, List<LogicalVariable> primaryKeys, List<LogicalVariable> secondaryKeys, List<LogicalVariable> additionalNonKeyFields, AsterixTupleFilterFactory filterFactory, RecordDescriptor recordDesc, JobGenContext context, JobSpecification spec, IndexOperation indexOp, boolean bulkload) throws AlgebricksException {
        try {
            TreeIndexBulkLoadOperatorDescriptor op;
            int idx;
            Dataset dataset = MetadataManager.INSTANCE.getDataset(this.mdTxnCtx, dataverseName, datasetName);
            boolean temp = dataset.getDatasetDetails().isTemp();
            this.isTemporaryDatasetWriteJob = this.isTemporaryDatasetWriteJob && temp;
            String itemTypeName = dataset.getItemTypeName();
            IAType itemType = MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, dataverseName, itemTypeName).getDatatype();
            if (itemType.getTypeTag() != ATypeTag.RECORD) {
                throw new AlgebricksException("Only record types can be indexed.");
            }
            ARecordType recType = (ARecordType)itemType;
            Index secondaryIndex = MetadataManager.INSTANCE.getIndex(this.mdTxnCtx, dataset.getDataverseName(), dataset.getDatasetName(), indexName);
            List<List<String>> secondaryKeyExprs = secondaryIndex.getKeyFieldNames();
            List<IAType> secondaryKeyTypes = secondaryIndex.getKeyFieldTypes();
            Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(secondaryKeyTypes.get(0), secondaryKeyExprs.get(0), recType);
            IAType spatialType = (IAType)keyPairType.first;
            int dimension = NonTaggedFormatUtil.getNumDimensions((ATypeTag)spatialType.getTypeTag());
            int numSecondaryKeys = dimension * 2;
            int numPrimaryKeys = primaryKeys.size();
            int numKeys = numSecondaryKeys + numPrimaryKeys;
            ITypeTraits[] typeTraits = new ITypeTraits[numKeys];
            IBinaryComparatorFactory[] comparatorFactories = new IBinaryComparatorFactory[numSecondaryKeys];
            int numFilterFields = DatasetUtils.getFilterField(dataset) == null ? 0 : 1;
            int[] fieldPermutation = new int[numKeys + numFilterFields];
            int[] modificationCallbackPrimaryKeyFields = new int[primaryKeys.size()];
            int i = 0;
            int j = 0;
            for (LogicalVariable varKey : secondaryKeys) {
                fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
                ++i;
            }
            for (LogicalVariable varKey : primaryKeys) {
                fieldPermutation[i] = idx = propagatedSchema.findVariable(varKey);
                modificationCallbackPrimaryKeyFields[j] = i++;
                ++j;
            }
            if (numFilterFields > 0) {
                int idx2;
                fieldPermutation[numKeys] = idx2 = propagatedSchema.findVariable(additionalNonKeyFields.get(0));
            }
            IAType nestedKeyType = NonTaggedFormatUtil.getNestedSpatialType((ATypeTag)spatialType.getTypeTag());
            IPrimitiveValueProviderFactory[] valueProviderFactories = new IPrimitiveValueProviderFactory[numSecondaryKeys];
            for (i = 0; i < numSecondaryKeys; ++i) {
                comparatorFactories[i] = AqlBinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)nestedKeyType, true);
                typeTraits[i] = AqlTypeTraitProvider.INSTANCE.getTypeTrait((Object)nestedKeyType);
                valueProviderFactories[i] = AqlPrimitiveValueProviderFactory.INSTANCE;
            }
            List<List<String>> partitioningKeys = DatasetUtils.getPartitioningKeys(dataset);
            for (List<String> partitioningKey : partitioningKeys) {
                IAType keyType = recType.getSubFieldType(partitioningKey);
                typeTraits[i] = AqlTypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
                ++i;
            }
            IBinaryComparatorFactory[] primaryComparatorFactories = DatasetUtils.computeKeysBinaryComparatorFactories(dataset, recType, context.getBinaryComparatorFactoryProvider());
            IAsterixApplicationContextInfo appContext = (IAsterixApplicationContextInfo)context.getAppContext();
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitsAndConstraint = this.splitProviderAndPartitionConstraintsForDataset(dataverseName, datasetName, indexName, temp);
            int[] btreeFields = new int[primaryComparatorFactories.length];
            for (int k = 0; k < btreeFields.length; ++k) {
                btreeFields[k] = k + numSecondaryKeys;
            }
            ITypeTraits[] filterTypeTraits = DatasetUtils.computeFilterTypeTraits(dataset, recType);
            IBinaryComparatorFactory[] filterCmpFactories = DatasetUtils.computeFilterBinaryComparatorFactories(dataset, recType, context.getBinaryComparatorFactoryProvider());
            int[] filterFields = null;
            int[] rtreeFields = null;
            if (filterTypeTraits != null) {
                filterFields = new int[]{numSecondaryKeys + numPrimaryKeys};
                rtreeFields = new int[numSecondaryKeys + numPrimaryKeys];
                for (int k = 0; k < rtreeFields.length; ++k) {
                    rtreeFields[k] = k;
                }
            }
            JobId jobId = ((JobEventListenerFactory)spec.getJobletEventListenerFactory()).getJobId();
            int datasetId = dataset.getDatasetId();
            TransactionSubsystemProvider txnSubsystemProvider = new TransactionSubsystemProvider();
            IModificationOperationCallbackFactory modificationCallbackFactory = (IModificationOperationCallbackFactory)(temp ? new TempDatasetSecondaryIndexModificationOperationCallbackFactory(jobId, datasetId, modificationCallbackPrimaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, indexOp, 1) : new SecondaryIndexModificationOperationCallbackFactory(jobId, datasetId, modificationCallbackPrimaryKeyFields, (ITransactionSubsystemProvider)txnSubsystemProvider, indexOp, 1));
            Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtils.getMergePolicyFactory(dataset, this.mdTxnCtx);
            LSMRTreeDataflowHelperFactory idfh = new LSMRTreeDataflowHelperFactory(valueProviderFactories, RTreePolicyType.RTREE, primaryComparatorFactories, (IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(dataset.getDatasetId()), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new SecondaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)AsterixRuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMRTreeIOOperationCallbackFactory.INSTANCE, AqlMetadataProvider.proposeLinearizer(nestedKeyType.getTypeTag(), comparatorFactories.length), this.storageProperties.getBloomFilterFalsePositiveRate(), rtreeFields, btreeFields, filterTypeTraits, filterCmpFactories, filterFields, !temp);
            if (bulkload) {
                long numElementsHint = this.getCardinalityPerPartitionHint(dataset);
                op = new TreeIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)splitsAndConstraint.first, typeTraits, primaryComparatorFactories, btreeFields, fieldPermutation, 1.0f, false, numElementsHint, false, (IIndexDataflowHelperFactory)idfh);
            } else {
                op = new AsterixLSMTreeInsertDeleteOperatorDescriptor((IOperatorDescriptorRegistry)spec, recordDesc, appContext.getStorageManagerInterface(), appContext.getIndexLifecycleManagerProvider(), (IFileSplitProvider)splitsAndConstraint.first, typeTraits, comparatorFactories, null, fieldPermutation, indexOp, (IIndexDataflowHelperFactory)new LSMRTreeDataflowHelperFactory(valueProviderFactories, RTreePolicyType.RTREE, primaryComparatorFactories, (IVirtualBufferCacheProvider)new AsterixVirtualBufferCacheProvider(dataset.getDatasetId()), (ILSMMergePolicyFactory)compactionInfo.first, (Map)compactionInfo.second, (ILSMOperationTrackerProvider)new SecondaryIndexOperationTrackerProvider(dataset.getDatasetId()), (ILSMIOOperationSchedulerProvider)AsterixRuntimeComponentsProvider.RUNTIME_PROVIDER, (ILSMIOOperationCallbackFactory)LSMRTreeIOOperationCallbackFactory.INSTANCE, AqlMetadataProvider.proposeLinearizer(nestedKeyType.getTypeTag(), comparatorFactories.length), this.storageProperties.getBloomFilterFalsePositiveRate(), rtreeFields, btreeFields, filterTypeTraits, filterCmpFactories, filterFields, !temp), (ITupleFilterFactory)filterFactory, modificationCallbackFactory, false, indexName);
            }
            return new Pair((Object)op, splitsAndConstraint.second);
        }
        catch (IOException | MetadataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public static ITreeIndexFrameFactory createBTreeNSMInteriorFrameFactory(ITypeTraits[] typeTraits) {
        return new BTreeNSMInteriorFrameFactory((ITreeIndexTupleWriterFactory)new TypeAwareTupleWriterFactory(typeTraits));
    }

    public static ILinearizeComparatorFactory proposeLinearizer(ATypeTag keyType, int numKeyFields) throws AlgebricksException {
        return AqlLinearizeComparatorFactoryProvider.INSTANCE.getLinearizeComparatorFactory((Object)keyType, true, numKeyFields / 2);
    }

    public long getCardinalityPerPartitionHint(Dataset dataset) throws MetadataException, AlgebricksException {
        String numElementsHintString = dataset.getHints().get("CARDINALITY");
        long numElementsHint = numElementsHintString == null ? 1000000L : Long.parseLong(numElementsHintString);
        int numPartitions = 0;
        List<String> nodeGroup = MetadataManager.INSTANCE.getNodegroup(this.mdTxnCtx, dataset.getNodeGroupName()).getNodeNames();
        for (String nd : nodeGroup) {
            numPartitions += AsterixClusterProperties.INSTANCE.getNumberOfIODevices(nd);
        }
        return numElementsHint /= (long)numPartitions;
    }

    public IFunctionInfo lookupFunction(FunctionIdentifier fid) {
        return AsterixBuiltinFunctions.lookupFunction((FunctionIdentifier)fid);
    }

    public Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitProviderAndPartitionConstraintsForDataset(String dataverseName, String datasetName, String targetIdxName, boolean temp) throws AlgebricksException {
        FileSplit[] splits = this.splitsForDataset(this.mdTxnCtx, dataverseName, datasetName, targetIdxName, temp);
        return this.splitProviderAndPartitionConstraints(splits);
    }

    public Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitProviderAndPartitionConstraintsForDataverse(String dataverse) {
        FileSplit[] splits = this.splitsForDataverse(this.mdTxnCtx, dataverse);
        return this.splitProviderAndPartitionConstraints(splits);
    }

    private Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitProviderAndPartitionConstraints(FileSplit[] splits) {
        ConstantFileSplitProvider splitProvider = new ConstantFileSplitProvider(splits);
        String[] loc = new String[splits.length];
        for (int p = 0; p < splits.length; ++p) {
            loc[p] = splits[p].getNodeName();
        }
        AlgebricksAbsolutePartitionConstraint pc = new AlgebricksAbsolutePartitionConstraint(loc);
        return new Pair((Object)splitProvider, (Object)pc);
    }

    private FileSplit[] splitsForDataverse(MetadataTransactionContext mdTxnCtx, String dataverseName) {
        File relPathFile = new File(dataverseName);
        ArrayList<FileSplit> splits = new ArrayList<FileSplit>();
        for (Map.Entry<String, String[]> entry : this.stores.entrySet()) {
            String node = entry.getKey();
            String[] nodeStores = entry.getValue();
            if (nodeStores == null) continue;
            for (int i = 0; i < nodeStores.length; ++i) {
                int numIODevices = AsterixClusterProperties.INSTANCE.getNumberOfIODevices(node);
                String[] ioDevices = AsterixClusterProperties.INSTANCE.getIODevices(node);
                for (int j = 0; j < nodeStores.length; ++j) {
                    for (int k = 0; k < numIODevices; ++k) {
                        File f = new File(ioDevices[k] + File.separator + nodeStores[j] + File.separator + relPathFile);
                        splits.add(new FileSplit(node, new FileReference(f), k));
                    }
                }
            }
        }
        return splits.toArray(new FileSplit[0]);
    }

    public FileSplit[] splitsForDataset(MetadataTransactionContext mdTxnCtx, String dataverseName, String datasetName, String targetIdxName, boolean temp) throws AlgebricksException {
        try {
            File relPathFile = new File(AqlMetadataProvider.getRelativePath(dataverseName, datasetName + "_idx_" + targetIdxName));
            Dataset dataset = MetadataManager.INSTANCE.getDataset(mdTxnCtx, dataverseName, datasetName);
            List<String> nodeGroup = MetadataManager.INSTANCE.getNodegroup(mdTxnCtx, dataset.getNodeGroupName()).getNodeNames();
            if (nodeGroup == null) {
                throw new AlgebricksException("Couldn't find node group " + dataset.getNodeGroupName());
            }
            ArrayList<FileSplit> splitArray = new ArrayList<FileSplit>();
            for (String nd : nodeGroup) {
                String[] nodeStores = this.stores.get(nd);
                if (nodeStores == null) {
                    LOGGER.warning("Node " + nd + " has no stores.");
                    throw new AlgebricksException("Node " + nd + " has no stores.");
                }
                int numIODevices = dataset.getNodeGroupName().compareTo("MetadataGroup") == 0 ? 1 : AsterixClusterProperties.INSTANCE.getNumberOfIODevices(nd);
                String[] ioDevices = AsterixClusterProperties.INSTANCE.getIODevices(nd);
                for (int j = 0; j < nodeStores.length; ++j) {
                    for (int k = 0; k < numIODevices; ++k) {
                        File f = new File(ioDevices[k] + File.separator + nodeStores[j] + (temp ? File.separator + "temp" : "") + File.separator + relPathFile);
                        splitArray.add(new FileSplit(nd, new FileReference(f), k));
                    }
                }
            }
            return splitArray.toArray(new FileSplit[0]);
        }
        catch (MetadataException me) {
            throw new AlgebricksException((Throwable)((Object)me));
        }
    }

    private static Map<String, String> initializeAdapterFactoryMapping() {
        HashMap<String, String> adapterFactoryMapping = new HashMap<String, String>();
        adapterFactoryMapping.put("org.apache.asterix.external.dataset.adapter.NCFileSystemAdapter", "org.apache.asterix.external.adapter.factory.NCFileSystemAdapterFactory");
        adapterFactoryMapping.put("org.apache.asterix.external.dataset.adapter.HDFSAdapter", "org.apache.asterix.external.adapter.factory.HDFSAdapterFactory");
        adapterFactoryMapping.put("org.apache.asterix.external.dataset.adapter.PullBasedTwitterAdapter", "org.apache.asterix.external.dataset.adapter.PullBasedTwitterAdapterFactory");
        adapterFactoryMapping.put("org.apache.asterix.external.dataset.adapter.RSSFeedAdapter", "org.apache.asterix.external.dataset.adapter..RSSFeedAdapterFactory");
        adapterFactoryMapping.put("org.apache.asterix.external.dataset.adapter.CNNFeedAdapter", "org.apache.asterix.external.dataset.adapter.CNNFeedAdapterFactory");
        adapterFactoryMapping.put("org.apache.asterix.tools.external.data.RateControlledFileSystemBasedAdapter", "org.apache.asterix.tools.external.data.RateControlledFileSystemBasedAdapterFactory");
        return adapterFactoryMapping;
    }

    public DatasourceAdapter getAdapter(MetadataTransactionContext mdTxnCtx, String dataverseName, String adapterName) throws MetadataException {
        DatasourceAdapter adapter = null;
        adapter = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, "Metadata", adapterName);
        if (adapter == null) {
            adapter = MetadataManager.INSTANCE.getAdapter(mdTxnCtx, dataverseName, adapterName);
        }
        return adapter;
    }

    private static String getRelativePath(String dataverseName, String fileName) {
        return dataverseName + File.separator + fileName;
    }

    public Dataset findDataset(String dataverse, String dataset) throws AlgebricksException {
        try {
            return MetadataManager.INSTANCE.getDataset(this.mdTxnCtx, dataverse, dataset);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)((Object)e));
        }
    }

    public IAType findType(String dataverse, String typeName) throws AlgebricksException {
        Datatype type;
        try {
            type = MetadataManager.INSTANCE.getDatatype(this.mdTxnCtx, dataverse, typeName);
        }
        catch (MetadataException e) {
            throw new AlgebricksException("Metadata exception while looking up type '" + typeName + "' in dataverse '" + dataverse + "'", (Throwable)((Object)e));
        }
        if (type == null) {
            throw new AlgebricksException("Type name '" + typeName + "' unknown in dataverse '" + dataverse + "'");
        }
        return type.getDatatype();
    }

    public Feed findFeed(String dataverse, String feedName) throws AlgebricksException {
        try {
            return MetadataManager.INSTANCE.getFeed(this.mdTxnCtx, dataverse, feedName);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)((Object)e));
        }
    }

    public FeedPolicy findFeedPolicy(String dataverse, String policyName) throws AlgebricksException {
        try {
            return MetadataManager.INSTANCE.getFeedPolicy(this.mdTxnCtx, dataverse, policyName);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)((Object)e));
        }
    }

    public List<Index> getDatasetIndexes(String dataverseName, String datasetName) throws AlgebricksException {
        try {
            return MetadataManager.INSTANCE.getDatasetIndexes(this.mdTxnCtx, dataverseName, datasetName);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)((Object)e));
        }
    }

    public AlgebricksPartitionConstraint getClusterLocations() {
        ArrayList<String> locs = new ArrayList<String>();
        for (String i : this.stores.keySet()) {
            String[] nodeStores = this.stores.get(i);
            int numIODevices = AsterixClusterProperties.INSTANCE.getNumberOfIODevices(i);
            for (int j = 0; j < nodeStores.length; ++j) {
                for (int k = 0; k < numIODevices; ++k) {
                    locs.add(i);
                }
            }
        }
        String[] cluster = new String[locs.size()];
        cluster = locs.toArray(cluster);
        return new AlgebricksAbsolutePartitionConstraint(cluster);
    }

    public IDataFormat getFormat() {
        return FormatUtils.getDefaultFormat();
    }

    private Map<String, Object> wrapProperties(Map<String, String> properties) {
        HashMap<String, Object> wrappedProperties = new HashMap<String, Object>();
        wrappedProperties.putAll(properties);
        return wrappedProperties;
    }

    private Map<String, Object> wrapPropertiesEmpty(Map<String, String> properties) {
        HashMap<String, Object> wrappedProperties = new HashMap<String, Object>();
        wrappedProperties.putAll(properties);
        return wrappedProperties;
    }

    public Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitProviderAndPartitionConstraintsForFilesIndex(String dataverseName, String datasetName, String targetIdxName, boolean create) throws AlgebricksException {
        FileSplit[] splits = this.splitsForFilesIndex(this.mdTxnCtx, dataverseName, datasetName, targetIdxName, create);
        return this.splitProviderAndPartitionConstraints(splits);
    }

    private FileSplit[] splitsForFilesIndex(MetadataTransactionContext mdTxnCtx, String dataverseName, String datasetName, String targetIdxName, boolean create) throws AlgebricksException {
        try {
            File relPathFile = new File(AqlMetadataProvider.getRelativePath(dataverseName, datasetName + "_idx_" + targetIdxName));
            Dataset dataset = MetadataManager.INSTANCE.getDataset(mdTxnCtx, dataverseName, datasetName);
            List<String> nodeGroup = MetadataManager.INSTANCE.getNodegroup(mdTxnCtx, dataset.getNodeGroupName()).getNodeNames();
            if (nodeGroup == null) {
                throw new AlgebricksException("Couldn't find node group " + dataset.getNodeGroupName());
            }
            ArrayList<FileSplit> splitArray = new ArrayList<FileSplit>();
            for (String nd : nodeGroup) {
                String[] nodeStores = this.stores.get(nd);
                if (nodeStores == null) {
                    LOGGER.warning("Node " + nd + " has no stores.");
                    throw new AlgebricksException("Node " + nd + " has no stores.");
                }
                String[] ioDevices = AsterixClusterProperties.INSTANCE.getIODevices(nd);
                if (create) {
                    for (int j = 0; j < nodeStores.length; ++j) {
                        File f = new File(ioDevices[0] + File.separator + nodeStores[j] + File.separator + relPathFile);
                        splitArray.add(new FileSplit(nd, new FileReference(f), 0));
                    }
                    continue;
                }
                int numIODevices = AsterixClusterProperties.INSTANCE.getNumberOfIODevices(nd);
                for (int j = 0; j < nodeStores.length; ++j) {
                    for (int k = 0; k < numIODevices; ++k) {
                        File f = new File(ioDevices[0] + File.separator + nodeStores[j] + File.separator + relPathFile);
                        splitArray.add(new FileSplit(nd, new FileReference(f), 0));
                    }
                }
            }
            FileSplit[] splits = new FileSplit[splitArray.size()];
            int i = 0;
            for (FileSplit fs : splitArray) {
                splits[i++] = fs;
            }
            return splits;
        }
        catch (MetadataException me) {
            throw new AlgebricksException((Throwable)((Object)me));
        }
    }

    public AsterixStorageProperties getStorageProperties() {
        return this.storageProperties;
    }

    public Map<String, Integer> getLocks() {
        return this.locks;
    }

    public void setLocks(Map<String, Integer> locks) {
        this.locks = locks;
    }
}

