/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.metadata.declared.AqlSourceId;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourcePropertiesProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.RandomPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.UnorderedPartitionedProperty;

public abstract class AqlDataSource
implements IDataSource<AqlSourceId> {
    private final AqlSourceId id;
    private final IAType itemType;
    private final AqlDataSourceType datasourceType;
    protected IAType[] schemaTypes;
    protected INodeDomain domain;
    private Map<String, Serializable> properties = new HashMap<String, Serializable>();

    public AqlDataSource(AqlSourceId id, String datasourceDataverse, String datasourceName, IAType itemType, AqlDataSourceType datasourceType) throws AlgebricksException {
        this.id = id;
        this.itemType = itemType;
        this.datasourceType = datasourceType;
    }

    public String getDatasourceDataverse() {
        return this.id.getDataverseName();
    }

    public String getDatasourceName() {
        return this.id.getDatasourceName();
    }

    public abstract IAType[] getSchemaTypes();

    public abstract INodeDomain getDomain();

    public void computeLocalStructuralProperties(List<ILocalStructuralProperty> localProps, List<LogicalVariable> variables) {
    }

    public AqlSourceId getId() {
        return this.id;
    }

    public String toString() {
        return this.id.toString();
    }

    public IDataSourcePropertiesProvider getPropertiesProvider() {
        return new AqlDataSourcePartitioningProvider(this, this.domain);
    }

    public void computeFDs(List<LogicalVariable> scanVariables, List<FunctionalDependency> fdList) {
        int n = scanVariables.size();
        if (n > 1) {
            ArrayList<LogicalVariable> head = new ArrayList<LogicalVariable>(scanVariables.subList(0, n - 1));
            ArrayList<LogicalVariable> tail = new ArrayList<LogicalVariable>(1);
            tail.addAll(scanVariables);
            FunctionalDependency fd = new FunctionalDependency(head, tail);
            fdList.add(fd);
        }
    }

    public AqlDataSourceType getDatasourceType() {
        return this.datasourceType;
    }

    public Map<String, Serializable> getProperties() {
        return this.properties;
    }

    public IAType getItemType() {
        return this.itemType;
    }

    public void setProperties(Map<String, Serializable> properties) {
        this.properties = properties;
    }

    private static class AqlDataSourcePartitioningProvider
    implements IDataSourcePropertiesProvider {
        private final AqlDataSource ds;
        private final INodeDomain domain;

        public AqlDataSourcePartitioningProvider(AqlDataSource dataSource, INodeDomain domain) {
            this.ds = dataSource;
            this.domain = domain;
        }

        public IPhysicalPropertiesVector computePropertiesVector(List<LogicalVariable> scanVariables) {
            StructuralPropertiesVector propsVector = null;
            switch (this.ds.getDatasourceType()) {
                case LOADABLE: 
                case EXTERNAL_DATASET: {
                    RandomPartitioningProperty pp = new RandomPartitioningProperty(this.domain);
                    ArrayList<ILocalStructuralProperty> propsLocal = new ArrayList<ILocalStructuralProperty>();
                    this.ds.computeLocalStructuralProperties(propsLocal, scanVariables);
                    propsVector = new StructuralPropertiesVector((IPartitioningProperty)pp, propsLocal);
                    break;
                }
                case FEED: {
                    RandomPartitioningProperty pp;
                    int n = scanVariables.size();
                    if (n < 2) {
                        pp = new RandomPartitioningProperty(this.domain);
                    } else {
                        ListSet pvars = new ListSet();
                        int i = 0;
                        for (LogicalVariable v : scanVariables) {
                            pvars.add(v);
                            if (++i < n - 1) continue;
                            break;
                        }
                        pp = new UnorderedPartitionedProperty((Set)pvars, this.domain);
                    }
                    ArrayList propsLocal = new ArrayList();
                    propsVector = new StructuralPropertiesVector((IPartitioningProperty)pp, propsLocal);
                    break;
                }
                case INTERNAL_DATASET: {
                    int i;
                    RandomPartitioningProperty pp;
                    int n = scanVariables.size();
                    if (n < 2) {
                        pp = new RandomPartitioningProperty(this.domain);
                    } else {
                        ListSet pvars = new ListSet();
                        i = 0;
                        for (LogicalVariable v : scanVariables) {
                            pvars.add(v);
                            if (++i < n - 1) continue;
                            break;
                        }
                        pp = new UnorderedPartitionedProperty((Set)pvars, this.domain);
                    }
                    ArrayList<LocalOrderProperty> propsLocal = new ArrayList<LocalOrderProperty>();
                    ArrayList<OrderColumn> orderColumns = new ArrayList<OrderColumn>();
                    for (i = 0; i < n - 1; ++i) {
                        orderColumns.add(new OrderColumn(scanVariables.get(i), OrderOperator.IOrder.OrderKind.ASC));
                    }
                    propsLocal.add(new LocalOrderProperty(orderColumns));
                    propsVector = new StructuralPropertiesVector((IPartitioningProperty)pp, propsLocal);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return propsVector;
        }
    }

    public static enum AqlDataSourceType {
        INTERNAL_DATASET,
        EXTERNAL_DATASET,
        FEED,
        LOADABLE;

    }
}

