/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.asterix.common.annotations.TypeDataGen;
import org.apache.asterix.common.config.AsterixMetadataProperties;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.formats.base.IDataFormat;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.api.IMetadataManager;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.AsterixAppContextInfo;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.data.IAWriterFactory;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.dataflow.std.file.ConstantFileSplitProvider;
import org.apache.hyracks.dataflow.std.file.FileSplit;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;

public class AqlCompiledMetadataDeclarations {
    private static Logger LOGGER = Logger.getLogger(AqlCompiledMetadataDeclarations.class.getName());
    private final MetadataTransactionContext mdTxnCtx;
    private String dataverseName = null;
    private FileSplit outputFile;
    private Map<String, String[]> stores;
    private IDataFormat format;
    private Map<String, String> config;
    private final Map<String, IAType> types;
    private final Map<String, TypeDataGen> typeDataGenMap;
    private final IAWriterFactory writerFactory;
    private IMetadataManager metadataManager = MetadataManager.INSTANCE;
    private boolean isConnected = false;

    public AqlCompiledMetadataDeclarations(MetadataTransactionContext mdTxnCtx, String dataverseName, FileSplit outputFile, Map<String, String> config, Map<String, String[]> stores, Map<String, IAType> types, Map<String, TypeDataGen> typeDataGenMap, IAWriterFactory writerFactory, boolean online) {
        this.mdTxnCtx = mdTxnCtx;
        this.dataverseName = dataverseName;
        this.outputFile = outputFile;
        this.config = config;
        AsterixMetadataProperties metadataProperties = AsterixAppContextInfo.getInstance().getMetadataProperties();
        this.stores = stores == null && online ? metadataProperties.getStores() : stores;
        this.types = types;
        this.typeDataGenMap = typeDataGenMap;
        this.writerFactory = writerFactory;
    }

    public void connectToDataverse(String dvName) throws AlgebricksException, AsterixException {
        Dataverse dv;
        if (this.isConnected) {
            throw new AlgebricksException("You are already connected to " + this.dataverseName + " dataverse");
        }
        try {
            dv = this.metadataManager.getDataverse(this.mdTxnCtx, dvName);
        }
        catch (Exception e) {
            throw new AsterixException((Throwable)e);
        }
        if (dv == null) {
            throw new AlgebricksException("There is no dataverse with this name " + dvName + " to connect to.");
        }
        this.dataverseName = dvName;
        this.isConnected = true;
        try {
            this.format = (IDataFormat)Class.forName(dv.getDataFormat()).newInstance();
        }
        catch (Exception e) {
            throw new AsterixException((Throwable)e);
        }
    }

    public void disconnectFromDataverse() throws AlgebricksException {
        if (!this.isConnected) {
            throw new AlgebricksException("You are not connected to any dataverse");
        }
        this.dataverseName = null;
        this.format = null;
        this.isConnected = false;
    }

    public boolean isConnectedToDataverse() {
        return this.isConnected;
    }

    public String getDataverseName() {
        return this.dataverseName;
    }

    public FileSplit getOutputFile() {
        return this.outputFile;
    }

    public IDataFormat getFormat() throws AlgebricksException {
        if (!this.isConnected) {
            throw new AlgebricksException("You need first to connect to a dataverse.");
        }
        return this.format;
    }

    public String getPropertyValue(String propertyName) {
        return this.config.get(propertyName);
    }

    public IAType findType(String typeName) {
        Datatype type;
        try {
            type = this.metadataManager.getDatatype(this.mdTxnCtx, this.dataverseName, typeName);
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
        if (type == null) {
            throw new IllegalStateException();
        }
        return type.getDatatype();
    }

    public List<String> findNodeGroupNodeNames(String nodeGroupName) throws AlgebricksException {
        NodeGroup ng;
        try {
            ng = this.metadataManager.getNodegroup(this.mdTxnCtx, nodeGroupName);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)((Object)e));
        }
        if (ng == null) {
            throw new AlgebricksException("No node group with this name " + nodeGroupName);
        }
        return ng.getNodeNames();
    }

    public Map<String, String[]> getAllStores() {
        return this.stores;
    }

    public Dataset findDataset(String datasetName) throws AlgebricksException {
        try {
            return this.metadataManager.getDataset(this.mdTxnCtx, this.dataverseName, datasetName);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)((Object)e));
        }
    }

    public List<Index> getDatasetIndexes(String dataverseName, String datasetName) throws AlgebricksException {
        try {
            return this.metadataManager.getDatasetIndexes(this.mdTxnCtx, dataverseName, datasetName);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)((Object)e));
        }
    }

    public Index getDatasetPrimaryIndex(String dataverseName, String datasetName) throws AlgebricksException {
        try {
            return this.metadataManager.getIndex(this.mdTxnCtx, dataverseName, datasetName, datasetName);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)((Object)e));
        }
    }

    public Index getIndex(String dataverseName, String datasetName, String indexName) throws AlgebricksException {
        try {
            return this.metadataManager.getIndex(this.mdTxnCtx, dataverseName, datasetName, indexName);
        }
        catch (MetadataException e) {
            throw new AlgebricksException((Throwable)((Object)e));
        }
    }

    public void setOutputFile(FileSplit outputFile) {
        this.outputFile = outputFile;
    }

    public Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitProviderAndPartitionConstraintsForInternalOrFeedDataset(String datasetName, String targetIdxName) throws AlgebricksException {
        FileSplit[] splits = this.splitsForInternalOrFeedDataset(datasetName, targetIdxName);
        ConstantFileSplitProvider splitProvider = new ConstantFileSplitProvider(splits);
        String[] loc = new String[splits.length];
        for (int p = 0; p < splits.length; ++p) {
            loc[p] = splits[p].getNodeName();
        }
        AlgebricksAbsolutePartitionConstraint pc = new AlgebricksAbsolutePartitionConstraint(loc);
        return new Pair((Object)splitProvider, (Object)pc);
    }

    private FileSplit[] splitsForInternalOrFeedDataset(String datasetName, String targetIdxName) throws AlgebricksException {
        File relPathFile = new File(this.getRelativePath(datasetName + "_idx_" + targetIdxName));
        Dataset dataset = this.findDataset(datasetName);
        if (dataset.getDatasetType() != DatasetConfig.DatasetType.INTERNAL) {
            throw new AlgebricksException("Not an internal dataset");
        }
        List<String> nodeGroup = this.findNodeGroupNodeNames(dataset.getNodeGroupName());
        if (nodeGroup == null) {
            throw new AlgebricksException("Couldn't find node group " + dataset.getNodeGroupName());
        }
        ArrayList<FileSplit> splitArray = new ArrayList<FileSplit>();
        for (String nd : nodeGroup) {
            String[] nodeStores = this.stores.get(nd);
            if (nodeStores == null) {
                LOGGER.warning("Node " + nd + " has no stores.");
                throw new AlgebricksException("Node " + nd + " has no stores.");
            }
            for (int j = 0; j < nodeStores.length; ++j) {
                File f = new File(nodeStores[j] + File.separator + relPathFile);
                splitArray.add(new FileSplit(nd, new FileReference(f)));
            }
        }
        FileSplit[] splits = new FileSplit[splitArray.size()];
        int i = 0;
        for (FileSplit fs : splitArray) {
            splits[i++] = fs;
        }
        return splits;
    }

    public String getRelativePath(String fileName) {
        return this.dataverseName + File.separator + fileName;
    }

    public Map<String, TypeDataGen> getTypeDataGenMap() {
        return this.typeDataGenMap;
    }

    public Map<String, IAType> getTypeDeclarations() {
        return this.types;
    }

    public IAWriterFactory getWriterFactory() {
        return this.writerFactory;
    }

    public MetadataTransactionContext getMetadataTransactionContext() {
        return this.mdTxnCtx;
    }
}

