/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.api.IAsterixAppRuntimeContext;
import org.apache.asterix.common.api.ILocalResourceMetadata;
import org.apache.asterix.common.config.AsterixMetadataProperties;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.common.config.IAsterixPropertiesProvider;
import org.apache.asterix.common.context.BaseOperationTracker;
import org.apache.asterix.common.context.DatasetLifecycleManager;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.ioopcallbacks.LSMBTreeIOOperationCallbackFactory;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.api.IMetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.bootstrap.MetadataSecondaryIndexes;
import org.apache.asterix.metadata.entities.AsterixBuiltinTypeMap;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.ExternalFile;
import org.apache.asterix.metadata.entities.FeedPolicy;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.entities.Node;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.metadata.external.IAdapterFactory;
import org.apache.asterix.metadata.feeds.AdapterIdentifier;
import org.apache.asterix.metadata.feeds.BuiltinFeedPolicies;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.transaction.management.resource.LSMBTreeLocalResourceMetadata;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceFactoryProvider;
import org.apache.hyracks.api.application.INCApplicationContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.storage.am.common.api.IIndex;
import org.apache.hyracks.storage.am.common.api.IIndexLifecycleManager;
import org.apache.hyracks.storage.am.common.util.IndexFileNameUtil;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTree;
import org.apache.hyracks.storage.am.lsm.btree.util.LSMBTreeUtils;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.file.IFileMapProvider;
import org.apache.hyracks.storage.common.file.ILocalResourceFactory;
import org.apache.hyracks.storage.common.file.ILocalResourceRepository;
import org.apache.hyracks.storage.common.file.LocalResource;

public class MetadataBootstrap {
    private static final Logger LOGGER = Logger.getLogger(MetadataBootstrap.class.getName());
    public static final boolean IS_DEBUG_MODE = false;
    private static IAsterixAppRuntimeContext runtimeContext;
    private static IBufferCache bufferCache;
    private static IFileMapProvider fileMapProvider;
    private static IIndexLifecycleManager indexLifecycleManager;
    private static ILocalResourceRepository localResourceRepository;
    private static IIOManager ioManager;
    private static String metadataNodeName;
    private static String metadataStore;
    private static Set<String> nodeNames;
    private static String outputDir;
    private static IMetadataIndex[] primaryIndexes;
    private static IMetadataIndex[] secondaryIndexes;
    private static IAsterixPropertiesProvider propertiesProvider;

    private static void initLocalIndexArrays() {
        primaryIndexes = new IMetadataIndex[]{MetadataPrimaryIndexes.DATAVERSE_DATASET, MetadataPrimaryIndexes.DATASET_DATASET, MetadataPrimaryIndexes.DATATYPE_DATASET, MetadataPrimaryIndexes.INDEX_DATASET, MetadataPrimaryIndexes.NODE_DATASET, MetadataPrimaryIndexes.NODEGROUP_DATASET, MetadataPrimaryIndexes.FUNCTION_DATASET, MetadataPrimaryIndexes.DATASOURCE_ADAPTER_DATASET, MetadataPrimaryIndexes.FEED_DATASET, MetadataPrimaryIndexes.FEED_POLICY_DATASET, MetadataPrimaryIndexes.LIBRARY_DATASET, MetadataPrimaryIndexes.COMPACTION_POLICY_DATASET, MetadataPrimaryIndexes.EXTERNAL_FILE_DATASET};
        secondaryIndexes = new IMetadataIndex[]{MetadataSecondaryIndexes.GROUPNAME_ON_DATASET_INDEX, MetadataSecondaryIndexes.DATATYPENAME_ON_DATASET_INDEX, MetadataSecondaryIndexes.DATATYPENAME_ON_DATATYPE_INDEX};
    }

    public static void startUniverse(IAsterixPropertiesProvider asterixPropertiesProvider, INCApplicationContext ncApplicationContext, boolean isNewUniverse) throws Exception {
        runtimeContext = (IAsterixAppRuntimeContext)ncApplicationContext.getApplicationObject();
        propertiesProvider = asterixPropertiesProvider;
        MetadataRecordTypes.init();
        MetadataPrimaryIndexes.init();
        MetadataSecondaryIndexes.init();
        MetadataBootstrap.initLocalIndexArrays();
        AsterixMetadataProperties metadataProperties = propertiesProvider.getMetadataProperties();
        metadataNodeName = metadataProperties.getMetadataNodeName();
        metadataStore = metadataProperties.getMetadataStore();
        nodeNames = metadataProperties.getNodeNames();
        indexLifecycleManager = runtimeContext.getIndexLifecycleManager();
        localResourceRepository = runtimeContext.getLocalResourceRepository();
        bufferCache = runtimeContext.getBufferCache();
        fileMapProvider = runtimeContext.getFileMapManager();
        ioManager = ncApplicationContext.getRootContext().getIOManager();
        MetadataTransactionContext mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
        try {
            MetadataManager.INSTANCE.lock(mdTxnCtx, (byte)4);
            if (isNewUniverse) {
                int i;
                for (i = 0; i < primaryIndexes.length; ++i) {
                    MetadataBootstrap.enlistMetadataDataset(primaryIndexes[i], true, mdTxnCtx);
                }
                for (i = 0; i < secondaryIndexes.length; ++i) {
                    MetadataBootstrap.enlistMetadataDataset(secondaryIndexes[i], true, mdTxnCtx);
                }
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Finished enlistment of metadata B-trees in  new universe");
                }
                MetadataBootstrap.insertInitialDataverses(mdTxnCtx);
                MetadataBootstrap.insertInitialDatasets(mdTxnCtx);
                MetadataBootstrap.insertInitialDatatypes(mdTxnCtx);
                MetadataBootstrap.insertInitialIndexes(mdTxnCtx);
                MetadataBootstrap.insertNodes(mdTxnCtx);
                MetadataBootstrap.insertInitialGroups(mdTxnCtx);
                MetadataBootstrap.insertInitialAdapters(mdTxnCtx);
                MetadataBootstrap.insertInitialFeedPolicies(mdTxnCtx);
                MetadataBootstrap.insertInitialCompactionPolicies(mdTxnCtx);
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Finished creating metadata B-trees.");
                }
            } else {
                int i;
                for (i = 0; i < primaryIndexes.length; ++i) {
                    MetadataBootstrap.enlistMetadataDataset(primaryIndexes[i], false, mdTxnCtx);
                }
                for (i = 0; i < secondaryIndexes.length; ++i) {
                    MetadataBootstrap.enlistMetadataDataset(secondaryIndexes[i], false, mdTxnCtx);
                }
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Finished enlistment of metadata B-trees in old universe.");
                }
            }
            MetadataManager.INSTANCE.initializeDatasetIdFactory(mdTxnCtx);
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
        }
        catch (Exception e) {
            try {
                MetadataManager.INSTANCE.abortTransaction(mdTxnCtx);
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
                throw new MetadataException(e);
            }
            throw e;
        }
    }

    public static void stopUniverse() throws HyracksDataException {
    }

    public static void insertInitialDataverses(MetadataTransactionContext mdTxnCtx) throws Exception {
        String dataverseName = MetadataPrimaryIndexes.DATAVERSE_DATASET.getDataverseName();
        String dataFormat = "org.apache.asterix.runtime.formats.NonTaggedDataFormat";
        MetadataManager.INSTANCE.addDataverse(mdTxnCtx, new Dataverse(dataverseName, dataFormat, 0));
    }

    public static void insertInitialDatasets(MetadataTransactionContext mdTxnCtx) throws Exception {
        for (int i = 0; i < primaryIndexes.length; ++i) {
            InternalDatasetDetails id = new InternalDatasetDetails(InternalDatasetDetails.FileStructure.BTREE, InternalDatasetDetails.PartitioningStrategy.HASH, primaryIndexes[i].getPartitioningExpr(), primaryIndexes[i].getPartitioningExpr(), primaryIndexes[i].getPartitioningExprType(), false, null, false);
            MetadataManager.INSTANCE.addDataset(mdTxnCtx, new Dataset(primaryIndexes[i].getDataverseName(), primaryIndexes[i].getIndexedDatasetName(), primaryIndexes[i].getPayloadRecordType().getTypeName(), primaryIndexes[i].getNodeGroupName(), "prefix", GlobalConfig.DEFAULT_COMPACTION_POLICY_PROPERTIES, id, new HashMap<String, String>(), DatasetConfig.DatasetType.INTERNAL, primaryIndexes[i].getDatasetId().getId(), 0));
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Finished inserting initial datasets.");
        }
    }

    public static void getBuiltinTypes(ArrayList<IAType> types) throws Exception {
        Collection<BuiltinType> builtinTypes = AsterixBuiltinTypeMap.getBuiltinTypes().values();
        Iterator<BuiltinType> iter = builtinTypes.iterator();
        while (iter.hasNext()) {
            types.add((IAType)iter.next());
        }
    }

    public static void getMetadataTypes(ArrayList<IAType> types) throws Exception {
        for (int i = 0; i < primaryIndexes.length; ++i) {
            types.add((IAType)primaryIndexes[i].getPayloadRecordType());
        }
    }

    public static void insertInitialDatatypes(MetadataTransactionContext mdTxnCtx) throws Exception {
        String dataverseName = MetadataPrimaryIndexes.DATAVERSE_DATASET.getDataverseName();
        ArrayList<IAType> types = new ArrayList<IAType>();
        MetadataBootstrap.getBuiltinTypes(types);
        MetadataBootstrap.getMetadataTypes(types);
        for (int i = 0; i < types.size(); ++i) {
            MetadataManager.INSTANCE.addDatatype(mdTxnCtx, new Datatype(dataverseName, types.get(i).getTypeName(), types.get(i), false));
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Finished inserting initial datatypes.");
        }
    }

    public static void insertInitialIndexes(MetadataTransactionContext mdTxnCtx) throws Exception {
        for (int i = 0; i < secondaryIndexes.length; ++i) {
            MetadataManager.INSTANCE.addIndex(mdTxnCtx, new Index(secondaryIndexes[i].getDataverseName(), secondaryIndexes[i].getIndexedDatasetName(), secondaryIndexes[i].getIndexName(), DatasetConfig.IndexType.BTREE, secondaryIndexes[i].getPartitioningExpr(), secondaryIndexes[i].getPartitioningExprType(), false, false, 0));
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Finished inserting initial indexes.");
        }
    }

    public static void insertNodes(MetadataTransactionContext mdTxnCtx) throws Exception {
        Iterator<String> iter = nodeNames.iterator();
        while (iter.hasNext()) {
            MetadataManager.INSTANCE.addNode(mdTxnCtx, new Node(iter.next(), 0L, 0L));
        }
    }

    public static void insertInitialGroups(MetadataTransactionContext mdTxnCtx) throws Exception {
        String groupName = MetadataPrimaryIndexes.DATAVERSE_DATASET.getNodeGroupName();
        ArrayList<String> metadataGroupNodeNames = new ArrayList<String>();
        metadataGroupNodeNames.add(metadataNodeName);
        NodeGroup groupRecord = new NodeGroup(groupName, metadataGroupNodeNames);
        MetadataManager.INSTANCE.addNodegroup(mdTxnCtx, groupRecord);
        ArrayList<String> nodes = new ArrayList<String>();
        nodes.addAll(nodeNames);
        NodeGroup defaultGroup = new NodeGroup("DEFAULT_NG_ALL_NODES", nodes);
        MetadataManager.INSTANCE.addNodegroup(mdTxnCtx, defaultGroup);
    }

    private static void insertInitialAdapters(MetadataTransactionContext mdTxnCtx) throws Exception {
        String[] builtInAdapterClassNames;
        for (String adapterClassName : builtInAdapterClassNames = new String[]{"org.apache.asterix.external.adapter.factory.PullBasedAzureTwitterAdapterFactory", "org.apache.asterix.external.adapter.factory.NCFileSystemAdapterFactory", "org.apache.asterix.external.adapter.factory.HDFSAdapterFactory", "org.apache.asterix.external.adapter.factory.HiveAdapterFactory", "org.apache.asterix.external.adapter.factory.PullBasedTwitterAdapterFactory", "org.apache.asterix.external.adapter.factory.PushBasedTwitterAdapterFactory", "org.apache.asterix.external.adapter.factory.RSSFeedAdapterFactory", "org.apache.asterix.external.adapter.factory.CNNFeedAdapterFactory", "org.apache.asterix.tools.external.data.RateControlledFileSystemBasedAdapterFactory", "org.apache.asterix.tools.external.data.TwitterFirehoseFeedAdapterFactory", "org.apache.asterix.tools.external.data.GenericSocketFeedAdapterFactory", "org.apache.asterix.tools.external.data.SocketClientAdapterFactory"}) {
            DatasourceAdapter adapter = MetadataBootstrap.getAdapter(adapterClassName);
            MetadataManager.INSTANCE.addAdapter(mdTxnCtx, adapter);
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Finished inserting built-in adapters.");
        }
    }

    private static void insertInitialFeedPolicies(MetadataTransactionContext mdTxnCtx) throws Exception {
        for (FeedPolicy feedPolicy : BuiltinFeedPolicies.policies) {
            MetadataManager.INSTANCE.addFeedPolicy(mdTxnCtx, feedPolicy);
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Finished adding built-in feed policies.");
        }
    }

    private static void insertInitialCompactionPolicies(MetadataTransactionContext mdTxnCtx) throws Exception {
        String[] builtInCompactionPolicyClassNames;
        for (String policyClassName : builtInCompactionPolicyClassNames = new String[]{"org.apache.hyracks.storage.am.lsm.common.impls.ConstantMergePolicyFactory", "org.apache.hyracks.storage.am.lsm.common.impls.PrefixMergePolicyFactory", "org.apache.hyracks.storage.am.lsm.common.impls.NoMergePolicyFactory", "org.apache.asterix.common.context.CorrelatedPrefixMergePolicyFactory"}) {
            CompactionPolicy compactionPolicy = MetadataBootstrap.getCompactionPolicyEntity(policyClassName);
            MetadataManager.INSTANCE.addCompactionPolicy(mdTxnCtx, compactionPolicy);
        }
    }

    private static DatasourceAdapter getAdapter(String adapterFactoryClassName) throws Exception {
        String adapterName = ((IAdapterFactory)Class.forName(adapterFactoryClassName).newInstance()).getName();
        return new DatasourceAdapter(new AdapterIdentifier("Metadata", adapterName), adapterFactoryClassName, DatasourceAdapter.AdapterType.INTERNAL);
    }

    private static CompactionPolicy getCompactionPolicyEntity(String compactionPolicyClassName) throws Exception {
        String policyName = ((ILSMMergePolicyFactory)Class.forName(compactionPolicyClassName).newInstance()).getName();
        return new CompactionPolicy("Metadata", policyName, compactionPolicyClassName);
    }

    private static void enlistMetadataDataset(IMetadataIndex index, boolean create, MetadataTransactionContext mdTxnCtx) throws Exception {
        String filePath = ((IODeviceHandle)ioManager.getIODevices().get(runtimeContext.getMetaDataIODeviceId())).getPath() + File.separator + IndexFileNameUtil.prepareFileName((String)(metadataStore + File.separator + index.getFileNameRelativePath()), (int)runtimeContext.getMetaDataIODeviceId());
        FileReference file = new FileReference(new File(filePath));
        List virtualBufferCaches = runtimeContext.getVirtualBufferCaches(index.getDatasetId().getId());
        ITypeTraits[] typeTraits = index.getTypeTraits();
        IBinaryComparatorFactory[] comparatorFactories = index.getKeyBinaryComparatorFactory();
        int[] bloomFilterKeyFields = index.getBloomFilterKeyFields();
        LSMBTree lsmBtree = null;
        long resourceID = -1L;
        BaseOperationTracker opTracker = index.isPrimaryIndex() ? runtimeContext.getLSMBTreeOperationTracker(index.getDatasetId().getId()) : new BaseOperationTracker((DatasetLifecycleManager)indexLifecycleManager, index.getDatasetId().getId(), ((DatasetLifecycleManager)indexLifecycleManager).getDatasetInfo(index.getDatasetId().getId()));
        String path = file.getFile().getPath();
        if (create) {
            lsmBtree = LSMBTreeUtils.createLSMTree((List)virtualBufferCaches, (FileReference)file, (IBufferCache)bufferCache, (IFileMapProvider)fileMapProvider, (ITypeTraits[])typeTraits, (IBinaryComparatorFactory[])comparatorFactories, (int[])bloomFilterKeyFields, (double)runtimeContext.getBloomFilterFalsePositiveRate(), (ILSMMergePolicy)runtimeContext.getMetadataMergePolicyFactory().createMergePolicy(GlobalConfig.DEFAULT_COMPACTION_POLICY_PROPERTIES, indexLifecycleManager), (ILSMOperationTracker)opTracker, (ILSMIOOperationScheduler)runtimeContext.getLSMIOScheduler(), (ILSMIOOperationCallback)LSMBTreeIOOperationCallbackFactory.INSTANCE.createIOOperationCallback(), (boolean)index.isPrimaryIndex(), null, null, null, null, (boolean)true);
            lsmBtree.create();
            resourceID = runtimeContext.getResourceIdFactory().createId();
            LSMBTreeLocalResourceMetadata localResourceMetadata = new LSMBTreeLocalResourceMetadata(typeTraits, comparatorFactories, bloomFilterKeyFields, index.isPrimaryIndex(), index.getDatasetId().getId(), runtimeContext.getMetadataMergePolicyFactory(), GlobalConfig.DEFAULT_COMPACTION_POLICY_PROPERTIES, null, null, null, null);
            PersistentLocalResourceFactoryProvider localResourceFactoryProvider = new PersistentLocalResourceFactoryProvider((ILocalResourceMetadata)localResourceMetadata, 1);
            ILocalResourceFactory localResourceFactory = localResourceFactoryProvider.getLocalResourceFactory();
            localResourceRepository.insert(localResourceFactory.createLocalResource(resourceID, path, 0));
            indexLifecycleManager.register(resourceID, (IIndex)lsmBtree);
        } else {
            LocalResource resource = localResourceRepository.getResourceByName(path);
            resourceID = resource.getResourceId();
            lsmBtree = (LSMBTree)indexLifecycleManager.getIndex(resourceID);
            if (lsmBtree == null) {
                lsmBtree = LSMBTreeUtils.createLSMTree((List)virtualBufferCaches, (FileReference)file, (IBufferCache)bufferCache, (IFileMapProvider)fileMapProvider, (ITypeTraits[])typeTraits, (IBinaryComparatorFactory[])comparatorFactories, (int[])bloomFilterKeyFields, (double)runtimeContext.getBloomFilterFalsePositiveRate(), (ILSMMergePolicy)runtimeContext.getMetadataMergePolicyFactory().createMergePolicy(GlobalConfig.DEFAULT_COMPACTION_POLICY_PROPERTIES, indexLifecycleManager), (ILSMOperationTracker)opTracker, (ILSMIOOperationScheduler)runtimeContext.getLSMIOScheduler(), (ILSMIOOperationCallback)LSMBTreeIOOperationCallbackFactory.INSTANCE.createIOOperationCallback(), (boolean)index.isPrimaryIndex(), null, null, null, null, (boolean)true);
                indexLifecycleManager.register(resourceID, (IIndex)lsmBtree);
            }
        }
        index.setResourceID(resourceID);
        index.setFile(file);
    }

    public static String getOutputDir() {
        return outputDir;
    }

    public static String getMetadataNodeName() {
        return metadataNodeName;
    }

    public static void startDDLRecovery() throws RemoteException, ACIDException, MetadataException {
        String dataverseName = null;
        String datasetName = null;
        String indexName = null;
        MetadataTransactionContext mdTxnCtx = null;
        MetadataManager.INSTANCE.acquireWriteLatch();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Starting DDL recovery ...");
        }
        try {
            mdTxnCtx = MetadataManager.INSTANCE.beginTransaction();
            List<Dataverse> dataverses = MetadataManager.INSTANCE.getDataverses(mdTxnCtx);
            for (Dataverse dataverse : dataverses) {
                dataverseName = dataverse.getDataverseName();
                if (dataverse.getPendingOp() != 0) {
                    MetadataManager.INSTANCE.dropDataverse(mdTxnCtx, dataverseName);
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.info("Dropped a pending dataverse: " + dataverseName);
                    continue;
                }
                List<Dataset> datasets = MetadataManager.INSTANCE.getDataverseDatasets(mdTxnCtx, dataverseName);
                for (Dataset dataset : datasets) {
                    List<Index> indexes;
                    datasetName = dataset.getDatasetName();
                    if (dataset.getPendingOp() != 0) {
                        MetadataManager.INSTANCE.dropDataset(mdTxnCtx, dataverseName, datasetName);
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.info("Dropped a pending dataset: " + dataverseName + "." + datasetName);
                        }
                    } else {
                        indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataverseName, datasetName);
                        for (Index index : indexes) {
                            indexName = index.getIndexName();
                            if (index.getPendingOp() == 0) continue;
                            MetadataManager.INSTANCE.dropIndex(mdTxnCtx, dataverseName, datasetName, indexName);
                            if (!LOGGER.isLoggable(Level.INFO)) continue;
                            LOGGER.info("Dropped a pending index: " + dataverseName + "." + datasetName + "." + indexName);
                        }
                    }
                    if (dataset.getDatasetType() != DatasetConfig.DatasetType.EXTERNAL || (indexes = MetadataManager.INSTANCE.getDatasetIndexes(mdTxnCtx, dataverseName, datasetName)).size() != 0) continue;
                    List<ExternalFile> files = MetadataManager.INSTANCE.getDatasetExternalFiles(mdTxnCtx, dataset);
                    for (ExternalFile file : files) {
                        MetadataManager.INSTANCE.dropExternalFile(mdTxnCtx, file);
                        if (!LOGGER.isLoggable(Level.INFO)) continue;
                        LOGGER.info("Dropped an external file: " + dataverseName + "." + datasetName + "." + file.getFileNumber());
                    }
                }
            }
            MetadataManager.INSTANCE.commitTransaction(mdTxnCtx);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Completed DDL recovery.");
            }
        }
        catch (Exception e) {
            try {
                MetadataManager.INSTANCE.abortTransaction(mdTxnCtx);
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
            }
            throw new MetadataException(e);
        }
        finally {
            MetadataManager.INSTANCE.releaseWriteLatch();
        }
    }
}

