/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.Logger;
import org.apache.asterix.metadata.api.IAsterixStateProxy;
import org.apache.asterix.metadata.api.IMetadataNode;

public class AsterixStateProxy
implements IAsterixStateProxy {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(AsterixStateProxy.class.getName());
    private IMetadataNode metadataNode;
    private static final IAsterixStateProxy cc = new AsterixStateProxy();

    public static IAsterixStateProxy registerRemoteObject() throws RemoteException {
        IAsterixStateProxy stub = (IAsterixStateProxy)UnicastRemoteObject.exportObject((Remote)cc, 0);
        LOGGER.info("Asterix Distributed State Proxy Bound");
        return stub;
    }

    public static void unregisterRemoteObject() throws RemoteException {
        UnicastRemoteObject.unexportObject(cc, true);
        LOGGER.info("Asterix Distributed State Proxy Unbound");
    }

    @Override
    public void setMetadataNode(IMetadataNode metadataNode) throws RemoteException {
        this.metadataNode = metadataNode;
    }

    @Override
    public IMetadataNode getMetadataNode() throws RemoteException {
        return this.metadataNode;
    }
}

