/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.api;

import java.rmi.RemoteException;
import java.util.List;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.metadata.MetadataException;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.ExternalFile;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedPolicy;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.Library;
import org.apache.asterix.metadata.entities.Node;
import org.apache.asterix.metadata.entities.NodeGroup;

public interface IMetadataManager {
    public void init() throws RemoteException, MetadataException;

    public MetadataTransactionContext beginTransaction() throws ACIDException, RemoteException;

    public void commitTransaction(MetadataTransactionContext var1) throws ACIDException, RemoteException;

    public void abortTransaction(MetadataTransactionContext var1) throws ACIDException, RemoteException;

    public void lock(MetadataTransactionContext var1, byte var2) throws ACIDException, RemoteException;

    public void unlock(MetadataTransactionContext var1, byte var2) throws ACIDException, RemoteException;

    public void addDataverse(MetadataTransactionContext var1, Dataverse var2) throws MetadataException;

    public List<Dataverse> getDataverses(MetadataTransactionContext var1) throws MetadataException;

    public Dataverse getDataverse(MetadataTransactionContext var1, String var2) throws MetadataException;

    public List<Dataset> getDataverseDatasets(MetadataTransactionContext var1, String var2) throws MetadataException;

    public void dropDataverse(MetadataTransactionContext var1, String var2) throws MetadataException;

    public void addDataset(MetadataTransactionContext var1, Dataset var2) throws MetadataException;

    public Dataset getDataset(MetadataTransactionContext var1, String var2, String var3) throws MetadataException;

    public List<Index> getDatasetIndexes(MetadataTransactionContext var1, String var2, String var3) throws MetadataException;

    public void dropDataset(MetadataTransactionContext var1, String var2, String var3) throws MetadataException;

    public void addIndex(MetadataTransactionContext var1, Index var2) throws MetadataException;

    public Index getIndex(MetadataTransactionContext var1, String var2, String var3, String var4) throws MetadataException;

    public void dropIndex(MetadataTransactionContext var1, String var2, String var3, String var4) throws MetadataException;

    public void addDatatype(MetadataTransactionContext var1, Datatype var2) throws MetadataException;

    public Datatype getDatatype(MetadataTransactionContext var1, String var2, String var3) throws MetadataException;

    public void dropDatatype(MetadataTransactionContext var1, String var2, String var3) throws MetadataException;

    public void addNodegroup(MetadataTransactionContext var1, NodeGroup var2) throws MetadataException;

    public NodeGroup getNodegroup(MetadataTransactionContext var1, String var2) throws MetadataException;

    public void dropNodegroup(MetadataTransactionContext var1, String var2) throws MetadataException;

    public void addNode(MetadataTransactionContext var1, Node var2) throws MetadataException;

    public void addFunction(MetadataTransactionContext var1, Function var2) throws MetadataException;

    public Function getFunction(MetadataTransactionContext var1, FunctionSignature var2) throws MetadataException;

    public void dropFunction(MetadataTransactionContext var1, FunctionSignature var2) throws MetadataException;

    public void addAdapter(MetadataTransactionContext var1, DatasourceAdapter var2) throws MetadataException;

    public DatasourceAdapter getAdapter(MetadataTransactionContext var1, String var2, String var3) throws MetadataException;

    public void dropAdapter(MetadataTransactionContext var1, String var2, String var3) throws MetadataException;

    public void addCompactionPolicy(MetadataTransactionContext var1, CompactionPolicy var2) throws MetadataException;

    public CompactionPolicy getCompactionPolicy(MetadataTransactionContext var1, String var2, String var3) throws MetadataException;

    public List<Function> getDataverseFunctions(MetadataTransactionContext var1, String var2) throws MetadataException;

    public void addFeed(MetadataTransactionContext var1, Feed var2) throws MetadataException;

    public Feed getFeed(MetadataTransactionContext var1, String var2, String var3) throws MetadataException;

    public void dropFeed(MetadataTransactionContext var1, String var2, String var3) throws MetadataException;

    public void addFeedPolicy(MetadataTransactionContext var1, FeedPolicy var2) throws MetadataException;

    public FeedPolicy getFeedPolicy(MetadataTransactionContext var1, String var2, String var3) throws MetadataException;

    public void initializeDatasetIdFactory(MetadataTransactionContext var1) throws MetadataException;

    public int getMostRecentDatasetId() throws MetadataException;

    public void acquireWriteLatch();

    public void releaseWriteLatch();

    public void acquireReadLatch();

    public void releaseReadLatch();

    public void dropLibrary(MetadataTransactionContext var1, String var2, String var3) throws MetadataException;

    public void addLibrary(MetadataTransactionContext var1, Library var2) throws MetadataException;

    public Library getLibrary(MetadataTransactionContext var1, String var2, String var3) throws MetadataException, RemoteException;

    public List<Library> getDataverseLibraries(MetadataTransactionContext var1, String var2) throws MetadataException;

    public void addExternalFile(MetadataTransactionContext var1, ExternalFile var2) throws MetadataException;

    public List<ExternalFile> getDatasetExternalFiles(MetadataTransactionContext var1, Dataset var2) throws MetadataException;

    public void dropExternalFile(MetadataTransactionContext var1, ExternalFile var2) throws MetadataException;

    public void dropDatasetExternalFiles(MetadataTransactionContext var1, Dataset var2) throws MetadataException;

    public ExternalFile getExternalFile(MetadataTransactionContext var1, String var2, String var3, Integer var4) throws MetadataException;

    public void updateDataset(MetadataTransactionContext var1, Dataset var2) throws MetadataException;

    public void cleanupTempDatasets() throws MetadataException;
}

